/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.data;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.core.data.ServiceDocumentImpl;
import org.apache.olingo.client.core.data.ServiceDocumentItemImpl;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;

public class XMLServiceDocumentDeserializer
extends JsonDeserializer {
    public XMLServiceDocumentDeserializer(boolean serverMode) {
        super(serverMode);
    }

    private String getName(JsonParser jp) throws IOException {
        String title = jp.nextTextValue();
        if (title == null) {
            jp.nextToken();
            jp.nextToken();
            jp.nextToken();
            title = jp.nextTextValue();
        }
        return title;
    }

    private ServiceDocumentItemImpl deserializeElement(JsonParser jp, String elementName) throws IOException {
        ServiceDocumentItemImpl element = new ServiceDocumentItemImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT || !elementName.equals(((FromXmlParser)jp).getStaxReader().getLocalName())) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("href".equals(jp.getCurrentName())) {
                    element.setUrl(jp.nextTextValue());
                } else if ("title".equals(jp.getCurrentName())) {
                    element.setName(this.getName(jp));
                }
            }
            jp.nextToken();
        }
        return element;
    }

    protected ResWrap<ServiceDocument> doDeserialize(JsonParser jp) throws IOException {
        ServiceDocumentImpl sdoc = new ServiceDocumentImpl();
        URI contextURL = null;
        String metadataETag = null;
        String base = null;
        while (jp.getCurrentToken() != JsonToken.END_OBJECT || !"service".equals(((FromXmlParser)jp).getStaxReader().getLocalName())) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("base".equals(jp.getCurrentName())) {
                    base = jp.nextTextValue();
                } else if ("context".equals(jp.getCurrentName())) {
                    contextURL = URI.create(jp.nextTextValue());
                } else if ("metadata-etag".equals(jp.getCurrentName())) {
                    metadataETag = jp.nextTextValue();
                } else if ("workspace".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    jp.nextToken();
                    if ("title".equals(jp.getCurrentName())) {
                        sdoc.setTitle(this.getName(jp));
                    }
                } else if ("collection".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    sdoc.getEntitySets().add(this.deserializeElement(jp, "collection"));
                } else if ("function-import".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    sdoc.getFunctionImports().add(this.deserializeElement(jp, "function-import"));
                } else if ("singleton".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    sdoc.getSingletons().add(this.deserializeElement(jp, "singleton"));
                } else if ("service-document".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    sdoc.getRelatedServiceDocuments().add(this.deserializeElement(jp, "service-document"));
                }
            }
            jp.nextToken();
        }
        sdoc.setMetadata((contextURL == null ? URIUtils.getURI(base, "$metadata") : URIUtils.getURI(base, contextURL.toASCIIString())).toASCIIString());
        return new ResWrap(contextURL == null ? null : URIUtils.getURI(sdoc.getBaseURI(), contextURL), metadataETag, (Object)sdoc);
    }

    public ResWrap<ServiceDocument> toServiceDocument(InputStream input) throws ODataDeserializerException {
        try {
            JsonParser parser = new XmlFactory().createParser(input);
            return this.doDeserialize(parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }
}

