/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.client.api.domain.AbstractClientValue;
import org.apache.olingo.client.api.domain.ClientCollectionValue;
import org.apache.olingo.client.api.domain.ClientEnumValue;
import org.apache.olingo.client.api.domain.ClientValue;

public class ClientCollectionValueImpl<OV extends ClientValue>
extends AbstractClientValue
implements ClientCollectionValue<OV>,
ClientValue {
    protected final List<OV> values = new ArrayList<OV>();

    public ClientCollectionValueImpl(String typeName) {
        super(typeName == null || typeName.startsWith("Collection(") ? typeName : "Collection(" + typeName + ")");
    }

    public boolean isEnum() {
        return false;
    }

    public ClientEnumValue asEnum() {
        return null;
    }

    public boolean isComplex() {
        return false;
    }

    public Collection<Object> asJavaCollection() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ClientValue value : this.values) {
            if (value.isPrimitive()) {
                result.add(value.asPrimitive().toValue());
                continue;
            }
            if (value.isComplex()) {
                result.add(value.asComplex().asJavaMap());
                continue;
            }
            if (value.isCollection()) {
                result.add(value.asCollection().asJavaCollection());
                continue;
            }
            if (!value.isEnum()) continue;
            result.add(value.asEnum().toString());
        }
        return result;
    }

    public ClientCollectionValue<OV> add(ClientValue value) {
        this.values.add(value);
        return this;
    }

    public Iterator<OV> iterator() {
        return this.values.iterator();
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }
}

