/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.domain.AbstractClientValue;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientEnumValue;
import org.apache.olingo.client.api.domain.ClientLink;
import org.apache.olingo.client.api.domain.ClientProperty;

public class ClientComplexValueImpl
extends AbstractClientValue
implements ClientComplexValue {
    private final List<ClientLink> navigationLinks = new ArrayList<ClientLink>();
    private final List<ClientLink> associationLinks = new ArrayList<ClientLink>();
    private final List<ClientAnnotation> annotations = new ArrayList<ClientAnnotation>();
    private final Map<String, ClientProperty> fields = new LinkedHashMap<String, ClientProperty>();

    public ClientComplexValueImpl(String typeName) {
        super(typeName);
    }

    public boolean isEnum() {
        return false;
    }

    public ClientEnumValue asEnum() {
        return null;
    }

    public boolean isComplex() {
        return true;
    }

    public boolean addLink(ClientLink link) {
        boolean result = false;
        switch (link.getType()) {
            case ASSOCIATION: {
                result = this.associationLinks.contains(link) ? false : this.associationLinks.add(link);
                break;
            }
            case ENTITY_NAVIGATION: 
            case ENTITY_SET_NAVIGATION: {
                result = this.navigationLinks.contains(link) ? false : this.navigationLinks.add(link);
                break;
            }
            case MEDIA_EDIT: {
                throw new IllegalArgumentException("Complex values cannot have media links!");
            }
        }
        return result;
    }

    public boolean removeLink(ClientLink link) {
        return this.associationLinks.remove(link) || this.navigationLinks.remove(link);
    }

    private ClientLink getLink(List<ClientLink> links, String name) {
        ClientLink result = null;
        for (ClientLink link : links) {
            if (!name.equals(link.getName())) continue;
            result = link;
            break;
        }
        return result;
    }

    public ClientLink getNavigationLink(String name) {
        return this.getLink(this.navigationLinks, name);
    }

    public List<ClientLink> getNavigationLinks() {
        return this.navigationLinks;
    }

    public ClientLink getAssociationLink(String name) {
        return this.getLink(this.associationLinks, name);
    }

    public List<ClientLink> getAssociationLinks() {
        return this.associationLinks;
    }

    public Map<String, Object> asJavaMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ClientProperty> entry : this.fields.entrySet()) {
            Object value = null;
            if (entry.getValue().hasPrimitiveValue()) {
                value = entry.getValue().getPrimitiveValue().toValue();
            } else if (entry.getValue().hasComplexValue()) {
                value = entry.getValue().getComplexValue().asJavaMap();
            } else if (entry.getValue().hasCollectionValue()) {
                value = entry.getValue().getCollectionValue().asJavaCollection();
            } else if (entry.getValue().hasEnumValue()) {
                value = entry.getValue().getEnumValue().toString();
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public List<ClientAnnotation> getAnnotations() {
        return this.annotations;
    }

    public ClientComplexValue add(ClientProperty field) {
        this.fields.put(field.getName(), field);
        return this;
    }

    public ClientProperty get(String name) {
        return this.fields.get(name);
    }

    public Iterator<ClientProperty> iterator() {
        return this.fields.values().iterator();
    }

    public int size() {
        return this.fields.size();
    }
}

