/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import java.util.UUID;
import org.apache.olingo.client.api.domain.AbstractClientValue;
import org.apache.olingo.client.api.domain.ClientEnumValue;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class ClientPrimitiveValueImpl
extends AbstractClientValue
implements ClientValue,
ClientPrimitiveValue {
    private EdmPrimitiveTypeKind typeKind;
    private EdmPrimitiveType type;
    private Object value;

    protected ClientPrimitiveValueImpl() {
        super(null);
    }

    public String getTypeName() {
        return this.typeKind.getFullQualifiedName().toString();
    }

    public EdmPrimitiveTypeKind getTypeKind() {
        return this.typeKind;
    }

    public EdmPrimitiveType getType() {
        return this.type;
    }

    public Object toValue() {
        return this.value;
    }

    public <T> T toCastValue(Class<T> reference) throws EdmPrimitiveTypeException {
        if (this.value == null) {
            return null;
        }
        if (this.typeKind.isGeospatial()) {
            return reference.cast(this.value);
        }
        return (T)this.type.valueOfString(this.type.valueToString(this.value, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null, reference);
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.typeKind.isGeospatial()) {
            return this.value.toString();
        }
        try {
            return this.type.valueToString(this.value, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isEnum() {
        return false;
    }

    public ClientEnumValue asEnum() {
        return null;
    }

    public boolean isComplex() {
        return false;
    }

    public static class BuilderImpl
    implements ClientPrimitiveValue.Builder {
        private final ClientPrimitiveValueImpl instance = new ClientPrimitiveValueImpl();

        public BuilderImpl setType(EdmType type) {
            EdmPrimitiveTypeKind primitiveTypeKind = null;
            if (type != null) {
                if (type.getKind() != EdmTypeKind.PRIMITIVE) {
                    throw new IllegalArgumentException(String.format("Provided type %s is not primitive", type));
                }
                primitiveTypeKind = EdmPrimitiveTypeKind.valueOf((String)type.getName());
            }
            return this.setType(primitiveTypeKind);
        }

        public BuilderImpl setType(EdmPrimitiveTypeKind type) {
            if (type == EdmPrimitiveTypeKind.Stream) {
                throw new IllegalArgumentException(String.format("Cannot build a primitive value for %s", EdmPrimitiveTypeKind.Stream.toString()));
            }
            if (type == EdmPrimitiveTypeKind.Geography || type == EdmPrimitiveTypeKind.Geometry) {
                throw new IllegalArgumentException(type + "is not an instantiable type. " + "An entity can declare a property to be of type Geometry. " + "An instance of an entity MUST NOT have a value of type Geometry. " + "Each value MUST be of some subtype.");
            }
            this.instance.typeKind = type == null ? EdmPrimitiveTypeKind.String : type;
            this.instance.type = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)this.instance.typeKind);
            return this;
        }

        public BuilderImpl setValue(Object value) {
            this.instance.value = value;
            return this;
        }

        public ClientPrimitiveValue build() {
            if (this.instance.type == null) {
                this.setType(EdmPrimitiveTypeKind.String);
            }
            return this.instance;
        }

        public ClientPrimitiveValue buildBoolean(Boolean value) {
            return this.setType(EdmPrimitiveTypeKind.Boolean).setValue(value).build();
        }

        public ClientPrimitiveValue buildInt16(Short value) {
            return this.setType(EdmPrimitiveTypeKind.Int16).setValue(value).build();
        }

        public ClientPrimitiveValue buildInt32(Integer value) {
            return this.setType(EdmPrimitiveTypeKind.Int32).setValue(value).build();
        }

        public ClientPrimitiveValue buildInt64(Long value) {
            return this.setType(EdmPrimitiveTypeKind.Int64).setValue(value).build();
        }

        public ClientPrimitiveValue buildSingle(Float value) {
            return this.setType(EdmPrimitiveTypeKind.Single).setValue(value).build();
        }

        public ClientPrimitiveValue buildDouble(Double value) {
            return this.setType(EdmPrimitiveTypeKind.Double).setValue(value).build();
        }

        public ClientPrimitiveValue buildString(String value) {
            return this.setType(EdmPrimitiveTypeKind.String).setValue(value).build();
        }

        public ClientPrimitiveValue buildGuid(UUID value) {
            return this.setType(EdmPrimitiveTypeKind.Guid).setValue(value).build();
        }

        public ClientPrimitiveValue buildBinary(byte[] value) {
            return this.setType(EdmPrimitiveTypeKind.Binary).setValue(value).build();
        }
    }
}

