/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.olingo.client.api.domain.ClientAnnotatable;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientCollectionValue;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientEnumValue;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientValuable;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.core.domain.ClientValuableImpl;

public class ClientPropertyImpl
implements ClientProperty,
ClientAnnotatable,
ClientValuable {
    private final List<ClientAnnotation> annotations = new ArrayList<ClientAnnotation>();
    private final String name;
    private final ClientValue value;
    private final ClientValuable valuable;

    public ClientPropertyImpl(String name, ClientValue value) {
        this.name = name;
        this.value = value;
        this.valuable = new ClientValuableImpl(value);
    }

    public String getName() {
        return this.name;
    }

    public ClientValue getValue() {
        return this.value;
    }

    public boolean hasNullValue() {
        return this.value == null || this.value.isPrimitive() && this.value.asPrimitive().toValue() == null;
    }

    public boolean hasPrimitiveValue() {
        return !this.hasNullValue() && this.value.isPrimitive();
    }

    public ClientPrimitiveValue getPrimitiveValue() {
        return this.hasPrimitiveValue() ? this.value.asPrimitive() : null;
    }

    public boolean hasComplexValue() {
        return !this.hasNullValue() && this.value.isComplex();
    }

    public boolean hasCollectionValue() {
        return !this.hasNullValue() && this.value.isCollection();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean hasEnumValue() {
        return this.valuable.hasEnumValue();
    }

    public ClientEnumValue getEnumValue() {
        return this.valuable.getEnumValue();
    }

    public ClientComplexValue getComplexValue() {
        return this.valuable.getComplexValue();
    }

    public ClientCollectionValue<ClientValue> getCollectionValue() {
        return this.valuable.getCollectionValue();
    }

    public List<ClientAnnotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "ODataPropertyImpl{name=" + this.getName() + ",valuable=" + this.valuable + ", annotations=" + this.annotations + '}';
    }
}

