/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.client.api.domain.ClientCollectionValue;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientEnumValue;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientValuable;
import org.apache.olingo.client.api.domain.ClientValue;

public class ClientValuableImpl
implements ClientValuable {
    private final ClientValue value;

    public ClientValuableImpl(ClientValue value) {
        this.value = value;
    }

    public ClientValue getValue() {
        return this.value;
    }

    public boolean hasNullValue() {
        return this.value == null;
    }

    public boolean hasPrimitiveValue() {
        return !this.hasNullValue() && this.value.isPrimitive();
    }

    public ClientPrimitiveValue getPrimitiveValue() {
        return this.hasPrimitiveValue() ? this.value.asPrimitive() : null;
    }

    public boolean hasCollectionValue() {
        return !this.hasNullValue() && this.value.isCollection();
    }

    public ClientCollectionValue<ClientValue> getCollectionValue() {
        return this.hasCollectionValue() ? this.getValue().asCollection() : null;
    }

    public boolean hasComplexValue() {
        return !this.hasNullValue() && this.value.isComplex();
    }

    public ClientComplexValue getComplexValue() {
        return this.hasComplexValue() ? this.getValue().asComplex() : null;
    }

    public boolean hasEnumValue() {
        return !this.hasNullValue() && this.getValue().isEnum();
    }

    public ClientEnumValue getEnumValue() {
        return this.hasEnumValue() ? this.getValue().asEnum() : null;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

