/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.ODataException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;

public class ClientCsdlEdmProvider
extends CsdlAbstractEdmProvider {
    private final Map<String, CsdlSchema> xmlSchemas;

    public ClientCsdlEdmProvider(Map<String, CsdlSchema> xmlSchemas) {
        this.xmlSchemas = xmlSchemas;
    }

    public CsdlEnumType getEnumType(FullQualifiedName enumTypeName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(enumTypeName.getNamespace());
        if (schema != null) {
            return schema.getEnumType(enumTypeName.getName());
        }
        return null;
    }

    public CsdlTypeDefinition getTypeDefinition(FullQualifiedName typeDefinitionName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(typeDefinitionName.getNamespace());
        if (schema != null) {
            return schema.getTypeDefinition(typeDefinitionName.getName());
        }
        return null;
    }

    public CsdlEntityType getEntityType(FullQualifiedName entityTypeName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(entityTypeName.getNamespace());
        if (schema != null) {
            return schema.getEntityType(entityTypeName.getName());
        }
        return null;
    }

    public CsdlComplexType getComplexType(FullQualifiedName complexTypeName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(complexTypeName.getNamespace());
        if (schema != null) {
            return schema.getComplexType(complexTypeName.getName());
        }
        return null;
    }

    public List<CsdlAction> getActions(FullQualifiedName actionName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(actionName.getNamespace());
        if (schema != null) {
            return schema.getActions(actionName.getName());
        }
        return null;
    }

    public List<CsdlFunction> getFunctions(FullQualifiedName functionName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(functionName.getNamespace());
        if (schema != null) {
            return schema.getFunctions(functionName.getName());
        }
        return null;
    }

    public CsdlTerm getTerm(FullQualifiedName termName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(termName.getNamespace());
        if (schema != null) {
            return schema.getTerm(termName.getName());
        }
        return null;
    }

    public CsdlEntitySet getEntitySet(FullQualifiedName entityContainer, String entitySetName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(entityContainer.getNamespace());
        if (schema != null) {
            return schema.getEntityContainer().getEntitySet(entitySetName);
        }
        return null;
    }

    public CsdlSingleton getSingleton(FullQualifiedName entityContainer, String singletonName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(entityContainer.getNamespace());
        if (schema != null) {
            return schema.getEntityContainer().getSingleton(singletonName);
        }
        return null;
    }

    public CsdlActionImport getActionImport(FullQualifiedName entityContainer, String actionImportName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(entityContainer.getNamespace());
        if (schema != null) {
            return schema.getEntityContainer().getActionImport(actionImportName);
        }
        return null;
    }

    public CsdlFunctionImport getFunctionImport(FullQualifiedName entityContainer, String functionImportName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(entityContainer.getNamespace());
        if (schema != null) {
            return schema.getEntityContainer().getFunctionImport(functionImportName);
        }
        return null;
    }

    public CsdlEntityContainerInfo getEntityContainerInfo(FullQualifiedName entityContainerName) throws ODataException {
        for (CsdlSchema schema : this.xmlSchemas.values()) {
            if (schema.getEntityContainer() == null) continue;
            return new CsdlEntityContainerInfo().setContainerName(entityContainerName).setExtendsContainer(schema.getEntityContainer().getExtendsContainerFQN());
        }
        return null;
    }

    public List<CsdlAliasInfo> getAliasInfos() throws ODataException {
        ArrayList<CsdlAliasInfo> aliasInfo = new ArrayList<CsdlAliasInfo>();
        for (CsdlSchema schema : this.xmlSchemas.values()) {
            if (schema.getAlias() == null) continue;
            aliasInfo.add(new CsdlAliasInfo().setNamespace(schema.getNamespace()).setAlias(schema.getAlias()));
        }
        return aliasInfo;
    }

    public List<CsdlSchema> getSchemas() throws ODataException {
        return new ArrayList<CsdlSchema>(this.xmlSchemas.values());
    }

    public CsdlEntityContainer getEntityContainer() throws ODataException {
        for (CsdlSchema schema : this.xmlSchemas.values()) {
            if (schema.getEntityContainer() == null) continue;
            return schema.getEntityContainer();
        }
        return null;
    }

    public CsdlAnnotations getAnnotationsGroup(FullQualifiedName targetName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(targetName.getNamespace());
        if (schema != null) {
            return schema.getAnnotationGroup(targetName.getName());
        }
        return null;
    }

    public CsdlAnnotatable getAnnoatatable(FullQualifiedName annotatedName) throws ODataException {
        CsdlSchema schema = this.xmlSchemas.get(annotatedName.getNamespace());
        if (schema != null) {
            return (CsdlAnnotatable)schema.getAnnotatables().get(annotatedName.getName());
        }
        return null;
    }
}

