/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlElementOrAttributeExpression;
import org.apache.olingo.client.core.edm.xml.ClientCsdlApply;
import org.apache.olingo.client.core.edm.xml.ClientCsdlCast;
import org.apache.olingo.client.core.edm.xml.ClientCsdlCollection;
import org.apache.olingo.client.core.edm.xml.ClientCsdlIf;
import org.apache.olingo.client.core.edm.xml.ClientCsdlIsOf;
import org.apache.olingo.client.core.edm.xml.ClientCsdlLabeledElement;
import org.apache.olingo.client.core.edm.xml.ClientCsdlNot;
import org.apache.olingo.client.core.edm.xml.ClientCsdlNull;
import org.apache.olingo.client.core.edm.xml.ClientCsdlRecord;
import org.apache.olingo.client.core.edm.xml.ClientCsdlTwoParamsOpDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.ClientCsdlUrlRef;
import org.apache.olingo.commons.api.edm.provider.annotation.AnnotationPath;
import org.apache.olingo.commons.api.edm.provider.annotation.Apply;
import org.apache.olingo.commons.api.edm.provider.annotation.Cast;
import org.apache.olingo.commons.api.edm.provider.annotation.Collection;
import org.apache.olingo.commons.api.edm.provider.annotation.DynamicAnnotationExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.If;
import org.apache.olingo.commons.api.edm.provider.annotation.IsOf;
import org.apache.olingo.commons.api.edm.provider.annotation.LabeledElement;
import org.apache.olingo.commons.api.edm.provider.annotation.LabeledElementReference;
import org.apache.olingo.commons.api.edm.provider.annotation.NavigationPropertyPath;
import org.apache.olingo.commons.api.edm.provider.annotation.Not;
import org.apache.olingo.commons.api.edm.provider.annotation.Null;
import org.apache.olingo.commons.api.edm.provider.annotation.Path;
import org.apache.olingo.commons.api.edm.provider.annotation.PropertyPath;
import org.apache.olingo.commons.api.edm.provider.annotation.PropertyValue;
import org.apache.olingo.commons.api.edm.provider.annotation.Record;
import org.apache.olingo.commons.api.edm.provider.annotation.TwoParamsOpDynamicAnnotationExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.UrlRef;

@JsonDeserialize(using=DynamicAnnotationExpressionDeserializer.class)
abstract class AbstractClientCsdlDynamicAnnotationExpression
extends AbstractClientCsdlAnnotationExpression
implements DynamicAnnotationExpression {
    private static final long serialVersionUID = 1093411847477874348L;

    AbstractClientCsdlDynamicAnnotationExpression() {
    }

    public boolean isNot() {
        return this instanceof Not;
    }

    public Not asNot() {
        return this.isNot() ? (Not)this : null;
    }

    public boolean isTwoParamsOp() {
        return this instanceof TwoParamsOpDynamicAnnotationExpression;
    }

    public TwoParamsOpDynamicAnnotationExpression asTwoParamsOp() {
        return this.isTwoParamsOp() ? (TwoParamsOpDynamicAnnotationExpression)this : null;
    }

    public boolean isAnnotationPath() {
        return this instanceof AnnotationPath;
    }

    public AnnotationPath asAnnotationPath() {
        return this.isAnnotationPath() ? (AnnotationPath)this : null;
    }

    public boolean isApply() {
        return this instanceof Apply;
    }

    public Apply asApply() {
        return this.isApply() ? (Apply)this : null;
    }

    public boolean isCast() {
        return this instanceof Cast;
    }

    public Cast asCast() {
        return this.isCast() ? (Cast)this : null;
    }

    public boolean isCollection() {
        return this instanceof Collection;
    }

    public Collection asCollection() {
        return this.isCollection() ? (Collection)this : null;
    }

    public boolean isIf() {
        return this instanceof If;
    }

    public If asIf() {
        return this.isIf() ? (If)this : null;
    }

    public boolean isIsOf() {
        return this instanceof IsOf;
    }

    public IsOf asIsOf() {
        return this.isIsOf() ? (IsOf)this : null;
    }

    public boolean isLabeledElement() {
        return this instanceof LabeledElement;
    }

    public LabeledElement asLabeledElement() {
        return this.isLabeledElement() ? (LabeledElement)this : null;
    }

    public boolean isLabeledElementReference() {
        return this instanceof LabeledElementReference;
    }

    public LabeledElementReference asLabeledElementReference() {
        return this.isLabeledElementReference() ? (LabeledElementReference)this : null;
    }

    public boolean isNull() {
        return this instanceof Null;
    }

    public Null asNull() {
        return this.isNull() ? (Null)this : null;
    }

    public boolean isNavigationPropertyPath() {
        return this instanceof NavigationPropertyPath;
    }

    public NavigationPropertyPath asNavigationPropertyPath() {
        return this.isNavigationPropertyPath() ? (NavigationPropertyPath)this : null;
    }

    public boolean isPath() {
        return this instanceof Path;
    }

    public Path asPath() {
        return this.isPath() ? (Path)this : null;
    }

    public boolean isPropertyPath() {
        return this instanceof PropertyPath;
    }

    public PropertyPath asPropertyPath() {
        return this.isPropertyPath() ? (PropertyPath)this : null;
    }

    public boolean isPropertyValue() {
        return this instanceof PropertyValue;
    }

    public PropertyValue asPropertyValue() {
        return this.isPropertyValue() ? (PropertyValue)this : null;
    }

    public boolean isRecord() {
        return this instanceof Record;
    }

    public Record asRecord() {
        return this.isRecord() ? (Record)this : null;
    }

    public boolean isUrlRef() {
        return this instanceof UrlRef;
    }

    public UrlRef asUrlRef() {
        return this.isUrlRef() ? (UrlRef)this : null;
    }

    static class DynamicAnnotationExpressionDeserializer
    extends AbstractClientCsdlEdmDeserializer<AbstractClientCsdlDynamicAnnotationExpression> {
        private static final String[] EL_OR_ATTR = new String[]{AnnotationPath.class.getSimpleName(), NavigationPropertyPath.class.getSimpleName(), Path.class.getSimpleName(), PropertyPath.class.getSimpleName()};
        private static final String APPLY = Apply.class.getSimpleName();
        private static final String CAST = Cast.class.getSimpleName();
        private static final String COLLECTION = Collection.class.getSimpleName();
        private static final String IF = If.class.getSimpleName();
        private static final String IS_OF = IsOf.class.getSimpleName();
        private static final String LABELED_ELEMENT = LabeledElement.class.getSimpleName();
        private static final String NULL = Null.class.getSimpleName();
        private static final String RECORD = Record.class.getSimpleName();
        private static final String URL_REF = UrlRef.class.getSimpleName();

        DynamicAnnotationExpressionDeserializer() {
        }

        private AbstractClientCsdlElementOrAttributeExpression getElementOrAttributeExpression(String simpleClassName) throws JsonParseException {
            try {
                Class elOrAttrClass = ClassUtils.getClass((String)(((Object)((Object)this)).getClass().getPackage().getName() + ".ClientCsdl" + simpleClassName));
                return (AbstractClientCsdlElementOrAttributeExpression)((Object)elOrAttrClass.newInstance());
            }
            catch (Exception e) {
                throw new JsonParseException("Could not instantiate " + simpleClassName, JsonLocation.NA, (Throwable)e);
            }
        }

        private AbstractClientCsdlAnnotationExpression parseConstOrEnumExpression(JsonParser jp) throws IOException {
            AbstractClientCsdlAnnotationExpression result = this.isAnnotationConstExprConstruct(jp) ? this.parseAnnotationConstExprConstruct(jp) : (AbstractClientCsdlAnnotationExpression)((Object)jp.readValueAs(AbstractClientCsdlDynamicAnnotationExpression.class));
            jp.nextToken();
            return result;
        }

        @Override
        protected AbstractClientCsdlDynamicAnnotationExpression doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            AbstractClientCsdlDynamicAnnotationExpression expression = null;
            if ("Not".equals(jp.getCurrentName())) {
                ClientCsdlNot not = new ClientCsdlNot();
                jp.nextToken();
                while (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                    jp.nextToken();
                }
                not.setExpression((DynamicAnnotationExpression)jp.readValueAs(AbstractClientCsdlDynamicAnnotationExpression.class));
                while (jp.getCurrentToken() != JsonToken.END_OBJECT || !jp.getCurrentName().equals("Not")) {
                    jp.nextToken();
                }
                expression = not;
            } else if (TwoParamsOpDynamicAnnotationExpression.Type.fromString((String)jp.getCurrentName()) != null) {
                ClientCsdlTwoParamsOpDynamicAnnotationExpression dynExprDoubleParamOp = new ClientCsdlTwoParamsOpDynamicAnnotationExpression();
                dynExprDoubleParamOp.setType(TwoParamsOpDynamicAnnotationExpression.Type.fromString((String)jp.getCurrentName()));
                jp.nextToken();
                while (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                    jp.nextToken();
                }
                dynExprDoubleParamOp.setLeftExpression((DynamicAnnotationExpression)jp.readValueAs(AbstractClientCsdlDynamicAnnotationExpression.class));
                dynExprDoubleParamOp.setRightExpression((DynamicAnnotationExpression)jp.readValueAs(AbstractClientCsdlDynamicAnnotationExpression.class));
                while (jp.getCurrentToken() != JsonToken.END_OBJECT || !jp.getCurrentName().equals(dynExprDoubleParamOp.getType().name())) {
                    jp.nextToken();
                }
                expression = dynExprDoubleParamOp;
            } else if (ArrayUtils.contains((Object[])EL_OR_ATTR, (Object)jp.getCurrentName())) {
                AbstractClientCsdlElementOrAttributeExpression elOrAttr = this.getElementOrAttributeExpression(jp.getCurrentName());
                elOrAttr.setValue(jp.nextTextValue());
                expression = elOrAttr;
            } else if (APPLY.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (AbstractClientCsdlDynamicAnnotationExpression)((Object)jp.readValueAs(ClientCsdlApply.class));
            } else if (CAST.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (AbstractClientCsdlDynamicAnnotationExpression)((Object)jp.readValueAs(ClientCsdlCast.class));
            } else if (COLLECTION.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (AbstractClientCsdlDynamicAnnotationExpression)((Object)jp.readValueAs(ClientCsdlCollection.class));
            } else if (IF.equals(jp.getCurrentName())) {
                jp.nextToken();
                jp.nextToken();
                ClientCsdlIf ifImpl = new ClientCsdlIf();
                ifImpl.setGuard(this.parseConstOrEnumExpression(jp));
                ifImpl.setThen(this.parseConstOrEnumExpression(jp));
                ifImpl.setElse(this.parseConstOrEnumExpression(jp));
                expression = ifImpl;
            } else if (IS_OF.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (AbstractClientCsdlDynamicAnnotationExpression)((Object)jp.readValueAs(ClientCsdlIsOf.class));
            } else if (LABELED_ELEMENT.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (AbstractClientCsdlDynamicAnnotationExpression)((Object)jp.readValueAs(ClientCsdlLabeledElement.class));
            } else if (NULL.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (AbstractClientCsdlDynamicAnnotationExpression)((Object)jp.readValueAs(ClientCsdlNull.class));
            } else if (RECORD.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (AbstractClientCsdlDynamicAnnotationExpression)((Object)jp.readValueAs(ClientCsdlRecord.class));
            } else if (URL_REF.equals(jp.getCurrentName())) {
                jp.nextToken();
                expression = (AbstractClientCsdlDynamicAnnotationExpression)((Object)jp.readValueAs(ClientCsdlUrlRef.class));
            }
            return expression;
        }
    }
}

