/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.annotation.AnnotationExpression;

@JsonDeserialize(using=AnnotationDeserializer.class)
class ClientCsdlAnnotation
extends CsdlAnnotation {
    private static final long serialVersionUID = 5464714417411058033L;

    ClientCsdlAnnotation() {
    }

    static class AnnotationDeserializer
    extends AbstractClientCsdlEdmDeserializer<CsdlAnnotation> {
        AnnotationDeserializer() {
        }

        @Override
        protected CsdlAnnotation doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlAnnotation annotation = new ClientCsdlAnnotation();
            while (jp.getCurrentToken() != null && jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Term".equals(jp.getCurrentName())) {
                        annotation.setTerm(jp.nextTextValue());
                    } else if ("Qualifier".equals(jp.getCurrentName())) {
                        annotation.setQualifier(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        annotation.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    } else if (this.isAnnotationConstExprConstruct(jp)) {
                        annotation.setExpression(this.parseAnnotationConstExprConstruct(jp));
                    } else {
                        annotation.setExpression((AnnotationExpression)jp.readValueAs(AbstractClientCsdlDynamicAnnotationExpression.class));
                    }
                }
                jp.nextToken();
            }
            return annotation;
        }
    }
}

