/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlActionImport;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlEntitySet;
import org.apache.olingo.client.core.edm.xml.ClientCsdlFunctionImport;
import org.apache.olingo.client.core.edm.xml.ClientCsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;

@JsonDeserialize(using=EntityContainerDeserializer.class)
class ClientCsdlEntityContainer
extends CsdlEntityContainer {
    private static final long serialVersionUID = 5631432527646955795L;

    ClientCsdlEntityContainer() {
    }

    static class EntityContainerDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlEntityContainer> {
        EntityContainerDeserializer() {
        }

        @Override
        protected ClientCsdlEntityContainer doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlEntityContainer entityContainer = new ClientCsdlEntityContainer();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        entityContainer.setName(jp.nextTextValue());
                    } else if ("Extends".equals(jp.getCurrentName())) {
                        entityContainer.setExtendsContainer(jp.nextTextValue());
                    } else if ("EntitySet".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        entityContainer.getEntitySets().add(jp.readValueAs(ClientCsdlEntitySet.class));
                    } else if ("Singleton".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        entityContainer.getSingletons().add(jp.readValueAs(ClientCsdlSingleton.class));
                    } else if ("ActionImport".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        entityContainer.getActionImports().add(jp.readValueAs(ClientCsdlActionImport.class));
                    } else if ("FunctionImport".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        entityContainer.getFunctionImports().add(jp.readValueAs(ClientCsdlFunctionImport.class));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        entityContainer.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return entityContainer;
        }
    }
}

