/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlAnnotatableDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.annotation.DynamicAnnotationExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.IsOf;

@JsonDeserialize(using=IsOfDeserializer.class)
class ClientCsdlIsOf
extends AbstractClientCsdlAnnotatableDynamicAnnotationExpression
implements IsOf {
    private static final long serialVersionUID = -893355856129761174L;
    private String type;
    private Integer maxLength;
    private Integer precision;
    private Integer scale;
    private SRID srid;
    private DynamicAnnotationExpression value;

    ClientCsdlIsOf() {
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public SRID getSrid() {
        return this.srid;
    }

    public void setSrid(SRID srid) {
        this.srid = srid;
    }

    public DynamicAnnotationExpression getValue() {
        return this.value;
    }

    public void setValue(DynamicAnnotationExpression value) {
        this.value = value;
    }

    static class IsOfDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlIsOf> {
        IsOfDeserializer() {
        }

        @Override
        protected ClientCsdlIsOf doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlIsOf isof = new ClientCsdlIsOf();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Type".equals(jp.getCurrentName())) {
                        isof.setType(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        isof.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    } else if ("MaxLength".equals(jp.getCurrentName())) {
                        String maxLenght = jp.nextTextValue();
                        isof.setMaxLength(maxLenght.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.valueOf(maxLenght));
                    } else if ("Precision".equals(jp.getCurrentName())) {
                        isof.setPrecision(Integer.valueOf(jp.nextTextValue()));
                    } else if ("Scale".equals(jp.getCurrentName())) {
                        String scale = jp.nextTextValue();
                        isof.setScale(scale.equalsIgnoreCase("variable") ? 0 : Integer.valueOf(scale));
                    } else if ("SRID".equals(jp.getCurrentName())) {
                        String srid = jp.nextTextValue();
                        if (srid != null) {
                            isof.setSrid(SRID.valueOf((String)srid));
                        }
                    } else {
                        isof.setValue((DynamicAnnotationExpression)jp.readValueAs(AbstractClientCsdlDynamicAnnotationExpression.class));
                    }
                }
                jp.nextToken();
            }
            return isof;
        }
    }
}

