/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlAnnotatableDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.annotation.DynamicAnnotationExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.LabeledElement;

@JsonDeserialize(using=LabeledElementDeserializer.class)
class ClientCsdlLabeledElement
extends AbstractClientCsdlAnnotatableDynamicAnnotationExpression
implements LabeledElement {
    private static final long serialVersionUID = 4909387630253341824L;
    private String name;
    private DynamicAnnotationExpression value;

    ClientCsdlLabeledElement() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DynamicAnnotationExpression getValue() {
        return this.value;
    }

    public void setValue(DynamicAnnotationExpression value) {
        this.value = value;
    }

    static class LabeledElementDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlLabeledElement> {
        LabeledElementDeserializer() {
        }

        @Override
        protected ClientCsdlLabeledElement doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlLabeledElement element = new ClientCsdlLabeledElement();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        element.setName(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        element.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    } else {
                        element.setValue((DynamicAnnotationExpression)jp.readValueAs(AbstractClientCsdlDynamicAnnotationExpression.class));
                    }
                }
                jp.nextToken();
            }
            return element;
        }
    }
}

