/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;

@JsonDeserialize(using=ParameterDeserializer.class)
class ClientCsdlParameter
extends CsdlParameter {
    private static final long serialVersionUID = 7119478691341167904L;

    ClientCsdlParameter() {
    }

    static class ParameterDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlParameter> {
        ParameterDeserializer() {
        }

        @Override
        protected ClientCsdlParameter doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlParameter parameter = new ClientCsdlParameter();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        parameter.setName(jp.nextTextValue());
                    } else if ("Type".equals(jp.getCurrentName())) {
                        String metadataTypeName = jp.nextTextValue();
                        if (metadataTypeName.startsWith("Collection(")) {
                            parameter.setType(metadataTypeName.substring(metadataTypeName.indexOf("(") + 1, metadataTypeName.length() - 1));
                            parameter.setCollection(true);
                        } else {
                            parameter.setType(metadataTypeName);
                            parameter.setCollection(false);
                        }
                    } else if ("Nullable".equals(jp.getCurrentName())) {
                        parameter.setNullable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("MaxLength".equals(jp.getCurrentName())) {
                        String maxLenght = jp.nextTextValue();
                        parameter.setMaxLength(maxLenght.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.valueOf(maxLenght));
                    } else if ("Precision".equals(jp.getCurrentName())) {
                        parameter.setPrecision(Integer.valueOf(jp.nextTextValue()));
                    } else if ("Scale".equals(jp.getCurrentName())) {
                        String scale = jp.nextTextValue();
                        parameter.setScale(scale.equalsIgnoreCase("variable") ? 0 : Integer.valueOf(scale));
                    } else if ("SRID".equals(jp.getCurrentName())) {
                        String srid = jp.nextTextValue();
                        if (srid != null) {
                            parameter.setSrid(SRID.valueOf((String)srid));
                        }
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        parameter.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return parameter;
        }
    }
}

