/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlAnnotatableDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.annotation.AnnotationExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.PropertyValue;

@JsonDeserialize(using=PropertyValueDeserializer.class)
class ClientCsdlPropertyValue
extends AbstractClientCsdlAnnotatableDynamicAnnotationExpression
implements PropertyValue {
    private static final long serialVersionUID = -8437649215282645228L;
    private String property;
    private AnnotationExpression value;

    ClientCsdlPropertyValue() {
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public AnnotationExpression getValue() {
        return this.value;
    }

    public void setValue(AnnotationExpression value) {
        this.value = value;
    }

    static class PropertyValueDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlPropertyValue> {
        PropertyValueDeserializer() {
        }

        @Override
        protected ClientCsdlPropertyValue doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlPropertyValue propValue = new ClientCsdlPropertyValue();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Property".equals(jp.getCurrentName())) {
                        propValue.setProperty(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        propValue.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    } else if (this.isAnnotationConstExprConstruct(jp)) {
                        propValue.setValue(this.parseAnnotationConstExprConstruct(jp));
                    } else {
                        propValue.setValue((AnnotationExpression)jp.readValueAs(AbstractClientCsdlDynamicAnnotationExpression.class));
                    }
                }
                jp.nextToken();
            }
            return propValue;
        }
    }
}

