/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlAnnotatableDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlPropertyValue;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.annotation.PropertyValue;
import org.apache.olingo.commons.api.edm.provider.annotation.Record;

@JsonDeserialize(using=RecordDeserializer.class)
class ClientCsdlRecord
extends AbstractClientCsdlAnnotatableDynamicAnnotationExpression
implements Record {
    private static final long serialVersionUID = 4275271751615410709L;
    private String type;
    private final List<PropertyValue> propertyValues = new ArrayList<PropertyValue>();

    ClientCsdlRecord() {
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    static class RecordDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlRecord> {
        RecordDeserializer() {
        }

        @Override
        protected ClientCsdlRecord doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlRecord record = new ClientCsdlRecord();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Type".equals(jp.getCurrentName())) {
                        record.setType(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        record.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    } else {
                        record.getPropertyValues().add((PropertyValue)jp.readValueAs(ClientCsdlPropertyValue.class));
                    }
                }
                jp.nextToken();
            }
            return record;
        }
    }
}

