/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAction;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotations;
import org.apache.olingo.client.core.edm.xml.ClientCsdlComplexType;
import org.apache.olingo.client.core.edm.xml.ClientCsdlEntityContainer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlEntityType;
import org.apache.olingo.client.core.edm.xml.ClientCsdlEnumType;
import org.apache.olingo.client.core.edm.xml.ClientCsdlFunction;
import org.apache.olingo.client.core.edm.xml.ClientCsdlTerm;
import org.apache.olingo.client.core.edm.xml.ClientCsdlTypeDefinition;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;

@JsonDeserialize(using=SchemaDeserializer.class)
class ClientCsdlSchema
extends CsdlSchema {
    private static final long serialVersionUID = 1911087363912024939L;

    ClientCsdlSchema() {
    }

    static class SchemaDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlSchema> {
        SchemaDeserializer() {
        }

        @Override
        protected ClientCsdlSchema doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlSchema schema = new ClientCsdlSchema();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Namespace".equals(jp.getCurrentName())) {
                        schema.setNamespace(jp.nextTextValue());
                    } else if ("Alias".equals(jp.getCurrentName())) {
                        schema.setAlias(jp.nextTextValue());
                    } else if ("ComplexType".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        schema.getComplexTypes().add(jp.readValueAs(ClientCsdlComplexType.class));
                    } else if ("EntityType".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        schema.getEntityTypes().add(jp.readValueAs(ClientCsdlEntityType.class));
                    } else if ("EnumType".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        schema.getEnumTypes().add(jp.readValueAs(ClientCsdlEnumType.class));
                    } else if ("EntityContainer".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        ClientCsdlEntityContainer entityContainer = (ClientCsdlEntityContainer)((Object)jp.readValueAs(ClientCsdlEntityContainer.class));
                        schema.setEntityContainer(entityContainer);
                    } else if ("Action".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        schema.getActions().add(jp.readValueAs(ClientCsdlAction.class));
                    } else if ("Function".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        schema.getFunctions().add(jp.readValueAs(ClientCsdlFunction.class));
                    } else if ("TypeDefinition".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        schema.getTypeDefinitions().add(jp.readValueAs(ClientCsdlTypeDefinition.class));
                    }
                } else if ("Annotations".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    schema.getAnnotationGroups().add(jp.readValueAs(ClientCsdlAnnotations.class));
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    schema.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                } else if ("Term".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    schema.getTerms().add(jp.readValueAs(ClientCsdlTerm.class));
                }
                jp.nextToken();
            }
            return schema;
        }
    }
}

