/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.edm.xml.Edmx;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.api.serialization.ClientODataDeserializer;
import org.apache.olingo.client.core.data.JSONServiceDocumentDeserializer;
import org.apache.olingo.client.core.data.XMLServiceDocumentDeserializer;
import org.apache.olingo.client.core.edm.ClientCsdlXMLMetadata;
import org.apache.olingo.client.core.edm.xml.ClientCsdlEdmx;
import org.apache.olingo.commons.api.ODataError;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializer;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.core.serialization.AtomDeserializer;
import org.apache.olingo.commons.core.serialization.JsonDeltaDeserializer;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;

public class ClientODataDeserializerImpl
implements ClientODataDeserializer {
    private final ODataDeserializer deserializer;
    private final ODataFormat format;

    public ClientODataDeserializerImpl(boolean serverMode, ODataFormat format) {
        this.format = format;
        this.deserializer = format == ODataFormat.XML || format == ODataFormat.ATOM ? new AtomDeserializer() : new JsonDeserializer(serverMode);
    }

    public ResWrap<EntityCollection> toEntitySet(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toEntitySet(input);
    }

    public ResWrap<Entity> toEntity(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toEntity(input);
    }

    public ResWrap<Property> toProperty(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toProperty(input);
    }

    public ODataError toError(InputStream input) throws ODataDeserializerException {
        return this.deserializer.toError(input);
    }

    protected XmlMapper getXmlMapper() {
        XmlMapper xmlMapper = new XmlMapper(new XmlFactory((XMLInputFactory)new InputFactoryImpl(), (XMLOutputFactory)new OutputFactoryImpl()), new JacksonXmlModule());
        xmlMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(Boolean.class, (Object)Boolean.FALSE));
        xmlMapper.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, com.fasterxml.jackson.databind.JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException, JsonProcessingException {
                ctxt.getParser().skipChildren();
                return true;
            }
        });
        return xmlMapper;
    }

    public XMLMetadata toMetadata(InputStream input) {
        try {
            return new ClientCsdlXMLMetadata((Edmx)this.getXmlMapper().readValue(input, ClientCsdlEdmx.class));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse as Edmx document", e);
        }
    }

    public ResWrap<ServiceDocument> toServiceDocument(InputStream input) throws ODataDeserializerException {
        return this.format == ODataFormat.XML ? new XMLServiceDocumentDeserializer(false).toServiceDocument(input) : new JSONServiceDocumentDeserializer(false).toServiceDocument(input);
    }

    public ResWrap<Delta> toDelta(InputStream input) throws ODataDeserializerException {
        try {
            return this.format == ODataFormat.ATOM ? new AtomDeserializer().delta(input) : new JsonDeltaDeserializer(false).toDelta(input);
        }
        catch (XMLStreamException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }
}

