/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientLink;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.serialization.ODataWriter;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;

public class ODataWriterImpl
implements ODataWriter {
    protected final ODataClient client;

    public ODataWriterImpl(ODataClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream writeEntities(Collection<ClientEntity> entities, ODataFormat format) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            for (ClientEntity entity : entities) {
                this.client.getSerializer(format).write((Writer)writer, (Object)this.client.getBinder().getEntity(entity));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public InputStream writeEntity(ClientEntity entity, ODataFormat format) throws ODataSerializerException {
        return this.writeEntities(Collections.singleton(entity), format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream writeProperty(ClientProperty property, ODataFormat format) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            this.client.getSerializer(format).write((Writer)writer, (Object)this.client.getBinder().getProperty(property));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream writeLink(ClientLink link, ODataFormat format) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            this.client.getSerializer(format).write((Writer)writer, (Object)this.client.getBinder().getLink(link));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream writeReference(ResWrap<URI> reference, ODataFormat format) throws ODataSerializerException {
        OutputStreamWriter writer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            writer = null;
        }
        try {
            this.client.getSerializer(format).write((Writer)writer, reference);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }
}

