/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.uri;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.datatype.Duration;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.http.HttpClientFactory;
import org.apache.olingo.client.api.http.WrappingHttpClientFactory;
import org.apache.olingo.client.api.uri.SegmentType;
import org.apache.olingo.client.core.http.BasicAuthHttpClientFactory;
import org.apache.olingo.client.core.uri.ParameterAlias;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDuration;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URIUtils {
    private static final Logger LOG = LoggerFactory.getLogger(URIUtils.class);
    private static final Pattern ENUM_VALUE = Pattern.compile("(.+\\.)?.+'.+'");

    private URIUtils() {
    }

    public static URI getURI(String base, String href) {
        if (href == null) {
            throw new IllegalArgumentException("Null link provided");
        }
        URI uri = URI.create(href);
        if (!uri.isAbsolute() && base != null) {
            uri = URI.create(base + "/" + href);
        }
        return uri.normalize();
    }

    public static URI getURI(URI base, URI href) {
        if (href == null) {
            throw new IllegalArgumentException("Null link provided");
        }
        return URIUtils.getURI(base, href.toASCIIString());
    }

    public static URI getURI(URI base, String href) {
        if (href == null) {
            throw new IllegalArgumentException("Null link provided");
        }
        URI uri = URI.create(href);
        if (!uri.isAbsolute() && base != null) {
            uri = URI.create(base.toASCIIString() + "/" + href);
        }
        return uri.normalize();
    }

    private static String timestamp(Timestamp timestamp) throws UnsupportedEncodingException, EdmPrimitiveTypeException {
        return URLEncoder.encode(EdmDateTimeOffset.getInstance().valueToString((Object)timestamp, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8");
    }

    private static String calendar(Calendar calendar) throws UnsupportedEncodingException, EdmPrimitiveTypeException {
        return URLEncoder.encode(EdmDateTimeOffset.getInstance().valueToString((Object)calendar, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8");
    }

    private static String duration(Duration duration) throws UnsupportedEncodingException, EdmPrimitiveTypeException {
        return EdmDuration.getInstance().toUriLiteral(URLEncoder.encode(EdmDuration.getInstance().valueToString((Object)duration, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8"));
    }

    private static String quoteString(String string, boolean singleQuoteEscape) throws UnsupportedEncodingException {
        return ENUM_VALUE.matcher(string).matches() ? string : (singleQuoteEscape ? "'" + string + "'" : "\"" + string + "\"");
    }

    public static String escape(Object obj) {
        return URIUtils.escape(obj, true);
    }

    private static String escape(Object obj, boolean singleQuoteEscape) {
        String value;
        try {
            if (obj == null) {
                value = "null";
            } else if (obj instanceof Collection) {
                StringBuilder buffer = new StringBuilder("[");
                Iterator itor = ((Collection)obj).iterator();
                while (itor.hasNext()) {
                    buffer.append(URIUtils.escape(itor.next(), false));
                    if (!itor.hasNext()) continue;
                    buffer.append(',');
                }
                buffer.append(']');
                value = buffer.toString();
            } else if (obj instanceof Map) {
                StringBuilder buffer = new StringBuilder("{");
                Iterator itor = ((Map)obj).entrySet().iterator();
                while (itor.hasNext()) {
                    Map.Entry entry = itor.next();
                    buffer.append("\"").append((String)entry.getKey()).append("\"");
                    buffer.append(':').append(URIUtils.escape(entry.getValue(), false));
                    if (!itor.hasNext()) continue;
                    buffer.append(',');
                }
                buffer.append('}');
                value = buffer.toString();
            } else {
                value = obj instanceof ParameterAlias ? "@" + ((ParameterAlias)obj).getAlias() : (obj instanceof Boolean ? BooleanUtils.toStringTrueFalse((Boolean)((Boolean)obj)) : (obj instanceof UUID ? obj.toString() : (obj instanceof byte[] ? EdmBinary.getInstance().toUriLiteral(Hex.encodeHexString((byte[])((byte[])obj))) : (obj instanceof Timestamp ? URIUtils.timestamp((Timestamp)obj) : (obj instanceof Calendar ? URIUtils.calendar((Calendar)obj) : (obj instanceof Duration ? URIUtils.duration((Duration)obj) : (obj instanceof BigDecimal ? EdmDecimal.getInstance().valueToString(obj, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null) : (obj instanceof Double ? EdmDouble.getInstance().valueToString(obj, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null) : (obj instanceof Float ? EdmSingle.getInstance().valueToString(obj, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null) : (obj instanceof Long ? EdmInt64.getInstance().valueToString(obj, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null) : (obj instanceof Geospatial ? URLEncoder.encode(EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)((Geospatial)obj).getEdmPrimitiveTypeKind()).valueToString(obj, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null), "UTF-8") : (obj instanceof String ? URIUtils.quoteString((String)obj, singleQuoteEscape) : obj.toString()))))))))))));
            }
        }
        catch (Exception e) {
            LOG.warn("While escaping '{}', using toString()", obj, (Object)e);
            value = obj == null ? "null" : obj.toString();
        }
        return value;
    }

    public static boolean shouldUseRepeatableHttpBodyEntry(ODataClient client) {
        WrappingHttpClientFactory tmp;
        HttpClientFactory httpclientFactory = client.getConfiguration().getHttpClientFactory();
        if (httpclientFactory instanceof BasicAuthHttpClientFactory) {
            return true;
        }
        return httpclientFactory instanceof WrappingHttpClientFactory && (tmp = (WrappingHttpClientFactory)httpclientFactory).getWrappedHttpClientFactory() instanceof BasicAuthHttpClientFactory;
    }

    public static HttpEntity buildInputStreamEntity(ODataClient client, InputStream input) {
        InputStreamEntity entity;
        boolean useChunked = client.getConfiguration().isUseChuncked();
        if (URIUtils.shouldUseRepeatableHttpBodyEntry(client) || !useChunked) {
            byte[] bytes = new byte[]{};
            try {
                bytes = IOUtils.toByteArray((InputStream)input);
                IOUtils.closeQuietly((InputStream)input);
            }
            catch (IOException e) {
                LOG.error("While reading input for not chunked encoding", (Throwable)e);
            }
            entity = new ByteArrayEntity(bytes);
        } else {
            entity = new InputStreamEntity(input, -1L);
        }
        if (!useChunked && entity.getContentLength() < 0L) {
            LOG.error("Could not determine length - request will be sent as chunked.");
            useChunked = true;
        }
        entity.setChunked(useChunked);
        return entity;
    }

    public static URI addValueSegment(URI uri) {
        URI res;
        if (uri.getPath().endsWith(SegmentType.VALUE.getValue())) {
            res = uri;
        } else {
            try {
                res = new URIBuilder(uri).setPath(uri.getPath() + "/" + SegmentType.VALUE.getValue()).build();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return res;
    }

    public static URI buildFunctionInvokeURI(URI uri, Map<String, ClientValue> parameters) {
        String rawQuery = uri.getRawQuery();
        String baseURI = StringUtils.substringBefore((String)uri.toASCIIString(), (String)("?" + rawQuery));
        if (baseURI.endsWith("()")) {
            baseURI = baseURI.substring(0, baseURI.length() - 2);
        }
        StringBuilder inlineParams = new StringBuilder();
        for (Map.Entry<String, ClientValue> param : parameters.entrySet()) {
            inlineParams.append(param.getKey()).append("=");
            Object value = null;
            if (param.getValue().isPrimitive()) {
                value = param.getValue().asPrimitive().toValue();
            } else if (param.getValue().isComplex()) {
                value = param.getValue().asComplex().asJavaMap();
            } else if (param.getValue().isCollection()) {
                value = param.getValue().asCollection().asJavaCollection();
            } else if (param.getValue().isEnum()) {
                value = param.getValue().asEnum().toString();
            }
            inlineParams.append(URIUtils.escape(value)).append(',');
        }
        if (inlineParams.length() > 0) {
            inlineParams.deleteCharAt(inlineParams.length() - 1);
        }
        try {
            return URI.create(baseURI + "(" + URLEncoder.encode(inlineParams.toString(), "UTF-8") + ")" + (StringUtils.isNotBlank((CharSequence)rawQuery) ? "?" + rawQuery : ""));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("While adding GET parameters", e);
        }
    }
}

