/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.aalto.stax.InputFactoryImpl;
import java.io.InputStream;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.serialization.ODataDeserializer;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.serialization.AtomGeoValueDeserializer;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.AbstractODataObject;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.DeletedEntity;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.DeltaLink;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Operation;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.PropertyType;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.ex.ODataErrorDetail;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class AtomDeserializer
implements ODataDeserializer {
    protected static final QName etagQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "etag");
    protected static final QName metadataEtagQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "metadata-etag");
    protected static final QName inlineQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "inline");
    protected static final QName actionQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "action");
    protected static final QName propertiesQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "properties");
    protected static final QName typeQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "type");
    protected static final QName nullQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "null");
    protected static final QName elementQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "element");
    protected static final QName countQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "count");
    protected static final QName annotationQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "annotation");
    protected static final QName contextQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "context");
    protected static final QName entryRefQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "ref");
    protected static final QName propertyValueQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "value");
    protected static final QName reasonQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "reason");
    protected static final QName linkQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "link");
    protected static final QName deletedLinkQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "deleted-link");
    protected static final QName errorCodeQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "code");
    protected static final QName errorMessageQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "message");
    protected static final QName errorTargetQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "target");
    protected static final QName errorDetailQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "detail");
    protected static final QName deletedEntryQName = new QName("http://purl.org/atompub/tombstones/1.0", "deleted-entry");
    protected static final XMLInputFactory FACTORY = new InputFactoryImpl();
    private final AtomGeoValueDeserializer geoDeserializer = new AtomGeoValueDeserializer();

    protected XMLEventReader getReader(InputStream input) throws XMLStreamException {
        return FACTORY.createXMLEventReader(input);
    }

    private Object fromPrimitive(XMLEventReader reader, StartElement start, EdmTypeInfo typeInfo) throws XMLStreamException, EdmPrimitiveTypeException {
        Object value = null;
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && typeInfo != null && typeInfo.getPrimitiveTypeKind().isGeospatial()) {
                EdmPrimitiveTypeKind geoType = EdmPrimitiveTypeKind.valueOfFQN((String)typeInfo.getFullQualifiedName().toString());
                value = this.geoDeserializer.deserialize(reader, event.asStartElement(), geoType);
            }
            if (!(!event.isCharacters() || event.asCharacters().isWhiteSpace() || typeInfo != null && typeInfo.getPrimitiveTypeKind().isGeospatial())) {
                String stringValue = event.asCharacters().getData();
                if (typeInfo == null) {
                    value = stringValue;
                } else {
                    EdmPrimitiveType primitiveType = (EdmPrimitiveType)typeInfo.getType();
                    Class returnType = primitiveType.getDefaultType().isAssignableFrom(Calendar.class) ? Timestamp.class : primitiveType.getDefaultType();
                    value = ((EdmPrimitiveType)typeInfo.getType()).valueOfString(stringValue, Boolean.valueOf(true), null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, Boolean.valueOf(true), returnType);
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        return value;
    }

    private Object fromComplexOrEnum(XMLEventReader reader, StartElement start) throws XMLStreamException, EdmPrimitiveTypeException {
        Object value = null;
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                if (value == null) {
                    value = new ComplexValue();
                }
                if (Constants.QNAME_ATOM_ELEM_LINK.equals(event.asStartElement().getName())) {
                    Attribute type;
                    Attribute href;
                    Attribute title;
                    Link link = new Link();
                    Attribute rel = event.asStartElement().getAttributeByName(QName.valueOf("rel"));
                    if (rel != null) {
                        link.setRel(rel.getValue());
                    }
                    if ((title = event.asStartElement().getAttributeByName(QName.valueOf("title"))) != null) {
                        link.setTitle(title.getValue());
                    }
                    if ((href = event.asStartElement().getAttributeByName(QName.valueOf("href"))) != null) {
                        link.setHref(href.getValue());
                    }
                    if ((type = event.asStartElement().getAttributeByName(QName.valueOf("type"))) != null) {
                        link.setType(type.getValue());
                    }
                    if (link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/related/")) {
                        value.getNavigationLinks().add(link);
                        this.inline(reader, event.asStartElement(), link);
                    } else if (link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/relatedlinks/")) {
                        ((Valuable)value).asComplex().getAssociationLinks().add(link);
                    }
                } else {
                    value.getValue().add(this.property(reader, event.asStartElement()));
                }
            }
            if (event.isCharacters() && !event.asCharacters().isWhiteSpace()) {
                value = event.asCharacters().getData();
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        return value;
    }

    private void fromCollection(Valuable valuable, XMLEventReader reader, StartElement start, EdmTypeInfo typeInfo) throws XMLStreamException, EdmPrimitiveTypeException {
        ArrayList<Object> values = new ArrayList<Object>();
        ValueType valueType = ValueType.COLLECTION_PRIMITIVE;
        EdmTypeInfo type = typeInfo == null ? null : new EdmTypeInfo.Builder().setTypeExpression(typeInfo.getFullQualifiedName().toString()).build();
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                switch (this.guessPropertyType(reader, typeInfo)) {
                    case COMPLEX: {
                        EdmTypeInfo typeInfoEle;
                        Object complexValue = this.fromComplexOrEnum(reader, event.asStartElement());
                        valueType = ValueType.COLLECTION_COMPLEX;
                        Attribute typeAttr = event.asStartElement().getAttributeByName(typeQName);
                        String typeAttrValue = typeAttr == null ? null : typeAttr.getValue();
                        EdmTypeInfo edmTypeInfo = typeInfoEle = StringUtils.isBlank((CharSequence)typeAttrValue) ? null : new EdmTypeInfo.Builder().setTypeExpression(typeAttrValue).build();
                        if (typeInfoEle != null) {
                            ((ComplexValue)complexValue).setTypeName(typeInfoEle.external());
                        }
                        values.add(complexValue);
                        break;
                    }
                    case ENUM: {
                        valueType = ValueType.COLLECTION_ENUM;
                        values.add(this.fromComplexOrEnum(reader, event.asStartElement()));
                        break;
                    }
                    case PRIMITIVE: {
                        Object value = this.fromPrimitive(reader, event.asStartElement(), type);
                        valueType = value instanceof Geospatial ? ValueType.COLLECTION_GEOSPATIAL : ValueType.COLLECTION_PRIMITIVE;
                        values.add(value);
                        break;
                    }
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        valuable.setValue(valueType, values);
    }

    private PropertyType guessPropertyType(XMLEventReader reader, EdmTypeInfo typeInfo) throws XMLStreamException {
        XMLEvent child = null;
        while (reader.hasNext() && child == null) {
            XMLEvent event = reader.peek();
            if (event.isCharacters() && event.asCharacters().isWhiteSpace()) {
                reader.nextEvent();
                continue;
            }
            child = event;
        }
        PropertyType type = child == null ? (typeInfo == null || typeInfo.isPrimitiveType() ? PropertyType.PRIMITIVE : PropertyType.ENUM) : (child.isStartElement() ? ("http://www.opengis.net/gml".equals(child.asStartElement().getName().getNamespaceURI()) ? PropertyType.PRIMITIVE : (elementQName.equals(child.asStartElement().getName()) ? PropertyType.COLLECTION : PropertyType.COMPLEX)) : (child.isCharacters() ? (typeInfo == null || typeInfo.isPrimitiveType() ? PropertyType.PRIMITIVE : PropertyType.ENUM) : PropertyType.EMPTY));
        return type;
    }

    private Property property(XMLEventReader reader, StartElement start) throws XMLStreamException, EdmPrimitiveTypeException {
        Property property = new Property();
        if (propertyValueQName.equals(start.getName())) {
            Attribute context = start.getAttributeByName(contextQName);
            if (context != null) {
                property.setName(StringUtils.substringAfterLast((String)context.getValue(), (String)"/"));
            }
        } else {
            property.setName(start.getName().getLocalPart());
        }
        this.valuable((Valuable)property, reader, start);
        return property;
    }

    private void valuable(Valuable valuable, XMLEventReader reader, StartElement start) throws XMLStreamException, EdmPrimitiveTypeException {
        PropertyType propType;
        EdmTypeInfo typeInfo;
        Attribute nullAttr = start.getAttributeByName(nullQName);
        Attribute typeAttr = start.getAttributeByName(typeQName);
        String typeAttrValue = typeAttr == null ? null : typeAttr.getValue();
        EdmTypeInfo edmTypeInfo = typeInfo = StringUtils.isBlank((CharSequence)typeAttrValue) ? null : new EdmTypeInfo.Builder().setTypeExpression(typeAttrValue).build();
        if (typeInfo != null) {
            valuable.setType(typeInfo.internal());
        }
        PropertyType propertyType = typeInfo == null ? this.guessPropertyType(reader, typeInfo) : (typeInfo.isCollection() ? PropertyType.COLLECTION : (propType = typeInfo.isPrimitiveType() ? PropertyType.PRIMITIVE : PropertyType.COMPLEX));
        if (nullAttr == null) {
            switch (propType) {
                case COLLECTION: {
                    this.fromCollection(valuable, reader, start, typeInfo);
                    break;
                }
                case COMPLEX: {
                    Object complexValue = this.fromComplexOrEnum(reader, start);
                    if (typeInfo != null && complexValue instanceof ComplexValue && start.getAttributeByName(QName.valueOf("term")) == null) {
                        ((ComplexValue)complexValue).setTypeName(typeInfo.external());
                    }
                    valuable.setValue(complexValue instanceof ComplexValue ? ValueType.COMPLEX : ValueType.ENUM, complexValue);
                    break;
                }
                case PRIMITIVE: {
                    Object value;
                    if (typeInfo == null) {
                        valuable.setType(EdmPrimitiveTypeKind.String.getFullQualifiedName().toString());
                    }
                    valuable.setValue((value = this.fromPrimitive(reader, start, typeInfo)) instanceof Geospatial ? ValueType.GEOSPATIAL : ValueType.PRIMITIVE, value);
                    break;
                }
                default: {
                    valuable.setValue(ValueType.PRIMITIVE, (Object)"");
                    break;
                }
            }
        } else {
            valuable.setValue(propType == PropertyType.PRIMITIVE ? ValueType.PRIMITIVE : (propType == PropertyType.ENUM ? ValueType.ENUM : (propType == PropertyType.COMPLEX ? ValueType.COMPLEX : (propType == PropertyType.COLLECTION ? ValueType.COLLECTION_PRIMITIVE : ValueType.PRIMITIVE))), null);
        }
    }

    public ResWrap<Property> toProperty(InputStream input) throws ODataDeserializerException {
        try {
            XMLEventReader reader = this.getReader(input);
            StartElement start = this.skipBeforeFirstStartElement(reader);
            return this.getContainer(start, this.property(reader, start));
        }
        catch (XMLStreamException | EdmPrimitiveTypeException e) {
            throw new ODataDeserializerException(e);
        }
    }

    private StartElement skipBeforeFirstStartElement(XMLEventReader reader) throws XMLStreamException {
        StartElement startEvent = null;
        while (reader.hasNext() && startEvent == null) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            startEvent = event.asStartElement();
        }
        if (startEvent == null) {
            throw new IllegalArgumentException("Cannot find any XML start element");
        }
        return startEvent;
    }

    private void common(XMLEventReader reader, StartElement start, AbstractODataObject object, String key) throws XMLStreamException {
        boolean foundEndElement = false;
        while (reader.hasNext() && !foundEndElement) {
            XMLEvent event = reader.nextEvent();
            if (event.isCharacters() && !event.asCharacters().isWhiteSpace()) {
                object.setCommonProperty(key, event.asCharacters().getData());
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndElement = true;
        }
    }

    private void inline(XMLEventReader reader, StartElement start, Link link) throws XMLStreamException, EdmPrimitiveTypeException {
        boolean foundEndElement = false;
        while (reader.hasNext() && !foundEndElement) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                if (inlineQName.equals(event.asStartElement().getName())) {
                    StartElement inline = this.getStartElement(reader);
                    if (inline != null) {
                        if (Constants.QNAME_ATOM_ELEM_ENTRY.equals(inline.getName())) {
                            link.setInlineEntity(this.entity(reader, inline));
                        }
                        if (Constants.QNAME_ATOM_ELEM_FEED.equals(inline.getName())) {
                            link.setInlineEntitySet(this.entitySet(reader, inline));
                        }
                    }
                } else if (annotationQName.equals(event.asStartElement().getName())) {
                    link.getAnnotations().add(this.annotation(reader, event.asStartElement()));
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndElement = true;
        }
    }

    private StartElement getStartElement(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent innerEvent = reader.peek();
            if (innerEvent.isCharacters() && innerEvent.asCharacters().isWhiteSpace()) {
                reader.nextEvent();
                continue;
            }
            if (innerEvent.isStartElement()) {
                return innerEvent.asStartElement();
            }
            if (!innerEvent.isEndElement() || !inlineQName.equals(innerEvent.asEndElement().getName())) continue;
            return null;
        }
        return null;
    }

    public ResWrap<Delta> delta(InputStream input) throws XMLStreamException, EdmPrimitiveTypeException {
        XMLEventReader reader = this.getReader(input);
        StartElement start = this.skipBeforeFirstStartElement(reader);
        return this.getContainer(start, this.delta(reader, start));
    }

    private Delta delta(XMLEventReader reader, StartElement start) throws XMLStreamException, EdmPrimitiveTypeException {
        if (!Constants.QNAME_ATOM_ELEM_FEED.equals(start.getName())) {
            return null;
        }
        Delta delta = new Delta();
        Attribute xmlBase = start.getAttributeByName(Constants.QNAME_ATTR_XML_BASE);
        if (xmlBase != null) {
            delta.setBaseURI(URI.create(xmlBase.getValue()));
        }
        boolean foundEndFeed = false;
        while (reader.hasNext() && !foundEndFeed) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                if (countQName.equals(event.asStartElement().getName())) {
                    this.count(reader, event.asStartElement(), (EntityCollection)delta);
                } else if (Constants.QNAME_ATOM_ELEM_ID.equals(event.asStartElement().getName())) {
                    this.common(reader, event.asStartElement(), (AbstractODataObject)delta, "id");
                } else if (Constants.QNAME_ATOM_ELEM_TITLE.equals(event.asStartElement().getName())) {
                    this.common(reader, event.asStartElement(), (AbstractODataObject)delta, "title");
                } else if (Constants.QNAME_ATOM_ELEM_SUMMARY.equals(event.asStartElement().getName())) {
                    this.common(reader, event.asStartElement(), (AbstractODataObject)delta, "summary");
                } else if (Constants.QNAME_ATOM_ELEM_UPDATED.equals(event.asStartElement().getName())) {
                    this.common(reader, event.asStartElement(), (AbstractODataObject)delta, "updated");
                } else if (Constants.QNAME_ATOM_ELEM_LINK.equals(event.asStartElement().getName())) {
                    Attribute rel = event.asStartElement().getAttributeByName(QName.valueOf("rel"));
                    if (rel != null) {
                        Attribute href;
                        if ("next".equals(rel.getValue()) && (href = event.asStartElement().getAttributeByName(QName.valueOf("href"))) != null) {
                            delta.setNext(URI.create(href.getValue()));
                        }
                        if ("http://docs.oasis-open.org/odata/ns/delta".equals(rel.getValue()) && (href = event.asStartElement().getAttributeByName(QName.valueOf("href"))) != null) {
                            delta.setDeltaLink(URI.create(href.getValue()));
                        }
                    }
                } else if (Constants.QNAME_ATOM_ELEM_ENTRY.equals(event.asStartElement().getName())) {
                    delta.getEntities().add(this.entity(reader, event.asStartElement()));
                } else if (deletedEntryQName.equals(event.asStartElement().getName())) {
                    Attribute reason;
                    DeletedEntity deletedEntity = new DeletedEntity();
                    Attribute ref = event.asStartElement().getAttributeByName(QName.valueOf("ref"));
                    if (ref != null) {
                        deletedEntity.setId(URI.create(ref.getValue()));
                    }
                    if ((reason = event.asStartElement().getAttributeByName(reasonQName)) != null) {
                        deletedEntity.setReason(DeletedEntity.Reason.valueOf((String)reason.getValue()));
                    }
                    delta.getDeletedEntities().add(deletedEntity);
                } else if (linkQName.equals(event.asStartElement().getName()) || deletedLinkQName.equals(event.asStartElement().getName())) {
                    Attribute target;
                    Attribute relationship;
                    DeltaLink link = new DeltaLink();
                    Attribute source = event.asStartElement().getAttributeByName(QName.valueOf("source"));
                    if (source != null) {
                        link.setSource(URI.create(source.getValue()));
                    }
                    if ((relationship = event.asStartElement().getAttributeByName(QName.valueOf("relationship"))) != null) {
                        link.setRelationship(relationship.getValue());
                    }
                    if ((target = event.asStartElement().getAttributeByName(QName.valueOf("target"))) != null) {
                        link.setTarget(URI.create(target.getValue()));
                    }
                    if (linkQName.equals(event.asStartElement().getName())) {
                        delta.getAddedLinks().add(link);
                    } else {
                        delta.getDeletedLinks().add(link);
                    }
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndFeed = true;
        }
        return delta;
    }

    private void properties(XMLEventReader reader, StartElement start, Entity entity) throws XMLStreamException, EdmPrimitiveTypeException {
        HashMap annotations = new HashMap();
        boolean foundEndProperties = false;
        while (reader.hasNext() && !foundEndProperties) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                if (annotationQName.equals(event.asStartElement().getName())) {
                    String target = event.asStartElement().getAttributeByName(QName.valueOf("target")).getValue();
                    if (!annotations.containsKey(target)) {
                        annotations.put(target, new ArrayList());
                    }
                    ((List)annotations.get(target)).add(this.annotation(reader, event.asStartElement()));
                } else {
                    entity.getProperties().add(this.property(reader, event.asStartElement()));
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperties = true;
        }
        for (Property property : entity.getProperties()) {
            if (!annotations.containsKey(property.getName())) continue;
            property.getAnnotations().addAll((Collection)annotations.get(property.getName()));
        }
    }

    private Annotation annotation(XMLEventReader reader, StartElement start) throws XMLStreamException, EdmPrimitiveTypeException {
        Annotation annotation = new Annotation();
        annotation.setTerm(start.getAttributeByName(QName.valueOf("term")).getValue());
        this.valuable((Valuable)annotation, reader, start);
        return annotation;
    }

    private Entity entityRef(StartElement start) throws XMLStreamException {
        Entity entity = new Entity();
        Attribute entityRefId = start.getAttributeByName(Constants.QNAME_ATOM_ATTR_ID);
        if (entityRefId != null) {
            entity.setId(URI.create(entityRefId.getValue()));
        }
        return entity;
    }

    private Entity entity(XMLEventReader reader, StartElement start) throws XMLStreamException, EdmPrimitiveTypeException {
        Entity entity;
        if (entryRefQName.equals(start.getName())) {
            entity = this.entityRef(start);
        } else if (Constants.QNAME_ATOM_ELEM_ENTRY.equals(start.getName())) {
            Attribute etag;
            entity = new Entity();
            Attribute xmlBase = start.getAttributeByName(Constants.QNAME_ATTR_XML_BASE);
            if (xmlBase != null) {
                entity.setBaseURI(URI.create(xmlBase.getValue()));
            }
            if ((etag = start.getAttributeByName(etagQName)) != null) {
                entity.setETag(etag.getValue());
            }
            boolean foundEndEntry = false;
            while (reader.hasNext() && !foundEndEntry) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    Attribute title;
                    if (Constants.QNAME_ATOM_ELEM_ID.equals(event.asStartElement().getName())) {
                        this.common(reader, event.asStartElement(), (AbstractODataObject)entity, "id");
                    } else if (Constants.QNAME_ATOM_ELEM_TITLE.equals(event.asStartElement().getName())) {
                        this.common(reader, event.asStartElement(), (AbstractODataObject)entity, "title");
                    } else if (Constants.QNAME_ATOM_ELEM_SUMMARY.equals(event.asStartElement().getName())) {
                        this.common(reader, event.asStartElement(), (AbstractODataObject)entity, "summary");
                    } else if (Constants.QNAME_ATOM_ELEM_UPDATED.equals(event.asStartElement().getName())) {
                        this.common(reader, event.asStartElement(), (AbstractODataObject)entity, "updated");
                    } else if (Constants.QNAME_ATOM_ELEM_CATEGORY.equals(event.asStartElement().getName())) {
                        Attribute term = event.asStartElement().getAttributeByName(QName.valueOf("term"));
                        if (term != null) {
                            entity.setType(new EdmTypeInfo.Builder().setTypeExpression(term.getValue()).build().internal());
                        }
                    } else if (Constants.QNAME_ATOM_ELEM_LINK.equals(event.asStartElement().getName())) {
                        Attribute type;
                        Attribute href;
                        Link link = new Link();
                        Attribute rel = event.asStartElement().getAttributeByName(QName.valueOf("rel"));
                        if (rel != null) {
                            link.setRel(rel.getValue());
                        }
                        if ((title = event.asStartElement().getAttributeByName(QName.valueOf("title"))) != null) {
                            link.setTitle(title.getValue());
                        }
                        if ((href = event.asStartElement().getAttributeByName(QName.valueOf("href"))) != null) {
                            link.setHref(href.getValue());
                        }
                        if ((type = event.asStartElement().getAttributeByName(QName.valueOf("type"))) != null) {
                            link.setType(type.getValue());
                        }
                        if ("self".equals(link.getRel())) {
                            entity.setSelfLink(link);
                        } else if ("edit".equals(link.getRel())) {
                            entity.setEditLink(link);
                        } else if ("edit-media".equals(link.getRel())) {
                            Attribute mediaETag = event.asStartElement().getAttributeByName(etagQName);
                            if (mediaETag != null) {
                                entity.setMediaETag(mediaETag.getValue());
                            }
                        } else if (link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/related/")) {
                            entity.getNavigationLinks().add(link);
                            this.inline(reader, event.asStartElement(), link);
                        } else if (link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/relatedlinks/")) {
                            entity.getAssociationLinks().add(link);
                        } else if (link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/edit-media/") || link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/mediaresource/")) {
                            Attribute metag = event.asStartElement().getAttributeByName(etagQName);
                            if (metag != null) {
                                link.setMediaETag(metag.getValue());
                            }
                            entity.getMediaEditLinks().add(link);
                        }
                    } else if (actionQName.equals(event.asStartElement().getName())) {
                        Attribute target;
                        Operation operation = new Operation();
                        Attribute metadata = event.asStartElement().getAttributeByName(QName.valueOf("metadata"));
                        if (metadata != null) {
                            operation.setMetadataAnchor(metadata.getValue());
                        }
                        if ((title = event.asStartElement().getAttributeByName(QName.valueOf("title"))) != null) {
                            operation.setTitle(title.getValue());
                        }
                        if ((target = event.asStartElement().getAttributeByName(QName.valueOf("target"))) != null) {
                            operation.setTarget(URI.create(target.getValue()));
                        }
                        entity.getOperations().add(operation);
                    } else if (Constants.QNAME_ATOM_ELEM_CONTENT.equals(event.asStartElement().getName())) {
                        Attribute type = event.asStartElement().getAttributeByName(QName.valueOf("type"));
                        if (type == null || ContentType.APPLICATION_XML.toContentTypeString().equals(type.getValue())) {
                            this.properties(reader, this.skipBeforeFirstStartElement(reader), entity);
                        } else {
                            entity.setMediaContentType(type.getValue());
                            Attribute src = event.asStartElement().getAttributeByName(QName.valueOf("src"));
                            if (src != null) {
                                entity.setMediaContentSource(URI.create(src.getValue()));
                            }
                        }
                    } else if (propertiesQName.equals(event.asStartElement().getName())) {
                        this.properties(reader, event.asStartElement(), entity);
                    } else if (annotationQName.equals(event.asStartElement().getName())) {
                        entity.getAnnotations().add(this.annotation(reader, event.asStartElement()));
                    }
                }
                if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
                foundEndEntry = true;
            }
        } else {
            entity = null;
        }
        return entity;
    }

    public ResWrap<Entity> toEntity(InputStream input) throws ODataDeserializerException {
        try {
            XMLEventReader reader = this.getReader(input);
            StartElement start = this.skipBeforeFirstStartElement(reader);
            Entity entity = this.entity(reader, start);
            if (entity == null) {
                throw new ODataDeserializerException("No entity found!");
            }
            return this.getContainer(start, entity);
        }
        catch (XMLStreamException | EdmPrimitiveTypeException e) {
            throw new ODataDeserializerException(e);
        }
    }

    private void count(XMLEventReader reader, StartElement start, EntityCollection entitySet) throws XMLStreamException {
        boolean foundEndElement = false;
        while (reader.hasNext() && !foundEndElement) {
            XMLEvent event = reader.nextEvent();
            if (event.isCharacters() && !event.asCharacters().isWhiteSpace()) {
                entitySet.setCount(Integer.valueOf(event.asCharacters().getData()));
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndElement = true;
        }
    }

    private EntityCollection entitySet(XMLEventReader reader, StartElement start) throws XMLStreamException, EdmPrimitiveTypeException {
        if (!Constants.QNAME_ATOM_ELEM_FEED.equals(start.getName())) {
            return null;
        }
        EntityCollection entitySet = new EntityCollection();
        Attribute xmlBase = start.getAttributeByName(Constants.QNAME_ATTR_XML_BASE);
        if (xmlBase != null) {
            entitySet.setBaseURI(URI.create(xmlBase.getValue()));
        }
        boolean foundEndFeed = false;
        while (reader.hasNext() && !foundEndFeed) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                if (countQName.equals(event.asStartElement().getName())) {
                    this.count(reader, event.asStartElement(), entitySet);
                } else if (Constants.QNAME_ATOM_ELEM_ID.equals(event.asStartElement().getName())) {
                    this.common(reader, event.asStartElement(), (AbstractODataObject)entitySet, "id");
                } else if (Constants.QNAME_ATOM_ELEM_TITLE.equals(event.asStartElement().getName())) {
                    this.common(reader, event.asStartElement(), (AbstractODataObject)entitySet, "title");
                } else if (Constants.QNAME_ATOM_ELEM_SUMMARY.equals(event.asStartElement().getName())) {
                    this.common(reader, event.asStartElement(), (AbstractODataObject)entitySet, "summary");
                } else if (Constants.QNAME_ATOM_ELEM_UPDATED.equals(event.asStartElement().getName())) {
                    this.common(reader, event.asStartElement(), (AbstractODataObject)entitySet, "updated");
                } else if (Constants.QNAME_ATOM_ELEM_LINK.equals(event.asStartElement().getName())) {
                    Attribute rel = event.asStartElement().getAttributeByName(QName.valueOf("rel"));
                    if (rel != null) {
                        Attribute href;
                        if ("next".equals(rel.getValue()) && (href = event.asStartElement().getAttributeByName(QName.valueOf("href"))) != null) {
                            entitySet.setNext(URI.create(href.getValue()));
                        }
                        if ("http://docs.oasis-open.org/odata/ns/delta".equals(rel.getValue()) && (href = event.asStartElement().getAttributeByName(QName.valueOf("href"))) != null) {
                            entitySet.setDeltaLink(URI.create(href.getValue()));
                        }
                    }
                } else if (Constants.QNAME_ATOM_ELEM_ENTRY.equals(event.asStartElement().getName())) {
                    entitySet.getEntities().add(this.entity(reader, event.asStartElement()));
                } else if (entryRefQName.equals(event.asStartElement().getName())) {
                    entitySet.getEntities().add(this.entityRef(event.asStartElement()));
                } else if (annotationQName.equals(event.asStartElement().getName())) {
                    entitySet.getAnnotations().add(this.annotation(reader, event.asStartElement()));
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndFeed = true;
        }
        return entitySet;
    }

    public ResWrap<EntityCollection> toEntitySet(InputStream input) throws ODataDeserializerException {
        try {
            XMLEventReader reader = this.getReader(input);
            StartElement start = this.skipBeforeFirstStartElement(reader);
            return this.getContainer(start, this.entitySet(reader, start));
        }
        catch (XMLStreamException | EdmPrimitiveTypeException e) {
            throw new ODataDeserializerException(e);
        }
    }

    private ODataError error(XMLEventReader reader, StartElement start) throws XMLStreamException {
        ODataError error = new ODataError();
        error.setDetails(new ArrayList(0));
        ODataErrorDetail errorDetail = null;
        boolean setCode = false;
        boolean codeSet = false;
        boolean setMessage = false;
        boolean messageSet = false;
        boolean setTarget = false;
        boolean targetSet = false;
        boolean isDetails = false;
        boolean foundEndElement = false;
        while (reader.hasNext() && !foundEndElement) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                if (errorCodeQName.equals(event.asStartElement().getName())) {
                    setCode = true;
                } else if (errorMessageQName.equals(event.asStartElement().getName())) {
                    setMessage = true;
                } else if (errorTargetQName.equals(event.asStartElement().getName())) {
                    setTarget = true;
                } else if (errorDetailQName.equals(event.asStartElement().getName())) {
                    isDetails = true;
                    errorDetail = new ODataErrorDetail();
                }
            }
            if (event.isCharacters() && !event.asCharacters().isWhiteSpace()) {
                if (setCode && !codeSet) {
                    error.setCode(event.asCharacters().getData());
                    setCode = false;
                    codeSet = true;
                }
                if (setMessage && !messageSet) {
                    error.setMessage(event.asCharacters().getData());
                    setMessage = false;
                    messageSet = true;
                }
                if (setTarget && !targetSet) {
                    error.setTarget(event.asCharacters().getData());
                    setTarget = false;
                    targetSet = true;
                }
                if (setCode && isDetails) {
                    errorDetail.setCode(event.asCharacters().getData());
                    setCode = false;
                }
                if (setMessage && isDetails) {
                    errorDetail.setMessage(event.asCharacters().getData());
                    setMessage = false;
                }
                if (setTarget && isDetails) {
                    errorDetail.setTarget(event.asCharacters().getData());
                    setTarget = false;
                }
            }
            if (event.isEndElement() && errorDetailQName.equals(event.asEndElement().getName())) {
                isDetails = false;
                error.getDetails().add(errorDetail);
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndElement = true;
        }
        return error;
    }

    public ODataError toError(InputStream input) throws ODataDeserializerException {
        try {
            XMLEventReader reader = this.getReader(input);
            StartElement start = this.skipBeforeFirstStartElement(reader);
            return this.error(reader, start);
        }
        catch (XMLStreamException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }

    private <T> ResWrap<T> getContainer(StartElement start, T object) {
        Attribute context = start.getAttributeByName(contextQName);
        Attribute metadataETag = start.getAttributeByName(metadataEtagQName);
        return new ResWrap(context == null ? null : URI.create(context.getValue()), metadataETag == null ? null : metadataETag.getValue(), object);
    }

    static {
        FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        FACTORY.setProperty("javax.xml.stream.supportDTD", false);
        FACTORY.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
    }
}

