/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.communication.header.ODataPreferences;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.cud.CommonUpdateType;
import org.apache.olingo.client.api.communication.request.cud.ODataDeleteRequest;
import org.apache.olingo.client.api.communication.request.cud.ODataEntityUpdateRequest;
import org.apache.olingo.client.api.communication.request.cud.v4.ODataReferenceAddingRequest;
import org.apache.olingo.client.api.communication.request.cud.v4.UpdateType;
import org.apache.olingo.client.api.communication.request.streamed.ODataMediaEntityUpdateRequest;
import org.apache.olingo.client.api.communication.request.streamed.ODataStreamUpdateRequest;
import org.apache.olingo.client.api.v4.EdmEnabledODataClient;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.ODataLinkType;
import org.apache.olingo.commons.api.domain.v4.ODataAnnotatable;
import org.apache.olingo.commons.api.domain.v4.ODataEntity;
import org.apache.olingo.commons.api.domain.v4.ODataLink;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.EdmStreamValue;
import org.apache.olingo.ext.proxy.api.PersistenceManager;
import org.apache.olingo.ext.proxy.api.annotations.NavigationProperty;
import org.apache.olingo.ext.proxy.commons.AnnotatableInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.PersistenceChanges;
import org.apache.olingo.ext.proxy.commons.TransactionItems;
import org.apache.olingo.ext.proxy.context.AttachedEntity;
import org.apache.olingo.ext.proxy.context.AttachedEntityStatus;
import org.apache.olingo.ext.proxy.context.EntityLinkDesc;
import org.apache.olingo.ext.proxy.utils.ClassUtils;
import org.apache.olingo.ext.proxy.utils.CoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPersistenceManager
implements PersistenceManager {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractPersistenceManager.class);
    private static final long serialVersionUID = 2065240290461241515L;
    protected final AbstractService<?> service;

    AbstractPersistenceManager(AbstractService<?> factory) {
        this.service = factory;
    }

    @Override
    public Future<Void> flushAsync() {
        return this.service.getClient().getConfiguration().getExecutor().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractPersistenceManager.this.flush();
                return ClassUtils.returnVoid();
            }
        });
    }

    protected abstract void doFlush(PersistenceChanges var1, TransactionItems var2);

    @Override
    public void flush() {
        PersistenceChanges changes = new PersistenceChanges();
        TransactionItems items = new TransactionItems();
        int pos = 0;
        ArrayList<EntityLinkDesc> delayedUpdates = new ArrayList<EntityLinkDesc>();
        for (AttachedEntity attachedEntity : this.service.getContext().entityContext()) {
            AttachedEntityStatus status = attachedEntity.getStatus();
            if ((status == AttachedEntityStatus.ATTACHED || status == AttachedEntityStatus.LINKED) && !attachedEntity.getEntity().isChanged() || items.contains(attachedEntity.getEntity())) continue;
            ++pos;
            pos = this.processEntityContext(attachedEntity.getEntity(), pos, items, delayedUpdates, changes);
        }
        this.processDelayedUpdates(delayedUpdates, pos, items, changes);
        items.normalize();
        for (URI uri : this.service.getContext().entityContext().getFurtherDeletes()) {
            this.queueDelete(uri, null, changes);
            items.put(null, ++pos);
        }
        if (!items.isEmpty()) {
            this.doFlush(changes, items);
        }
        this.service.getContext().detachAll();
    }

    private org.apache.olingo.commons.api.domain.ODataLink buildNavigationLink(String name, URI uri, ODataLinkType type) {
        org.apache.olingo.commons.api.domain.ODataLink result;
        switch (type) {
            case ENTITY_NAVIGATION: {
                result = this.service.getClient().getObjectFactory().newEntityNavigationLink(name, uri);
                break;
            }
            case ENTITY_SET_NAVIGATION: {
                result = this.service.getClient().getObjectFactory().newEntitySetNavigationLink(name, uri);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid link type " + type.name());
            }
        }
        return result;
    }

    protected int processEntityContext(EntityInvocationHandler handler, int pos, TransactionItems items, List<EntityLinkDesc> delayedUpdates, PersistenceChanges changeset) {
        AttachedEntityStatus processedStatus;
        items.put(handler, null);
        CommonODataEntity entity = handler.getEntity();
        entity.getNavigationLinks().clear();
        AttachedEntityStatus currentStatus = this.service.getContext().entityContext().getStatus(handler);
        LOG.debug("Process '{}({})'", (Object)handler, (Object)currentStatus);
        if (AttachedEntityStatus.DELETED != currentStatus) {
            entity.getProperties().clear();
            CoreUtils.addProperties(this.service.getClient(), handler.getPropertyChanges(), entity);
            if (entity instanceof ODataEntity) {
                ((ODataEntity)entity).getAnnotations().clear();
                CoreUtils.addAnnotations(this.service.getClient(), handler.getAnnotations(), (ODataAnnotatable)((ODataEntity)entity));
                for (Map.Entry<Object, Object> entry : handler.getPropAnnotatableHandlers().entrySet()) {
                    CoreUtils.addAnnotations(this.service.getClient(), ((AnnotatableInvocationHandler)entry.getValue()).getAnnotations(), (ODataAnnotatable)((ODataEntity)entity).getProperty((String)entry.getKey()));
                }
            }
        }
        for (Map.Entry<NavigationProperty, Object> entry : handler.getLinkChanges().entrySet()) {
            InvocationHandler target;
            ODataLinkType type = Collection.class.isAssignableFrom(entry.getValue().getClass()) ? ODataLinkType.ENTITY_SET_NAVIGATION : ODataLinkType.ENTITY_NAVIGATION;
            HashSet<EntityInvocationHandler> toBeLinked = new HashSet<EntityInvocationHandler>();
            for (Object e : type == ODataLinkType.ENTITY_SET_NAVIGATION ? (Set<Object>)entry.getValue() : Collections.singleton(entry.getValue())) {
                Integer targetPos;
                EntityInvocationHandler target2 = (EntityInvocationHandler)Proxy.getInvocationHandler(e);
                AttachedEntityStatus status = !this.service.getContext().entityContext().isAttached(target2) ? this.resolveNavigationLink(entry.getKey(), target2) : this.service.getContext().entityContext().getStatus(target2);
                LOG.debug("Found link to '{}({})'", (Object)target2, (Object)status);
                URI editLink = target2.getEntity().getEditLink();
                if (!(status != AttachedEntityStatus.ATTACHED && status != AttachedEntityStatus.LINKED || target2.isChanged())) {
                    LOG.debug("Add link to '{}'", (Object)target2);
                    entity.addLink(this.buildNavigationLink(entry.getKey().name(), URIUtils.getURI((String)this.service.getClient().getServiceRoot(), (String)editLink.toASCIIString()), type));
                    continue;
                }
                if (!items.contains(target2)) {
                    pos = this.processEntityContext(target2, pos, items, delayedUpdates, changeset);
                    ++pos;
                }
                if ((targetPos = items.get(target2)) == null) {
                    LOG.debug("Schedule '{}' from '{}' to '{}'", new Object[]{type.name(), handler, target2});
                    toBeLinked.add(target2);
                    continue;
                }
                if (status == AttachedEntityStatus.CHANGED) {
                    LOG.debug("Changed: '{}' from '{}' to (${}) '{}'", new Object[]{type.name(), handler, targetPos, target2});
                    entity.addLink(this.buildNavigationLink(entry.getKey().name(), URIUtils.getURI((String)this.service.getClient().getServiceRoot(), (String)editLink.toASCIIString()), type));
                    continue;
                }
                LOG.debug("'{}' from '{}' to (${}) '{}'", new Object[]{type.name(), handler, targetPos, target2});
                entity.addLink(this.buildNavigationLink(entry.getKey().name(), URI.create("$" + targetPos), type));
            }
            if (!toBeLinked.isEmpty()) {
                delayedUpdates.add(new EntityLinkDesc(entry.getKey().name(), handler, toBeLinked, type));
            }
            if (!(entry.getValue() instanceof Proxy) || !((target = Proxy.getInvocationHandler(entry.getValue())) instanceof EntityCollectionInvocationHandler)) continue;
            for (String ref : ((EntityCollectionInvocationHandler)target).referenceItems) {
                delayedUpdates.add(new EntityLinkDesc(entry.getKey().name(), handler, ref));
            }
        }
        if (entity instanceof ODataEntity) {
            for (Map.Entry<Object, Object> entry : handler.getNavPropAnnotatableHandlers().entrySet()) {
                CoreUtils.addAnnotations(this.service.getClient(), ((AnnotatableInvocationHandler)entry.getValue()).getAnnotations(), (ODataAnnotatable)((ODataLink)entity.getNavigationLink((String)entry.getKey())));
            }
        }
        if ((processedStatus = this.queue(handler, entity, changeset)) != null) {
            LOG.debug("{}: Insert '{}' into the process queue", (Object)pos, (Object)handler);
            items.put(handler, pos);
        } else {
            --pos;
        }
        if (processedStatus != AttachedEntityStatus.DELETED) {
            int n = pos;
            if (handler.getEntity().isMediaEntity() && handler.isChanged()) {
                URI targetURI;
                if (!handler.getPropertyChanges().isEmpty()) {
                    targetURI = currentStatus == AttachedEntityStatus.NEW ? URI.create("$" + n) : URIUtils.getURI((String)this.service.getClient().getServiceRoot(), (String)handler.getEntity().getEditLink().toASCIIString());
                    this.queueUpdate(handler, targetURI, entity, changeset);
                    items.put(handler, ++pos);
                    LOG.debug("{}: Update media properties for '{}' into the process queue", (Object)pos, (Object)handler);
                }
                if (handler.getStreamChanges() != null) {
                    targetURI = currentStatus == AttachedEntityStatus.NEW ? URI.create("$" + n + "/$value") : URIUtils.getURI((String)this.service.getClient().getServiceRoot(), (String)(handler.getEntity().getEditLink().toASCIIString() + "/$value"));
                    this.queueUpdateMediaEntity(handler, targetURI, handler.getStreamChanges(), changeset);
                    items.put(null, ++pos);
                    LOG.debug("{}: Update media info for '{}' into the process queue", (Object)pos, (Object)handler);
                }
            }
            for (Map.Entry<String, EdmStreamValue> streamedChanges : handler.getStreamedPropertyChanges().entrySet()) {
                URI targetURI = currentStatus == AttachedEntityStatus.NEW ? URI.create("$" + n) : URIUtils.getURI((String)this.service.getClient().getServiceRoot(), (String)CoreUtils.getMediaEditLink(streamedChanges.getKey(), entity).toASCIIString());
                this.queueUpdateMediaResource(handler, targetURI, streamedChanges.getValue(), changeset);
                items.put(handler, ++pos);
                LOG.debug("{}: Update media info (null key) for '{}' into the process queue", (Object)pos, (Object)handler);
            }
        }
        return pos;
    }

    protected void processDelayedUpdates(List<EntityLinkDesc> delayedUpdates, int pos, TransactionItems items, PersistenceChanges changeset) {
        for (EntityLinkDesc delayedUpdate : delayedUpdates) {
            if (StringUtils.isBlank((CharSequence)delayedUpdate.getReference())) {
                URI sourceURI;
                items.put(delayedUpdate.getSource(), ++pos);
                CommonODataEntity changes = this.service.getClient().getObjectFactory().newEntity(delayedUpdate.getSource().getEntity().getTypeName());
                AttachedEntityStatus status = this.service.getContext().entityContext().getStatus(delayedUpdate.getSource());
                if (status == AttachedEntityStatus.CHANGED) {
                    sourceURI = URIUtils.getURI((String)this.service.getClient().getServiceRoot(), (String)delayedUpdate.getSource().getEntity().getEditLink().toASCIIString());
                } else {
                    int sourcePos = items.get(delayedUpdate.getSource());
                    sourceURI = URI.create("$" + sourcePos);
                }
                for (EntityInvocationHandler target : delayedUpdate.getTargets()) {
                    URI targetURI;
                    status = this.service.getContext().entityContext().getStatus(target);
                    if (status == AttachedEntityStatus.CHANGED) {
                        targetURI = URIUtils.getURI((String)this.service.getClient().getServiceRoot(), (String)target.getEntity().getEditLink().toASCIIString());
                    } else {
                        int targetPos = items.get(target);
                        targetURI = URI.create("$" + targetPos);
                    }
                    changes.addLink(delayedUpdate.getType() == ODataLinkType.ENTITY_NAVIGATION ? this.service.getClient().getObjectFactory().newEntityNavigationLink(delayedUpdate.getSourceName(), targetURI) : this.service.getClient().getObjectFactory().newEntitySetNavigationLink(delayedUpdate.getSourceName(), targetURI));
                    LOG.debug("'{}' from {} to {}", new Object[]{delayedUpdate.getType().name(), sourceURI, targetURI});
                }
                this.queueUpdate(delayedUpdate.getSource(), sourceURI, changes, changeset);
                continue;
            }
            URI sourceURI = URIUtils.getURI((String)this.service.getClient().getServiceRoot(), (String)(delayedUpdate.getSource().getEntity().getEditLink().toASCIIString() + "/" + delayedUpdate.getSourceName() + "/$ref"));
            if (!this.queueUpdateLinkViaRef(delayedUpdate.getSource(), sourceURI, URI.create(delayedUpdate.getReference()), changeset)) continue;
            items.put(delayedUpdate.getSource(), ++pos);
        }
    }

    private AttachedEntityStatus queue(EntityInvocationHandler handler, CommonODataEntity entity, PersistenceChanges changeset) {
        switch (this.service.getContext().entityContext().getStatus(handler)) {
            case NEW: {
                this.queueCreate(handler, entity, changeset);
                return AttachedEntityStatus.NEW;
            }
            case DELETED: {
                this.queueDelete(handler, entity, changeset);
                return AttachedEntityStatus.DELETED;
            }
        }
        if (handler.isChanged(false)) {
            this.queueUpdate(handler, entity, changeset);
            return AttachedEntityStatus.CHANGED;
        }
        return null;
    }

    private void queueCreate(EntityInvocationHandler handler, CommonODataEntity entity, PersistenceChanges changeset) {
        LOG.debug("Create '{}'", (Object)handler);
        changeset.addChange((ODataBatchableRequest)this.service.getClient().getCUDRequestFactory().getEntityCreateRequest(handler.getEntitySetURI(), entity), handler);
    }

    private void queueUpdateMediaEntity(EntityInvocationHandler handler, URI uri, EdmStreamValue input, PersistenceChanges changeset) {
        LOG.debug("Update media entity '{}'", (Object)uri);
        ODataMediaEntityUpdateRequest req = this.service.getClient().getCUDRequestFactory().getMediaEntityUpdateRequest(uri, input.getStream());
        if (StringUtils.isNotBlank((CharSequence)input.getContentType())) {
            req.setContentType(input.getContentType());
        }
        if (StringUtils.isNotBlank((CharSequence)handler.getETag())) {
            req.setIfMatch(handler.getETag());
        }
        changeset.addChange((ODataBatchableRequest)req, handler);
    }

    private void queueUpdateMediaResource(EntityInvocationHandler handler, URI uri, EdmStreamValue input, PersistenceChanges changeset) {
        LOG.debug("Update media entity '{}'", (Object)uri);
        ODataStreamUpdateRequest req = this.service.getClient().getCUDRequestFactory().getStreamUpdateRequest(uri, input.getStream());
        if (StringUtils.isNotBlank((CharSequence)input.getContentType())) {
            req.setContentType(input.getContentType());
        }
        if (StringUtils.isNotBlank((CharSequence)handler.getETag())) {
            req.setIfMatch(handler.getETag());
        }
        changeset.addChange((ODataBatchableRequest)req, handler);
    }

    private void queueUpdate(EntityInvocationHandler handler, CommonODataEntity changes, PersistenceChanges changeset) {
        LOG.debug("Update '{}'", (Object)handler.getEntityURI());
        ODataEntityUpdateRequest req = this.service.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) <= 0 ? ((org.apache.olingo.client.api.v3.EdmEnabledODataClient)this.service.getClient()).getCUDRequestFactory().getEntityUpdateRequest(handler.getEntityURI(), (CommonUpdateType)org.apache.olingo.client.api.communication.request.cud.v3.UpdateType.PATCH, changes) : ((EdmEnabledODataClient)this.service.getClient()).getCUDRequestFactory().getEntityUpdateRequest(handler.getEntityURI(), (CommonUpdateType)UpdateType.PATCH, changes);
        req.setPrefer(new ODataPreferences(this.service.getClient().getServiceVersion()).returnContent());
        if (StringUtils.isNotBlank((CharSequence)handler.getETag())) {
            req.setIfMatch(handler.getETag());
        }
        changeset.addChange((ODataBatchableRequest)req, handler);
    }

    private boolean queueUpdateLinkViaRef(EntityInvocationHandler handler, URI source, URI targetRef, PersistenceChanges changeset) {
        LOG.debug("Update '{}'", (Object)targetRef);
        if (this.service.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) >= 1) {
            ODataReferenceAddingRequest req = ((EdmEnabledODataClient)this.service.getClient()).getCUDRequestFactory().getReferenceAddingRequest(source, targetRef);
            req.setPrefer(new ODataPreferences(this.service.getClient().getServiceVersion()).returnContent());
            if (StringUtils.isNotBlank((CharSequence)handler.getETag())) {
                req.setIfMatch(handler.getETag());
            }
            changeset.addChange((ODataBatchableRequest)req, handler);
            return true;
        }
        return false;
    }

    private void queueUpdate(EntityInvocationHandler handler, URI uri, CommonODataEntity changes, PersistenceChanges changeset) {
        LOG.debug("Update '{}'", (Object)uri);
        ODataEntityUpdateRequest req = this.service.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) <= 0 ? ((org.apache.olingo.client.api.v3.EdmEnabledODataClient)this.service.getClient()).getCUDRequestFactory().getEntityUpdateRequest(uri, (CommonUpdateType)org.apache.olingo.client.api.communication.request.cud.v3.UpdateType.PATCH, changes) : ((EdmEnabledODataClient)this.service.getClient()).getCUDRequestFactory().getEntityUpdateRequest(uri, (CommonUpdateType)UpdateType.PATCH, changes);
        req.setPrefer(new ODataPreferences(this.service.getClient().getServiceVersion()).returnContent());
        if (StringUtils.isNotBlank((CharSequence)handler.getETag())) {
            req.setIfMatch(handler.getETag());
        }
        changeset.addChange((ODataBatchableRequest)req, handler);
    }

    private void queueDelete(EntityInvocationHandler handler, CommonODataEntity entity, PersistenceChanges changeset) {
        URI deleteURI = entity.getEditLink() == null ? handler.getEntityURI() : entity.getEditLink();
        changeset.addChange((ODataBatchableRequest)this.buildDeleteRequest(deleteURI, handler.getETag()), handler);
    }

    private void queueDelete(URI deleteURI, String etag, PersistenceChanges changeset) {
        changeset.addChange((ODataBatchableRequest)this.buildDeleteRequest(deleteURI, etag), null);
    }

    private ODataDeleteRequest buildDeleteRequest(URI deleteURI, String etag) {
        LOG.debug("Delete '{}'", (Object)deleteURI);
        ODataDeleteRequest req = this.service.getClient().getCUDRequestFactory().getDeleteRequest(deleteURI);
        if (StringUtils.isNotBlank((CharSequence)etag)) {
            req.setIfMatch(etag);
        }
        return req;
    }

    private AttachedEntityStatus resolveNavigationLink(NavigationProperty property, EntityInvocationHandler handler) {
        if (handler.getUUID().getEntitySetURI() == null) {
            Object key = CoreUtils.getKey(this.service.getClient(), handler, handler.getTypeRef(), handler.getEntity());
            handler.updateUUID(CoreUtils.getTargetEntitySetURI(this.service.getClient(), property), handler.getTypeRef(), null);
            this.service.getContext().entityContext().attach(handler, AttachedEntityStatus.NEW);
            return AttachedEntityStatus.NEW;
        }
        this.service.getContext().entityContext().attach(handler, AttachedEntityStatus.LINKED);
        return AttachedEntityStatus.LINKED;
    }
}

