/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.olingo.client.api.communication.request.retrieve.ODataPropertyRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataComplexValue;
import org.apache.olingo.commons.api.domain.ODataLinked;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.annotations.ComplexType;
import org.apache.olingo.ext.proxy.api.annotations.NavigationProperty;
import org.apache.olingo.ext.proxy.commons.AbstractStructuredInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;

public class ComplexInvocationHandler
extends AbstractStructuredInvocationHandler {
    private static Pair<ODataComplexValue<? extends CommonODataProperty>, Class<?>> init(Class<?> typeRef, AbstractService<?> service) {
        Class<?> complexTypeRef = Collection.class.isAssignableFrom(typeRef) ? ClassUtils.extractTypeArg(typeRef, new Class[0]) : typeRef;
        ComplexType annotation = complexTypeRef.getAnnotation(ComplexType.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Invalid complex type " + complexTypeRef);
        }
        FullQualifiedName typeName = new FullQualifiedName(ClassUtils.getNamespace(complexTypeRef), annotation.name());
        ODataComplexValue complex = service.getClient().getObjectFactory().newComplexValue(typeName.toString());
        return new ImmutablePair((Object)complex, complexTypeRef);
    }

    public static ComplexInvocationHandler getInstance(String propertyName, EntityInvocationHandler handler, Class<?> typeRef) {
        Pair<ODataComplexValue<? extends CommonODataProperty>, Class<?>> init = ComplexInvocationHandler.init(typeRef, handler.service);
        return new ComplexInvocationHandler((ODataComplexValue<? extends CommonODataProperty>)((ODataComplexValue)init.getLeft()), (Class)init.getRight(), handler);
    }

    public static ComplexInvocationHandler getInstance(ODataComplexValue<?> complex, Class<?> typeRef, AbstractService<?> service) {
        return new ComplexInvocationHandler(complex, typeRef, service);
    }

    public static ComplexInvocationHandler getInstance(Class<?> typeRef, AbstractService<?> service) {
        Pair<ODataComplexValue<? extends CommonODataProperty>, Class<?>> init = ComplexInvocationHandler.init(typeRef, service);
        return new ComplexInvocationHandler((ODataComplexValue<? extends CommonODataProperty>)((ODataComplexValue)init.getLeft()), (Class)init.getRight(), service);
    }

    public static ComplexInvocationHandler getInstance(Class<?> typeRef, AbstractService<?> service, CommonURIBuilder<?> uri) {
        Pair<ODataComplexValue<? extends CommonODataProperty>, Class<?>> init = ComplexInvocationHandler.init(typeRef, service);
        return new ComplexInvocationHandler((ODataComplexValue<? extends CommonODataProperty>)((ODataComplexValue)init.getLeft()), (Class)init.getRight(), service, uri);
    }

    public static ComplexInvocationHandler getInstance(ODataComplexValue<? extends CommonODataProperty> complex, Class<?> typeRef, AbstractService<?> service, CommonURIBuilder<?> uri) {
        return new ComplexInvocationHandler(complex, typeRef, service, uri);
    }

    private ComplexInvocationHandler(ODataComplexValue<? extends CommonODataProperty> complex, Class<?> typeRef, AbstractService<?> service, CommonURIBuilder<?> uri) {
        super(typeRef, complex, service);
        this.uri = uri;
        this.baseURI = this.uri == null ? null : this.uri.build();
    }

    private ComplexInvocationHandler(ODataComplexValue<? extends CommonODataProperty> complex, Class<?> typeRef, EntityInvocationHandler handler) {
        super(typeRef, complex, handler);
        this.uri = null;
    }

    private ComplexInvocationHandler(ODataComplexValue<? extends CommonODataProperty> complex, Class<?> typeRef, AbstractService<?> service) {
        super(typeRef, complex, service);
        this.uri = null;
    }

    public ODataComplexValue<CommonODataProperty> getComplex() {
        return (ODataComplexValue)this.internal;
    }

    @Override
    protected Object getNavigationPropertyValue(NavigationProperty property, Method getter) {
        if (!(this.internal instanceof ODataLinked)) {
            throw new UnsupportedOperationException("Internal object is not navigable");
        }
        return this.retrieveNavigationProperty(property, getter);
    }

    @Override
    public boolean isChanged() {
        return this.getEntityHandler() == null ? false : this.getEntityHandler().isChanged();
    }

    @Override
    protected void load() {
        try {
            if (this.uri != null) {
                ODataPropertyRequest req = this.getClient().getRetrieveRequestFactory().getPropertyRequest(this.uri.build());
                ODataRetrieveResponse res = (ODataRetrieveResponse)req.execute();
                this.internal = ((CommonODataProperty)res.getBody()).getValue();
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Complex at '" + this.uri + "' not found", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Error retrieving complex '" + this.uri + "'", (Throwable)e);
            throw new IllegalArgumentException("Error retrieving " + this.typeRef.getSimpleName(), e);
        }
    }

    @Override
    protected <T extends CommonODataProperty> List<T> getInternalProperties() {
        ArrayList<CommonODataProperty> res = new ArrayList<CommonODataProperty>();
        if (this.getComplex() != null) {
            for (CommonODataProperty property : this.getComplex()) {
                res.add(property);
            }
        }
        return res;
    }

    @Override
    protected CommonODataProperty getInternalProperty(String name) {
        return this.getComplex() == null ? null : this.getComplex().get(name);
    }
}

