/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.olingo.client.api.communication.request.retrieve.ODataPropertyRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataCollectionValue;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.domain.v4.ODataAnnotation;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.ComplexCollection;
import org.apache.olingo.ext.proxy.api.ComplexType;
import org.apache.olingo.ext.proxy.commons.AbstractCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.OperationInvocationHandler;

public class ComplexCollectionInvocationHandler<T extends ComplexType<?>>
extends AbstractCollectionInvocationHandler<T, ComplexCollection<T, ?, ?>> {
    public ComplexCollectionInvocationHandler(AbstractService<?> service, Class<T> itemRef) {
        this(service, new ArrayList(), itemRef, null);
    }

    public ComplexCollectionInvocationHandler(Class<T> itemRef, AbstractService<?> service, CommonURIBuilder<?> uri) {
        this(service, new ArrayList(), itemRef, uri);
    }

    public ComplexCollectionInvocationHandler(AbstractService<?> service, Collection<T> items, Class<T> itemRef, CommonURIBuilder<?> uri) {
        super(service, items, itemRef, uri);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("filter".equals(method.getName()) || "orderBy".equals(method.getName()) || "top".equals(method.getName()) || "skip".equals(method.getName()) || "expand".equals(method.getName()) || "select".equals(method.getName()) || "nextPage".equals(method.getName()) || "execute".equals(method.getName())) {
            this.invokeSelfMethod(method, args);
            return proxy;
        }
        if (this.isSelfMethod(method, args)) {
            return this.invokeSelfMethod(method, args);
        }
        if ("operations".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            Class<?> returnType = method.getReturnType();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{returnType}, (InvocationHandler)OperationInvocationHandler.getInstance(this));
        }
        throw new NoSuchMethodException(method.getName());
    }

    @Override
    public Triple<List<T>, URI, List<ODataAnnotation>> fetchPartial(URI uri, Class<T> typeRef) {
        ODataPropertyRequest req = this.getClient().getRetrieveRequestFactory().getPropertyRequest(uri);
        if (this.getClient().getServiceVersion().compareTo((Enum)ODataServiceVersion.V30) > 0) {
            req.setPrefer(this.getClient().newPreferences().includeAnnotations("*"));
        }
        ODataRetrieveResponse res = (ODataRetrieveResponse)req.execute();
        ArrayList resItems = new ArrayList();
        CommonODataProperty property = (CommonODataProperty)res.getBody();
        if (property != null && property.hasCollectionValue()) {
            for (ODataValue item : (ODataCollectionValue)property.getValue()) {
                Class<Object> actualRef = null;
                if (StringUtils.isNotBlank((CharSequence)item.getTypeName())) {
                    actualRef = this.service.getComplexTypeClass(item.getTypeName());
                }
                if (actualRef == null) {
                    actualRef = typeRef;
                }
                resItems.add(this.getComplex(property.getName(), item, actualRef, null, null, true));
            }
        }
        return new ImmutableTriple(resItems, null, Collections.emptyList());
    }
}

