/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.Operations;
import org.apache.olingo.ext.proxy.api.annotations.Operation;
import org.apache.olingo.ext.proxy.commons.AbstractStructuredInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.InvokerInvocationHandler;

public class StructuredComposableInvokerInvocationHandler<T, O extends Operations>
extends InvokerInvocationHandler<T, O> {
    private AbstractStructuredInvocationHandler structuredHandler;

    public StructuredComposableInvokerInvocationHandler(URI uri, Map<String, ODataValue> parameters, Operation operation, EdmOperation edmOperation, Type[] references, EdmTypeInfo returnType, AbstractService<?> service) {
        super(uri, parameters, operation, edmOperation, references, service);
        if (!edmOperation.getReturnType().isCollection()) {
            if (returnType.isEntityType()) {
                this.structuredHandler = EntityInvocationHandler.getInstance(uri, this.targetRef, service);
            }
            if (returnType.isComplexType()) {
                this.structuredHandler = ComplexInvocationHandler.getInstance(this.targetRef, service, service.getClient().newURIBuilder(uri.toASCIIString()));
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("get")) {
            return this.structuredHandler.invoke(proxy, method, args);
        }
        if (method.getName().startsWith("set")) {
            return this.structuredHandler.invoke(proxy, method, args);
        }
        if ("filter".equals(method.getName()) || "orderBy".equals(method.getName()) || "top".equals(method.getName()) || "skip".equals(method.getName()) || "expand".equals(method.getName()) || "select".equals(method.getName())) {
            return super.invoke(proxy, method, args);
        }
        if ("operations".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            return super.invoke(proxy, method, args);
        }
        if (this.isSelfMethod(method, args)) {
            return this.invokeSelfMethod(method, args);
        }
        throw new NoSuchMethodException(method.getName());
    }
}

