/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientInlineEntity;
import org.apache.olingo.client.api.domain.ClientInlineEntitySet;
import org.apache.olingo.client.api.domain.ClientLink;
import org.apache.olingo.client.api.domain.ClientLinked;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.uri.QueryOption;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractEntitySet;
import org.apache.olingo.ext.proxy.api.ComplexCollection;
import org.apache.olingo.ext.proxy.api.EdmStreamValue;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.PrimitiveCollection;
import org.apache.olingo.ext.proxy.api.annotations.ComplexType;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.api.annotations.NavigationProperty;
import org.apache.olingo.ext.proxy.api.annotations.Property;
import org.apache.olingo.ext.proxy.commons.AbstractInvocationHandler;
import org.apache.olingo.ext.proxy.commons.AnnotatableInvocationHandler;
import org.apache.olingo.ext.proxy.commons.AnnotatationsInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EdmStreamValueHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.OperationInvocationHandler;
import org.apache.olingo.ext.proxy.commons.PrimitiveCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.context.AttachedEntityStatus;
import org.apache.olingo.ext.proxy.context.EntityContext;
import org.apache.olingo.ext.proxy.context.EntityUUID;
import org.apache.olingo.ext.proxy.utils.ClassUtils;
import org.apache.olingo.ext.proxy.utils.CoreUtils;
import org.apache.olingo.ext.proxy.utils.ProxyUtils;

public abstract class AbstractStructuredInvocationHandler
extends AbstractInvocationHandler {
    protected URIBuilder uri;
    protected URI baseURI;
    protected final Class<?> typeRef;
    protected EntityInvocationHandler entityHandler;
    protected Object internal;
    private final Map<String, AnnotatableInvocationHandler> propAnnotatableHandlers = new HashMap<String, AnnotatableInvocationHandler>();
    private final Map<String, AnnotatableInvocationHandler> navPropAnnotatableHandlers = new HashMap<String, AnnotatableInvocationHandler>();
    protected final Map<String, Object> propertyChanges = new HashMap<String, Object>();
    protected final Map<String, Object> propertyCache = new HashMap<String, Object>();
    protected final Map<NavigationProperty, Object> linkChanges = new HashMap<NavigationProperty, Object>();
    protected final Map<NavigationProperty, Object> linkCache = new HashMap<NavigationProperty, Object>();
    protected int propertiesTag = 0;
    protected int linksTag = 0;
    protected final Map<String, EdmStreamValue> streamedPropertyChanges = new HashMap<String, EdmStreamValue>();
    protected final Map<String, EdmStreamValue> streamedPropertyCache = new HashMap<String, EdmStreamValue>();

    protected AbstractStructuredInvocationHandler(Class<?> typeRef, AbstractService<?> service) {
        super(service);
        this.internal = null;
        this.typeRef = typeRef;
        this.entityHandler = null;
    }

    protected AbstractStructuredInvocationHandler(Class<?> typeRef, Object internal, AbstractService<?> service) {
        super(service);
        this.internal = internal;
        this.typeRef = typeRef;
        this.entityHandler = null;
    }

    protected AbstractStructuredInvocationHandler(Class<?> typeRef, Object internal, EntityInvocationHandler entityHandler) {
        super(entityHandler == null ? null : entityHandler.service);
        this.internal = internal;
        this.typeRef = typeRef;
        this.entityHandler = entityHandler == this ? null : entityHandler;
    }

    public Object getInternal() {
        return this.internal;
    }

    public EntityInvocationHandler getEntityHandler() {
        return this.entityHandler == null ? (this instanceof EntityInvocationHandler ? (EntityInvocationHandler)EntityInvocationHandler.class.cast(this) : null) : this.entityHandler;
    }

    public void setEntityHandler(EntityInvocationHandler entityHandler) {
        this.entityHandler = entityHandler == this ? null : entityHandler;
    }

    public Class<?> getTypeRef() {
        return this.typeRef;
    }

    @Override
    public Object invoke(final Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("get")) {
            Object res;
            Method getter = this.typeRef.getMethod(method.getName(), new Class[0]);
            Property property = ClassUtils.getAnnotation(Property.class, getter);
            if (property == null) {
                NavigationProperty navProp = ClassUtils.getAnnotation(NavigationProperty.class, getter);
                if (navProp == null) {
                    throw new UnsupportedOperationException("Unsupported method " + method.getName());
                }
                res = this.getNavigationPropertyValue(navProp, getter);
            } else {
                res = this.getPropertyValue(property.name(), getter.getGenericReturnType());
            }
            return res;
        }
        if (method.getName().startsWith("set")) {
            String getterName = method.getName().replaceFirst("set", "get");
            Method getter = this.typeRef.getMethod(getterName, new Class[0]);
            Property property = ClassUtils.getAnnotation(Property.class, getter);
            if (property == null) {
                NavigationProperty navProp = ClassUtils.getAnnotation(NavigationProperty.class, getter);
                if (navProp == null) {
                    throw new UnsupportedOperationException("Unsupported method " + method.getName());
                }
                if (ArrayUtils.isEmpty((Object[])args) || args.length != 1) {
                    throw new IllegalArgumentException("Invalid argument");
                }
                this.setNavigationPropertyValue(navProp, args[0]);
            } else {
                this.setPropertyValue(property, args[0]);
            }
            return ClassUtils.returnVoid();
        }
        if ("expand".equals(method.getName()) || "select".equals(method.getName()) || "refs".equals(method.getName())) {
            this.invokeSelfMethod(method, args);
            return proxy;
        }
        if (this.isSelfMethod(method, args)) {
            return this.invokeSelfMethod(method, args);
        }
        if ("load".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            this.load();
            return proxy;
        }
        if ("loadAsync".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            return this.service.getClient().getConfiguration().getExecutor().submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AbstractStructuredInvocationHandler.this.load();
                    return proxy;
                }
            });
        }
        if ("operations".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            Class<?> returnType = method.getReturnType();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{returnType}, (InvocationHandler)OperationInvocationHandler.getInstance(this.getEntityHandler()));
        }
        if ("annotations".equals(method.getName()) && ArrayUtils.isEmpty((Object[])args)) {
            Class<?> returnType = method.getReturnType();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{returnType}, (InvocationHandler)AnnotatationsInvocationHandler.getInstance(this.getEntityHandler(), this));
        }
        throw new NoSuchMethodException(method.getName());
    }

    public void delete(String name) {
        if (this.baseURI != null) {
            this.getContext().entityContext().addFurtherDeletes(this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name).appendValueSegment().build());
        }
    }

    public void delete() {
        EntityContext entityContext = this.getContext().entityContext();
        if (this instanceof EntityInvocationHandler) {
            this.deleteEntity((EntityInvocationHandler)EntityInvocationHandler.class.cast(this), null);
        } else if (this.baseURI != null) {
            entityContext.addFurtherDeletes(this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendValueSegment().build());
        }
    }

    protected void attach() {
        this.attach(AttachedEntityStatus.ATTACHED, false);
    }

    protected void attach(AttachedEntityStatus status) {
        this.attach(status, true);
    }

    protected void attach(AttachedEntityStatus status, boolean override) {
        if (this.getContext().entityContext().isAttached(this.getEntityHandler())) {
            if (override) {
                this.getContext().entityContext().setStatus(this.getEntityHandler(), status);
            }
        } else {
            this.getContext().entityContext().attach(this.getEntityHandler(), status);
        }
    }

    protected Object getPropertyValue(String name, Type type) {
        try {
            Object res;
            Class ref = ClassUtils.getTypeClass(type);
            if (ref == EdmStreamValue.class) {
                Object res2;
                if (this.streamedPropertyCache.containsKey(name)) {
                    res2 = this.streamedPropertyCache.get(name);
                } else if (this.streamedPropertyChanges.containsKey(name)) {
                    res2 = this.streamedPropertyChanges.get(name);
                } else {
                    res2 = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EdmStreamValue.class}, (InvocationHandler)new EdmStreamValueHandler(this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name).build(), this.service));
                    this.streamedPropertyCache.put(name, (EdmStreamValue)EdmStreamValue.class.cast(res2));
                }
                return res2;
            }
            if (this.propertyChanges.containsKey(name)) {
                res = this.propertyChanges.get(name);
            } else if (this.propertyCache.containsKey(name)) {
                res = this.propertyCache.get(name);
            } else {
                ClientProperty property = this.getInternalProperty(name);
                if (ref != null && ClassUtils.getTypeClass(type).isAnnotationPresent(ComplexType.class)) {
                    res = this.getComplex(name, property == null || property.hasNullValue() ? null : property.getValue(), ref, this.getEntityHandler(), this.baseURI, false);
                } else if (ref != null && ComplexCollection.class.isAssignableFrom(ref)) {
                    ComplexCollectionInvocationHandler<Object> collectionHandler;
                    Class<?> itemRef = ClassUtils.extractTypeArg(ref, ComplexCollection.class);
                    if (property == null || property.hasNullValue()) {
                        collectionHandler = new ComplexCollectionInvocationHandler(itemRef, this.service, this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name));
                    } else {
                        ArrayList items = new ArrayList();
                        for (ClientValue item : property.getValue().asCollection()) {
                            items.add(this.getComplex(name, item, itemRef, this.getEntityHandler(), null, true));
                        }
                        collectionHandler = new ComplexCollectionInvocationHandler(this.service, items, itemRef, this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name));
                    }
                    res = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ref}, collectionHandler);
                } else if (ref != null && PrimitiveCollection.class.isAssignableFrom(ref)) {
                    PrimitiveCollectionInvocationHandler<Object> collectionHandler;
                    if (property == null || property.hasNullValue()) {
                        collectionHandler = new PrimitiveCollectionInvocationHandler(this.service, null, this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name));
                    } else {
                        ArrayList<Object> items = new ArrayList<Object>();
                        for (ClientValue item : property.getValue().asCollection()) {
                            items.add(item.asPrimitive().toValue());
                        }
                        collectionHandler = new PrimitiveCollectionInvocationHandler(this.service, items, null, this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString()).appendPropertySegment(name));
                    }
                    res = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{PrimitiveCollection.class}, collectionHandler);
                } else {
                    Object object = res = property == null || property.hasNullValue() ? null : CoreUtils.getObjectFromODataValue(property.getValue(), type, this.service);
                }
            }
            if (res != null) {
                this.addPropertyChanges(name, res);
                this.propertyCache.put(name, res);
            }
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error getting value for property '" + name + "'", e);
        }
    }

    protected void setPropertyValue(Property property, Object value) {
        if (EdmPrimitiveTypeKind.Stream.getFullQualifiedName().toString().equalsIgnoreCase(property.type())) {
            this.setStreamedProperty(property, (EdmStreamValue)value);
        } else {
            this.addPropertyChanges(property.name(), value);
            if (value != null) {
                Collection<Object> coll = Collection.class.isAssignableFrom(value.getClass()) ? (Collection)Collection.class.cast(value) : Collections.singleton(value);
                for (Object e : coll) {
                    InvocationHandler handler;
                    if (!(e instanceof Proxy) || !((handler = Proxy.getInvocationHandler(e)) instanceof ComplexInvocationHandler) || ((ComplexInvocationHandler)handler).getEntityHandler() != null) continue;
                    ((ComplexInvocationHandler)handler).setEntityHandler(this.getEntityHandler());
                }
            }
        }
        this.attach(AttachedEntityStatus.CHANGED);
    }

    private void setStreamedProperty(Property property, EdmStreamValue input) {
        EdmStreamValue obj = this.streamedPropertyChanges.get(property.name());
        if (obj instanceof InputStream) {
            IOUtils.closeQuietly((InputStream)((InputStream)((Object)obj)));
        }
        this.streamedPropertyCache.remove(property.name());
        this.streamedPropertyChanges.put(property.name(), input.load());
    }

    protected abstract Object getNavigationPropertyValue(NavigationProperty var1, Method var2);

    protected Object retrieveNavigationProperty(NavigationProperty property, Method getter) {
        Object navPropValue;
        Class<?> type = getter.getReturnType();
        Class<?> collItemType = EntityCollection.class.isAssignableFrom(type) ? ClassUtils.extractTypeArg(type, EntityCollection.class, ComplexCollection.class) : type;
        URI targetEntitySetURI = CoreUtils.getTargetEntitySetURI(this.getClient(), property);
        ClientLink link = ((ClientLinked)this.internal).getNavigationLink(property.name());
        if (link instanceof ClientInlineEntity) {
            navPropValue = ProxyUtils.getEntityProxy(this.service, ((ClientInlineEntity)link).getEntity(), targetEntitySetURI, type, null, false);
        } else if (link instanceof ClientInlineEntitySet) {
            navPropValue = ProxyUtils.getEntityCollectionProxy(this.service, collItemType, type, targetEntitySetURI, ((ClientInlineEntitySet)link).getEntitySet(), targetEntitySetURI, false);
        } else {
            URI targetURI = URIUtils.getURI((URI)this.getEntityHandler().getEntityURI(), (String)property.name());
            if (EntityCollection.class.isAssignableFrom(type)) {
                navPropValue = ProxyUtils.getEntityCollectionProxy(this.service, collItemType, type, targetEntitySetURI, null, targetURI, true);
            } else if (AbstractEntitySet.class.isAssignableFrom(type)) {
                navPropValue = ProxyUtils.getEntitySetProxy(this.service, type, targetURI);
            } else {
                EntityUUID uuid = new EntityUUID(targetEntitySetURI, collItemType, null);
                LOG.debug("Ask for '{}({})'", (Object)collItemType.getSimpleName(), null);
                EntityInvocationHandler handler = this.getContext().entityContext().getEntity(uuid);
                if (handler == null) {
                    ClientEntity entity = this.getClient().getObjectFactory().newEntity(new FullQualifiedName(collItemType.getAnnotation(Namespace.class).value(), ClassUtils.getEntityTypeName(collItemType)));
                    handler = EntityInvocationHandler.getInstance(entity, URIUtils.getURI((URI)this.uri.build(), (String)property.name()), targetEntitySetURI, collItemType, this.service);
                } else if (this.getContext().entityContext().getStatus(handler) == AttachedEntityStatus.DELETED) {
                    LOG.debug("Object '{}({})' has been deleted", (Object)collItemType.getSimpleName(), (Object)uuid);
                    handler = null;
                }
                navPropValue = handler == null ? null : Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{collItemType}, (InvocationHandler)handler);
            }
        }
        return navPropValue;
    }

    public Object readAdditionalProperty(String name) {
        return this.getPropertyValue(name, null);
    }

    public Map<String, Object> getPropertyChanges() {
        return this.propertyChanges;
    }

    public Collection<String> readAdditionalPropertyNames() {
        HashSet<String> res = new HashSet<String>(this.propertyChanges.keySet());
        HashSet<String> propertyNames = new HashSet<String>();
        for (Method method : this.typeRef.getMethods()) {
            Property ann = method.getAnnotation(Property.class);
            if (ann == null) continue;
            String property = ann.name();
            propertyNames.add(property);
            res.remove(property);
        }
        for (ClientProperty property : this.getInternalProperties()) {
            if (propertyNames.contains(property.getName())) continue;
            res.add(property.getName());
        }
        return res;
    }

    public void addAdditionalProperty(String name, Object value) {
        this.propertyChanges.put(name, value);
        this.attach(AttachedEntityStatus.CHANGED);
    }

    public Map<NavigationProperty, Object> getLinkChanges() {
        return this.linkChanges;
    }

    public void removeAdditionalProperty(String name) {
        this.propertyChanges.remove(name);
        this.attach(AttachedEntityStatus.CHANGED);
    }

    protected void addPropertyChanges(String name, Object value) {
        int checkpoint = this.propertyChanges.hashCode();
        this.updatePropertiesTag(checkpoint);
        this.propertyChanges.put(name, value);
    }

    protected void addLinkChanges(NavigationProperty navProp, Object value) {
        int checkpoint = this.linkChanges.hashCode();
        this.updateLinksTag(checkpoint);
        this.linkChanges.put(navProp, value);
        if (this.linkCache.containsKey(navProp)) {
            this.linkCache.remove(navProp);
        }
    }

    protected void updatePropertiesTag(int checkpoint) {
        if (this.propertiesTag == 0 || checkpoint == this.propertiesTag) {
            this.propertiesTag = this.propertyChanges.hashCode();
        }
    }

    protected void updateLinksTag(int checkpoint) {
        if (this.linksTag == 0 || checkpoint == this.linksTag) {
            this.linksTag = this.linkChanges.hashCode();
        }
    }

    public Map<String, EdmStreamValue> getStreamedPropertyChanges() {
        return this.streamedPropertyChanges;
    }

    private void setNavigationPropertyValue(NavigationProperty property, Object value) {
        if (!this.getContext().entityContext().isAttached(this.getEntityHandler())) {
            this.getContext().entityContext().attach(this.getEntityHandler(), AttachedEntityStatus.CHANGED);
        }
        this.addLinkChanges(property, value);
    }

    public Map<String, AnnotatableInvocationHandler> getPropAnnotatableHandlers() {
        return this.propAnnotatableHandlers;
    }

    public void putPropAnnotatableHandler(String propName, AnnotatableInvocationHandler handler) {
        this.propAnnotatableHandlers.put(propName, handler);
    }

    public Map<String, AnnotatableInvocationHandler> getNavPropAnnotatableHandlers() {
        return this.navPropAnnotatableHandlers;
    }

    public void putNavPropAnnotatableHandler(String navPropName, AnnotatableInvocationHandler handler) {
        this.navPropAnnotatableHandlers.put(navPropName, handler);
    }

    public void expand(String ... expand) {
        this.uri.replaceQueryOption(QueryOption.EXPAND, StringUtils.join((Object[])expand, (String)","));
    }

    public void select(String ... select) {
        this.uri.replaceQueryOption(QueryOption.SELECT, StringUtils.join((Object[])select, (String)","));
    }

    public void refs() {
        this.uri.appendRefSegment();
    }

    public void clearQueryOptions() {
        this.uri = this.baseURI == null ? null : this.getClient().newURIBuilder(this.baseURI.toASCIIString());
    }

    protected abstract void load();

    public abstract boolean isChanged();

    protected abstract <T extends ClientProperty> List<T> getInternalProperties();

    protected abstract ClientProperty getInternalProperty(String var1);
}

