/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntitySetRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractEntitySet;
import org.apache.olingo.ext.proxy.api.AbstractSingleton;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.commons.AbstractCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntitySetInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;

public abstract class AbstractEntityCollectionInvocationHandler<T extends EntityType<?>, EC extends EntityCollection<T, ?, ?>>
extends AbstractCollectionInvocationHandler<T, EC> {
    protected URI targetEntitySetURI;
    private boolean isSingleton = false;
    protected final Class<EC> collItemRef;

    public AbstractEntityCollectionInvocationHandler(Class<?> ref, AbstractService<?> service, URIBuilder uri) {
        super(service, new ArrayList(), ClassUtils.extractTypeArg(ref, AbstractEntitySet.class, AbstractSingleton.class, EntityCollection.class), uri);
        this.targetEntitySetURI = uri.build();
        this.isSingleton = AbstractSingleton.class.isAssignableFrom(ref);
        Type[] entitySetParams = ClassUtils.extractGenericType(ref, AbstractEntitySet.class, AbstractSingleton.class);
        this.collItemRef = entitySetParams != null ? (Class)entitySetParams[2] : null;
    }

    public AbstractEntityCollectionInvocationHandler(Class<? extends EntityCollection<T, ?, ?>> ref, AbstractService<?> service, URI targetEntitySetURI, URIBuilder uri) {
        super(service, new ArrayList(), ClassUtils.extractTypeArg(ref, EntityCollection.class), uri);
        this.uri = uri;
        this.targetEntitySetURI = targetEntitySetURI;
        this.collItemRef = ref;
    }

    @Override
    public Triple<List<T>, URI, List<ClientAnnotation>> fetchPartial(URI uri, Class<T> typeRef) {
        URI next;
        Object res;
        ArrayList<Object> entities = new ArrayList<Object>();
        ArrayList anns = new ArrayList();
        if (this.isSingleton) {
            res = (ODataRetrieveResponse)this.getClient().getRetrieveRequestFactory().getSingletonRequest(uri).execute();
            entities.add(res.getBody());
            next = null;
        } else {
            ODataEntitySetRequest req = this.getClient().getRetrieveRequestFactory().getEntitySetRequest(uri);
            req.setPrefer(this.getClient().newPreferences().includeAnnotations("*"));
            ODataRetrieveResponse res2 = (ODataRetrieveResponse)req.execute();
            ClientEntitySet clientEntitySet = (ClientEntitySet)res2.getBody();
            entities.addAll(clientEntitySet.getEntities());
            next = clientEntitySet.getNext();
            anns.addAll(clientEntitySet.getAnnotations());
        }
        res = new ArrayList(entities.size());
        for (ClientEntity clientEntity : entities) {
            Class<Object> actualRef = null;
            if (clientEntity.getTypeName() != null) {
                actualRef = this.service.getEntityTypeClass(clientEntity.getTypeName().toString());
            }
            if (actualRef == null) {
                actualRef = typeRef;
            }
            EntityInvocationHandler handler = this instanceof EntitySetInvocationHandler ? EntityInvocationHandler.getInstance(clientEntity, (EntitySetInvocationHandler)EntitySetInvocationHandler.class.cast(this), actualRef) : EntityInvocationHandler.getInstance(clientEntity, this.targetEntitySetURI, actualRef, this.service);
            EntityInvocationHandler handlerInTheContext = this.getContext().entityContext().getEntity(handler.getUUID());
            res.add((EntityType)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{actualRef}, (InvocationHandler)(handlerInTheContext == null ? handler : handlerInTheContext)));
        }
        return new ImmutableTriple(res, (Object)next, anns);
    }
}

