/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.provider.CsdlAbstractEdmItem;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;

public class CsdlSchema
extends CsdlAbstractEdmItem
implements CsdlAnnotatable {
    private static final long serialVersionUID = -1527213201328056750L;
    private String namespace;
    private String alias;
    private List<CsdlEnumType> enumTypes = new ArrayList<CsdlEnumType>();
    private List<CsdlTypeDefinition> typeDefinitions = new ArrayList<CsdlTypeDefinition>();
    private List<CsdlEntityType> entityTypes = new ArrayList<CsdlEntityType>();
    private List<CsdlComplexType> complexTypes = new ArrayList<CsdlComplexType>();
    private List<CsdlAction> actions = new ArrayList<CsdlAction>();
    private List<CsdlFunction> functions = new ArrayList<CsdlFunction>();
    private CsdlEntityContainer entityContainer;
    private List<CsdlTerm> terms = new ArrayList<CsdlTerm>();
    private final List<CsdlAnnotations> annotationGroups = new ArrayList<CsdlAnnotations>();
    private final List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();
    private Map<String, CsdlAnnotatable> annotatables;

    public String getNamespace() {
        return this.namespace;
    }

    public CsdlSchema setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public CsdlSchema setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public List<CsdlEnumType> getEnumTypes() {
        return this.enumTypes;
    }

    public CsdlEnumType getEnumType(String name) {
        return this.getOneByName(name, this.getEnumTypes());
    }

    public CsdlSchema setEnumTypes(List<CsdlEnumType> enumTypes) {
        this.enumTypes = enumTypes;
        return this;
    }

    public List<CsdlTypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public CsdlTypeDefinition getTypeDefinition(String name) {
        return this.getOneByName(name, this.getTypeDefinitions());
    }

    public CsdlSchema setTypeDefinitions(List<CsdlTypeDefinition> typeDefinitions) {
        this.typeDefinitions = typeDefinitions;
        return this;
    }

    public List<CsdlEntityType> getEntityTypes() {
        return this.entityTypes;
    }

    public CsdlEntityType getEntityType(String name) {
        return this.getOneByName(name, this.getEntityTypes());
    }

    public CsdlSchema setEntityTypes(List<CsdlEntityType> entityTypes) {
        this.entityTypes = entityTypes;
        return this;
    }

    public List<CsdlComplexType> getComplexTypes() {
        return this.complexTypes;
    }

    public CsdlComplexType getComplexType(String name) {
        return this.getOneByName(name, this.getComplexTypes());
    }

    public CsdlSchema setComplexTypes(List<CsdlComplexType> complexTypes) {
        this.complexTypes = complexTypes;
        return this;
    }

    public List<CsdlAction> getActions() {
        return this.actions;
    }

    public List<CsdlAction> getActions(String name) {
        return this.getAllByName(name, this.getActions());
    }

    public CsdlSchema setActions(List<CsdlAction> actions) {
        this.actions = actions;
        return this;
    }

    public List<CsdlFunction> getFunctions() {
        return this.functions;
    }

    public List<CsdlFunction> getFunctions(String name) {
        return this.getAllByName(name, this.getFunctions());
    }

    public CsdlSchema setFunctions(List<CsdlFunction> functions) {
        this.functions = functions;
        return this;
    }

    public CsdlEntityContainer getEntityContainer() {
        return this.entityContainer;
    }

    public CsdlSchema setEntityContainer(CsdlEntityContainer entityContainer) {
        this.entityContainer = entityContainer;
        return this;
    }

    public List<CsdlTerm> getTerms() {
        return this.terms;
    }

    public CsdlTerm getTerm(String name) {
        return this.getOneByName(name, this.getTerms());
    }

    public CsdlSchema setTerms(List<CsdlTerm> terms) {
        this.terms = terms;
        return this;
    }

    public List<CsdlAnnotations> getAnnotationGroups() {
        return this.annotationGroups;
    }

    public CsdlAnnotations getAnnotationGroup(String target) {
        CsdlAnnotations result = null;
        for (CsdlAnnotations annots : this.getAnnotationGroups()) {
            if (!target.equals(annots.getTarget())) continue;
            result = annots;
        }
        return result;
    }

    public CsdlAnnotation getAnnotation(String term) {
        CsdlAnnotation result = null;
        for (CsdlAnnotation annot : this.getAnnotations()) {
            if (!term.equals(annot.getTerm())) continue;
            result = annot;
        }
        return result;
    }

    @Override
    public List<CsdlAnnotation> getAnnotations() {
        return this.annotations;
    }

    public Map<String, CsdlAnnotatable> getAnnotatables() {
        if (this.annotatables == null) {
            this.annotatables = new HashMap<String, CsdlAnnotatable>();
            for (CsdlAnnotations annotationGroup : this.getAnnotationGroups()) {
                this.annotatables.put(null, annotationGroup);
            }
            for (CsdlAnnotation annotation : this.getAnnotations()) {
                this.annotatables.put(annotation.getTerm(), annotation);
            }
            for (CsdlAction action : this.getActions()) {
                this.annotatables.put(action.getName(), action);
            }
            for (CsdlComplexType complexType : this.getComplexTypes()) {
                this.annotatables.put(complexType.getName(), complexType);
            }
            for (CsdlEntityType entityType : this.getEntityTypes()) {
                this.annotatables.put(entityType.getName(), entityType);
            }
            for (CsdlEnumType enumType : this.getEnumTypes()) {
                this.annotatables.put(enumType.getName(), enumType);
            }
            for (CsdlFunction function : this.getFunctions()) {
                this.annotatables.put(function.getName(), function);
            }
            for (CsdlTerm term : this.getTerms()) {
                this.annotatables.put(term.getName(), term);
            }
            for (CsdlTypeDefinition typedef : this.getTypeDefinitions()) {
                this.annotatables.put(typedef.getName(), typedef);
            }
            if (this.entityContainer != null) {
                this.annotatables.put(this.entityContainer.getName(), this.entityContainer);
                for (CsdlAnnotation annotation : this.entityContainer.getAnnotations()) {
                    this.annotatables.put(annotation.getTerm(), annotation);
                }
                for (CsdlActionImport actionImport : this.entityContainer.getActionImports()) {
                    this.annotatables.put(actionImport.getName(), actionImport);
                }
                for (CsdlFunctionImport functionImport : this.entityContainer.getFunctionImports()) {
                    this.annotatables.put(functionImport.getName(), functionImport);
                }
                for (CsdlEntitySet entitySet : this.entityContainer.getEntitySets()) {
                    this.annotatables.put(entitySet.getName(), entitySet);
                }
                for (CsdlSingleton singleton : this.entityContainer.getSingletons()) {
                    this.annotatables.put(singleton.getName(), singleton);
                }
            }
        }
        return this.annotatables;
    }
}

