/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.provider.annotation;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlDynamicExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;

public class CsdlLogicalOrComparisonExpression
extends CsdlDynamicExpression
implements CsdlAnnotatable {
    private static final long serialVersionUID = -8268617065621508270L;
    private final LogicalOrComparisonExpressionType type;
    private CsdlExpression left;
    private CsdlExpression right;
    private List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();

    public CsdlLogicalOrComparisonExpression(LogicalOrComparisonExpressionType type) {
        this.type = type;
    }

    @Override
    public List<CsdlAnnotation> getAnnotations() {
        return this.annotations;
    }

    public CsdlLogicalOrComparisonExpression setAnnotations(List<CsdlAnnotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public LogicalOrComparisonExpressionType getType() {
        return this.type;
    }

    public CsdlExpression getLeft() {
        return this.left;
    }

    public CsdlLogicalOrComparisonExpression setLeft(CsdlExpression left) {
        this.left = left;
        if (this.getType() == LogicalOrComparisonExpressionType.Not) {
            this.right = left;
        }
        return this;
    }

    public CsdlExpression getRight() {
        return this.right;
    }

    public CsdlLogicalOrComparisonExpression setRight(CsdlExpression right) {
        this.right = right;
        if (this.getType() == LogicalOrComparisonExpressionType.Not) {
            this.left = right;
        }
        return this;
    }

    public static enum LogicalOrComparisonExpressionType {
        And,
        Or,
        Not,
        Eq,
        Ne,
        Gt,
        Ge,
        Lt,
        Le;


        public static LogicalOrComparisonExpressionType fromString(String value) {
            LogicalOrComparisonExpressionType result = null;
            try {
                result = LogicalOrComparisonExpressionType.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return result;
        }
    }
}

