/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmReferentialConstraint;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmReferentialConstraintImpl;

public class EdmNavigationPropertyImpl
extends AbstractEdmNamed
implements EdmElement,
EdmNavigationProperty {
    private final FullQualifiedName structuredTypeName;
    private final CsdlNavigationProperty navigationProperty;
    private List<EdmReferentialConstraint> referentialConstraints;
    private EdmEntityType typeImpl;
    private EdmNavigationProperty partnerNavigationProperty;

    public EdmNavigationPropertyImpl(Edm edm, FullQualifiedName structuredTypeName, CsdlNavigationProperty navigationProperty) {
        super(edm, navigationProperty.getName(), (CsdlAnnotatable)navigationProperty);
        this.structuredTypeName = structuredTypeName;
        this.navigationProperty = navigationProperty;
    }

    public boolean isCollection() {
        return this.navigationProperty.isCollection();
    }

    public boolean isNullable() {
        return this.navigationProperty.isNullable();
    }

    public boolean containsTarget() {
        return this.navigationProperty.isContainsTarget();
    }

    public EdmEntityType getType() {
        if (this.typeImpl == null) {
            this.typeImpl = this.edm.getEntityType(this.navigationProperty.getTypeFQN());
            if (this.typeImpl == null) {
                throw new EdmException("Cannot find type with name: " + this.navigationProperty.getTypeFQN());
            }
        }
        return this.typeImpl;
    }

    public EdmNavigationProperty getPartner() {
        String partner;
        if (this.partnerNavigationProperty == null && (partner = this.navigationProperty.getPartner()) != null) {
            String[] split;
            EdmEntityType type = this.getType();
            EdmNavigationProperty property = null;
            for (String element : split = partner.split("/")) {
                property = type.getNavigationProperty(element);
                if (property == null) {
                    throw new EdmException("Cannot find navigation property with name: " + element + " at type " + type.getName());
                }
                type = property.getType();
            }
            this.partnerNavigationProperty = property;
        }
        return this.partnerNavigationProperty;
    }

    public String getReferencingPropertyName(String referencedPropertyName) {
        List referentialConstraints = this.navigationProperty.getReferentialConstraints();
        if (referentialConstraints != null) {
            for (CsdlReferentialConstraint constraint : referentialConstraints) {
                if (!constraint.getReferencedProperty().equals(referencedPropertyName)) continue;
                return constraint.getProperty();
            }
        }
        return null;
    }

    public List<EdmReferentialConstraint> getReferentialConstraints() {
        if (this.referentialConstraints == null) {
            List providerConstraints = this.navigationProperty.getReferentialConstraints();
            ArrayList<EdmReferentialConstraint> referentialConstraintsLocal = new ArrayList<EdmReferentialConstraint>();
            if (providerConstraints != null) {
                for (CsdlReferentialConstraint constraint : providerConstraints) {
                    referentialConstraintsLocal.add(new EdmReferentialConstraintImpl(this.edm, constraint));
                }
            }
            this.referentialConstraints = referentialConstraintsLocal;
        }
        return Collections.unmodifiableList(this.referentialConstraints);
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.NavigationProperty;
    }

    public String getAnnotationsTargetPath() {
        return this.getName();
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.structuredTypeName;
    }
}

