/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmTermImpl
extends AbstractEdmNamed
implements EdmTerm {
    private final CsdlTerm term;
    private final FullQualifiedName fqn;
    private final EdmTypeInfo typeInfo;
    private EdmType termType;
    private EdmTerm baseTerm;
    private List<Class<?>> appliesTo;

    public EdmTermImpl(Edm edm, String namespace, CsdlTerm term) {
        super(edm, term.getName(), (CsdlAnnotatable)term);
        this.term = term;
        this.fqn = new FullQualifiedName(namespace, term.getName());
        this.typeInfo = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(term.getType()).build();
    }

    public FullQualifiedName getFullQualifiedName() {
        return this.fqn;
    }

    public EdmType getType() {
        if (this.termType == null) {
            Object object = this.typeInfo.isPrimitiveType() ? EdmPrimitiveTypeFactory.getInstance(this.typeInfo.getPrimitiveTypeKind()) : (this.typeInfo.isTypeDefinition() ? this.typeInfo.getTypeDefinition() : (this.typeInfo.isEnumType() ? this.typeInfo.getEnumType() : (this.termType = this.typeInfo.isComplexType() ? this.typeInfo.getComplexType() : null)));
            if (this.termType == null) {
                throw new EdmException("Cannot find type with name: " + this.typeInfo.getFullQualifiedName());
            }
        }
        return this.termType;
    }

    public EdmTerm getBaseTerm() {
        if (this.baseTerm == null && this.term.getBaseTerm() != null) {
            this.baseTerm = this.edm.getTerm(new FullQualifiedName(this.term.getBaseTerm()));
        }
        return this.baseTerm;
    }

    public List<Class<?>> getAppliesTo() {
        if (this.appliesTo == null) {
            ArrayList appliesToLocal = new ArrayList();
            for (String element : this.term.getAppliesTo()) {
                try {
                    appliesToLocal.add(ClassUtils.getClass((String)(EdmTerm.class.getPackage().getName() + ".Edm" + element)));
                }
                catch (ClassNotFoundException e) {
                    throw new EdmException("Could not load Edm class for {} " + element, (Exception)e);
                }
            }
            this.appliesTo = appliesToLocal;
        }
        return this.appliesTo;
    }

    public Boolean isNullable() {
        return this.term.isNullable();
    }

    public Integer getMaxLength() {
        return this.term.getMaxLength();
    }

    public Integer getPrecision() {
        return this.term.getPrecision();
    }

    public Integer getScale() {
        return this.term.getScale();
    }

    public SRID getSrid() {
        return this.term.getSrid();
    }

    public String getDefaultValue() {
        return this.term.getDefaultValue();
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.Term;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.getFullQualifiedName();
    }

    public String getAnnotationsTargetPath() {
        return null;
    }
}

