/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.annotation.EdmConstantAnnotationExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmDynamicAnnotationExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.ConstantAnnotationExpression;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmConstantAnnotationExpressionImpl
implements EdmConstantAnnotationExpression {
    private final Valuable value;
    private final EdmPrimitiveType type;

    public EdmConstantAnnotationExpressionImpl(ConstantAnnotationExpression constExprConstruct) {
        if (constExprConstruct.getType() == ConstantAnnotationExpression.Type.EnumMember) {
            ArrayList<Property> enumValues = new ArrayList<Property>();
            String enumTypeName = null;
            for (String split : StringUtils.split((String)constExprConstruct.getValue(), (char)' ')) {
                String[] enumSplit = StringUtils.split((String)split, (char)'/');
                enumTypeName = enumSplit[0];
                enumValues.add(new Property(enumSplit[0], enumSplit[1]));
            }
            if (enumValues.size() == 1) {
                this.value = (Valuable)enumValues.get(0);
            } else {
                ArrayList<Property> collValue = new ArrayList<Property>();
                for (Property enumValue : enumValues) {
                    collValue.add(enumValue);
                }
                this.value = new Property(enumTypeName, null, ValueType.COLLECTION_ENUM, collValue);
            }
            this.type = null;
        } else {
            EdmPrimitiveTypeKind kind;
            switch (constExprConstruct.getType()) {
                case Binary: {
                    kind = EdmPrimitiveTypeKind.Binary;
                    break;
                }
                case Bool: {
                    kind = EdmPrimitiveTypeKind.Boolean;
                    break;
                }
                case Date: {
                    kind = EdmPrimitiveTypeKind.Date;
                    break;
                }
                case DateTimeOffset: {
                    kind = EdmPrimitiveTypeKind.DateTimeOffset;
                    break;
                }
                case Decimal: {
                    kind = EdmPrimitiveTypeKind.Decimal;
                    break;
                }
                case Duration: {
                    kind = EdmPrimitiveTypeKind.Duration;
                    break;
                }
                case Float: {
                    kind = EdmPrimitiveTypeKind.Single;
                    break;
                }
                case Guid: {
                    kind = EdmPrimitiveTypeKind.Guid;
                    break;
                }
                case Int: {
                    kind = EdmPrimitiveTypeKind.Int32;
                    break;
                }
                case TimeOfDay: {
                    kind = EdmPrimitiveTypeKind.TimeOfDay;
                    break;
                }
                default: {
                    kind = EdmPrimitiveTypeKind.String;
                }
            }
            this.type = EdmPrimitiveTypeFactory.getInstance(kind);
            try {
                Object valueOfString = this.type.valueOfString(constExprConstruct.getValue(), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null, this.type.getDefaultType());
                this.value = new Property(kind.getFullQualifiedName().getFullQualifiedNameAsString(), null, ValueType.PRIMITIVE, valueOfString);
            }
            catch (EdmPrimitiveTypeException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public boolean isConstant() {
        return true;
    }

    public EdmConstantAnnotationExpression asConstant() {
        return this;
    }

    public boolean isDynamic() {
        return false;
    }

    public EdmDynamicAnnotationExpression asDynamic() {
        return null;
    }

    public Valuable getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.value == null) {
            return "";
        }
        if (this.value.isEnum()) {
            return this.value.toString();
        }
        if (this.value.isGeospatial()) {
            return this.value.toString();
        }
        try {
            return this.type.valueToString(this.value.getValue(), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

