/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Operation;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;

public class JsonEntityDeserializer
extends JsonDeserializer {
    public JsonEntityDeserializer(boolean serverMode) {
        super(serverMode);
    }

    protected ResWrap<Entity> doDeserialize(JsonParser parser) throws IOException {
        Link link;
        String metadataETag;
        URI contextURL;
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        if (tree.has("value") && tree.get("value").isArray()) {
            throw new JsonParseException("Expected OData Entity, found EntitySet", parser.getCurrentLocation());
        }
        Entity entity = new Entity();
        if (tree.hasNonNull("@odata.context")) {
            contextURL = URI.create(tree.get("@odata.context").textValue());
            tree.remove("@odata.context");
        } else if (tree.hasNonNull("odata.metadata")) {
            contextURL = URI.create(tree.get("odata.metadata").textValue());
            tree.remove("odata.metadata");
        } else {
            contextURL = null;
        }
        if (contextURL != null) {
            entity.setBaseURI(StringUtils.substringBefore((String)contextURL.toASCIIString(), (String)"$metadata"));
        }
        if (tree.hasNonNull("@odata.metadataEtag")) {
            metadataETag = tree.get("@odata.metadataEtag").textValue();
            tree.remove("@odata.metadataEtag");
        } else {
            metadataETag = null;
        }
        if (tree.hasNonNull("@odata.etag")) {
            entity.setETag(tree.get("@odata.etag").textValue());
            tree.remove("@odata.etag");
        }
        if (tree.hasNonNull("@odata.type")) {
            entity.setType(new EdmTypeInfo.Builder().setTypeExpression(tree.get("@odata.type").textValue()).build().internal());
            tree.remove("@odata.type");
        }
        if (tree.hasNonNull("@odata.id")) {
            entity.setId(URI.create(tree.get("@odata.id").textValue()));
            tree.remove("@odata.id");
        }
        if (tree.hasNonNull("@odata.readLink")) {
            link = new Link();
            link.setRel("self");
            link.setHref(tree.get("@odata.readLink").textValue());
            entity.setSelfLink(link);
            tree.remove("@odata.readLink");
        }
        if (tree.hasNonNull("@odata.editLink")) {
            link = new Link();
            if (this.serverMode) {
                link.setRel("edit");
            }
            link.setHref(tree.get("@odata.editLink").textValue());
            entity.setEditLink(link);
            tree.remove("@odata.editLink");
        }
        if (tree.hasNonNull("@odata.mediaReadLink")) {
            entity.setMediaContentSource(URI.create(tree.get("@odata.mediaReadLink").textValue()));
            tree.remove("@odata.mediaReadLink");
        }
        if (tree.hasNonNull("@odata.mediaEditLink")) {
            entity.setMediaContentSource(URI.create(tree.get("@odata.mediaEditLink").textValue()));
            tree.remove("@odata.mediaEditLink");
        }
        if (tree.hasNonNull("@odata.mediaContentType")) {
            entity.setMediaContentType(tree.get("@odata.mediaContentType").textValue());
            tree.remove("@odata.mediaContentType");
        }
        if (tree.hasNonNull("@odata.mediaEtag")) {
            entity.setMediaETag(tree.get("@odata.mediaEtag").textValue());
            tree.remove("@odata.mediaEtag");
        }
        HashSet<String> toRemove = new HashSet<String>();
        HashMap annotations = new HashMap();
        Iterator itor = tree.fields();
        while (itor.hasNext()) {
            Map.Entry field = (Map.Entry)itor.next();
            Matcher customAnnotation = this.CUSTOM_ANNOTATION.matcher((CharSequence)field.getKey());
            this.links(field, (Linked)entity, toRemove, (JsonNode)tree, parser.getCodec());
            if (((String)field.getKey()).endsWith(this.getJSONAnnotation("@odata.mediaEditLink"))) {
                Link link2 = new Link();
                link2.setTitle(this.getTitle(field));
                link2.setRel("http://docs.oasis-open.org/odata/ns/edit-media/" + this.getTitle(field));
                link2.setHref(((JsonNode)field.getValue()).textValue());
                link2.setType("*/*");
                entity.getMediaEditLinks().add(link2);
                if (tree.has(link2.getTitle() + this.getJSONAnnotation("@odata.mediaEtag"))) {
                    link2.setMediaETag(tree.get(link2.getTitle() + this.getJSONAnnotation("@odata.mediaEtag")).asText());
                    toRemove.add(link2.getTitle() + this.getJSONAnnotation("@odata.mediaEtag"));
                }
                toRemove.add((String)field.getKey());
                toRemove.add(this.setInline((String)field.getKey(), this.getJSONAnnotation("@odata.mediaEditLink"), (JsonNode)tree, parser.getCodec(), link2));
                continue;
            }
            if (((String)field.getKey()).endsWith(this.getJSONAnnotation("@odata.mediaContentType"))) {
                String linkTitle = this.getTitle(field);
                for (Link link3 : entity.getMediaEditLinks()) {
                    if (!linkTitle.equals(link3.getTitle())) continue;
                    link3.setType(((JsonNode)field.getValue()).asText());
                }
                toRemove.add((String)field.getKey());
                continue;
            }
            if (((String)field.getKey()).charAt(0) == '#') {
                Operation operation = new Operation();
                operation.setMetadataAnchor((String)field.getKey());
                ObjectNode opNode = (ObjectNode)tree.get((String)field.getKey());
                operation.setTitle(opNode.get("title").asText());
                operation.setTarget(URI.create(opNode.get("target").asText()));
                entity.getOperations().add(operation);
                toRemove.add((String)field.getKey());
                continue;
            }
            if (!customAnnotation.matches() || "odata".equals(customAnnotation.group(2))) continue;
            Annotation annotation = new Annotation();
            annotation.setTerm(customAnnotation.group(2) + "." + customAnnotation.group(3));
            try {
                this.value((Valuable)annotation, (JsonNode)field.getValue(), parser.getCodec());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new IOException(e);
            }
            if (!annotations.containsKey(customAnnotation.group(1))) {
                annotations.put(customAnnotation.group(1), new ArrayList());
            }
            ((List)annotations.get(customAnnotation.group(1))).add(annotation);
        }
        for (Link link4 : entity.getNavigationLinks()) {
            if (!annotations.containsKey(link4.getTitle())) continue;
            link4.getAnnotations().addAll((Collection)annotations.get(link4.getTitle()));
            for (Annotation annotation : (List)annotations.get(link4.getTitle())) {
                toRemove.add(link4.getTitle() + "@" + annotation.getTerm());
            }
        }
        for (Link link4 : entity.getMediaEditLinks()) {
            if (!annotations.containsKey(link4.getTitle())) continue;
            link4.getAnnotations().addAll((Collection)annotations.get(link4.getTitle()));
            for (Annotation annotation : (List)annotations.get(link4.getTitle())) {
                toRemove.add(link4.getTitle() + "@" + annotation.getTerm());
            }
        }
        tree.remove(toRemove);
        try {
            this.populate((Annotatable)entity, entity.getProperties(), tree, parser.getCodec());
        }
        catch (EdmPrimitiveTypeException e) {
            throw new IOException(e);
        }
        return new ResWrap(contextURL, metadataETag, (Object)entity);
    }
}

