/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlStructuralType;
import org.apache.olingo.commons.core.edm.EdmNavigationPropertyImpl;
import org.apache.olingo.commons.core.edm.EdmPropertyImpl;
import org.apache.olingo.commons.core.edm.EdmTypeImpl;

public abstract class AbstractEdmStructuredType
extends EdmTypeImpl
implements EdmStructuredType {
    protected EdmStructuredType baseType;
    protected FullQualifiedName baseTypeName;
    private final CsdlStructuralType providerStructuredType;
    private List<String> propertyNames;
    private Map<String, EdmProperty> properties;
    private List<String> navigationPropertyNames;
    private Map<String, EdmNavigationProperty> navigationProperties;

    public AbstractEdmStructuredType(Edm edm, FullQualifiedName typeName, EdmTypeKind kind, CsdlStructuralType structuredType) {
        super(edm, typeName, kind, (CsdlAnnotatable)structuredType);
        this.baseTypeName = structuredType.getBaseTypeFQN();
        this.providerStructuredType = structuredType;
    }

    protected abstract EdmStructuredType buildBaseType(FullQualifiedName var1);

    protected abstract void checkBaseType();

    public List<String> getPropertyNames() {
        if (this.propertyNames == null) {
            ArrayList<String> localPropertyNames = new ArrayList<String>();
            this.checkBaseType();
            if (this.baseType != null) {
                localPropertyNames.addAll(this.baseType.getPropertyNames());
            }
            localPropertyNames.addAll(this.getProperties().keySet());
            this.propertyNames = Collections.unmodifiableList(localPropertyNames);
        }
        return this.propertyNames;
    }

    public List<String> getNavigationPropertyNames() {
        if (this.navigationPropertyNames == null) {
            ArrayList<String> localNavigatinPropertyNames = new ArrayList<String>();
            this.checkBaseType();
            if (this.baseType != null) {
                localNavigatinPropertyNames.addAll(this.baseType.getNavigationPropertyNames());
            }
            localNavigatinPropertyNames.addAll(this.getNavigationProperties().keySet());
            this.navigationPropertyNames = Collections.unmodifiableList(localNavigatinPropertyNames);
        }
        return this.navigationPropertyNames;
    }

    public EdmElement getProperty(String name) {
        EdmProperty property = this.getStructuralProperty(name);
        if (property == null) {
            property = this.getNavigationProperty(name);
        }
        return property;
    }

    public EdmProperty getStructuralProperty(String name) {
        EdmProperty property = null;
        this.checkBaseType();
        if (this.baseType != null) {
            property = this.baseType.getStructuralProperty(name);
        }
        if (property == null) {
            property = this.getProperties().get(name);
        }
        return property;
    }

    public EdmNavigationProperty getNavigationProperty(String name) {
        EdmNavigationProperty property = null;
        this.checkBaseType();
        if (this.baseType != null) {
            property = this.baseType.getNavigationProperty(name);
        }
        if (property == null) {
            property = this.getNavigationProperties().get(name);
        }
        return property;
    }

    public boolean compatibleTo(EdmType targetType) {
        AbstractEdmStructuredType sourceType = this;
        if (targetType == null) {
            throw new EdmException("Target type must not be null");
        }
        while (!sourceType.getName().equals(targetType.getName()) || !sourceType.getNamespace().equals(targetType.getNamespace())) {
            if ((sourceType = sourceType.getBaseType()) != null) continue;
            return false;
        }
        return true;
    }

    public String getAnnotationsTargetPath() {
        return null;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.getFullQualifiedName();
    }

    public Map<String, EdmProperty> getProperties() {
        if (this.properties == null) {
            LinkedHashMap<String, EdmPropertyImpl> localPorperties = new LinkedHashMap<String, EdmPropertyImpl>();
            List structureTypeProperties = this.providerStructuredType.getProperties();
            for (CsdlProperty property : structureTypeProperties) {
                localPorperties.put(property.getName(), new EdmPropertyImpl(this.edm, this.typeName, property));
            }
            this.properties = Collections.unmodifiableMap(localPorperties);
        }
        return this.properties;
    }

    public Map<String, EdmNavigationProperty> getNavigationProperties() {
        if (this.navigationProperties == null) {
            LinkedHashMap<String, EdmNavigationPropertyImpl> localNavigationProperties = new LinkedHashMap<String, EdmNavigationPropertyImpl>();
            List structuredTypeNavigationProperties = this.providerStructuredType.getNavigationProperties();
            if (structuredTypeNavigationProperties != null) {
                for (CsdlNavigationProperty navigationProperty : structuredTypeNavigationProperties) {
                    localNavigationProperties.put(navigationProperty.getName(), new EdmNavigationPropertyImpl(this.edm, this.typeName, navigationProperty));
                }
            }
            this.navigationProperties = Collections.unmodifiableMap(localNavigationProperties);
        }
        return this.navigationProperties;
    }

    public boolean isOpenType() {
        return this.providerStructuredType.isOpenType();
    }

    public boolean isAbstract() {
        return this.providerStructuredType.isAbstract();
    }
}

