/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmActionImportImpl;
import org.apache.olingo.commons.core.edm.EdmEntitySetImpl;
import org.apache.olingo.commons.core.edm.EdmFunctionImportImpl;
import org.apache.olingo.commons.core.edm.EdmSingletonImpl;

public class EdmEntityContainerImpl
extends AbstractEdmNamed
implements EdmEntityContainer {
    private final CsdlEdmProvider provider;
    private CsdlEntityContainer container;
    private final FullQualifiedName entityContainerName;
    private final FullQualifiedName parentContainerName;
    private List<EdmSingleton> singletons;
    private final Map<String, EdmSingleton> singletonCache = Collections.synchronizedMap(new LinkedHashMap());
    private List<EdmEntitySet> entitySets;
    private final Map<String, EdmEntitySet> entitySetCache = Collections.synchronizedMap(new LinkedHashMap());
    private List<EdmActionImport> actionImports;
    private final Map<String, EdmActionImport> actionImportCache = Collections.synchronizedMap(new LinkedHashMap());
    private List<EdmFunctionImport> functionImports;
    private final Map<String, EdmFunctionImport> functionImportCache = Collections.synchronizedMap(new LinkedHashMap());

    public EdmEntityContainerImpl(Edm edm, CsdlEdmProvider provider, CsdlEntityContainerInfo entityContainerInfo) {
        super(edm, entityContainerInfo.getContainerName().getName(), null);
        this.provider = provider;
        this.entityContainerName = entityContainerInfo.getContainerName();
        this.parentContainerName = entityContainerInfo.getExtendsContainer();
    }

    public EdmEntityContainerImpl(Edm edm, CsdlEdmProvider provider, FullQualifiedName containerFQN, CsdlEntityContainer entityContainer) {
        super(edm, containerFQN.getName(), (CsdlAnnotatable)entityContainer);
        this.provider = provider;
        this.container = entityContainer;
        this.entityContainerName = containerFQN;
        this.parentContainerName = entityContainer.getExtendsContainerFQN();
    }

    public String getNamespace() {
        return this.entityContainerName.getNamespace();
    }

    public FullQualifiedName getFullQualifiedName() {
        return this.entityContainerName;
    }

    public EdmSingleton getSingleton(String singletonName) {
        EdmSingleton singleton = this.singletonCache.get(singletonName);
        if (singleton == null && (singleton = this.createSingleton(singletonName)) != null) {
            this.singletonCache.put(singletonName, singleton);
        }
        return singleton;
    }

    public EdmEntitySet getEntitySet(String entitySetName) {
        EdmEntitySet entitySet = this.entitySetCache.get(entitySetName);
        if (entitySet == null && (entitySet = this.createEntitySet(entitySetName)) != null) {
            this.entitySetCache.put(entitySetName, entitySet);
        }
        return entitySet;
    }

    public EdmActionImport getActionImport(String actionImportName) {
        EdmActionImport actionImport = this.actionImportCache.get(actionImportName);
        if (actionImport == null && (actionImport = this.createActionImport(actionImportName)) != null) {
            this.actionImportCache.put(actionImportName, actionImport);
        }
        return actionImport;
    }

    public EdmFunctionImport getFunctionImport(String functionImportName) {
        EdmFunctionImport functionImport = this.functionImportCache.get(functionImportName);
        if (functionImport == null && (functionImport = this.createFunctionImport(functionImportName)) != null) {
            this.functionImportCache.put(functionImportName, functionImport);
        }
        return functionImport;
    }

    public List<EdmEntitySet> getEntitySets() {
        if (this.entitySets == null) {
            this.loadAllEntitySets();
        }
        return Collections.unmodifiableList(this.entitySets);
    }

    public List<EdmFunctionImport> getFunctionImports() {
        if (this.functionImports == null) {
            this.loadAllFunctionImports();
        }
        return Collections.unmodifiableList(this.functionImports);
    }

    public List<EdmSingleton> getSingletons() {
        if (this.singletons == null) {
            this.loadAllSingletons();
        }
        return Collections.unmodifiableList(this.singletons);
    }

    public List<EdmActionImport> getActionImports() {
        if (this.actionImports == null) {
            this.loadAllActionImports();
        }
        return Collections.unmodifiableList(this.actionImports);
    }

    public FullQualifiedName getParentContainerName() {
        return this.parentContainerName;
    }

    protected EdmSingleton createSingleton(String singletonName) {
        EdmSingletonImpl singleton = null;
        try {
            CsdlSingleton providerSingleton = this.provider.getSingleton(this.entityContainerName, singletonName);
            if (providerSingleton != null) {
                singleton = new EdmSingletonImpl(this.edm, (EdmEntityContainer)this, providerSingleton);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return singleton;
    }

    protected EdmEntitySet createEntitySet(String entitySetName) {
        EdmEntitySetImpl entitySet = null;
        try {
            CsdlEntitySet providerEntitySet = this.provider.getEntitySet(this.entityContainerName, entitySetName);
            if (providerEntitySet != null) {
                entitySet = new EdmEntitySetImpl(this.edm, (EdmEntityContainer)this, providerEntitySet);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return entitySet;
    }

    protected EdmActionImport createActionImport(String actionImportName) {
        EdmActionImportImpl actionImport = null;
        try {
            CsdlActionImport providerImport = this.provider.getActionImport(this.entityContainerName, actionImportName);
            if (providerImport != null) {
                actionImport = new EdmActionImportImpl(this.edm, (EdmEntityContainer)this, providerImport);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return actionImport;
    }

    protected EdmFunctionImport createFunctionImport(String functionImportName) {
        EdmFunctionImportImpl functionImport = null;
        try {
            CsdlFunctionImport providerImport = this.provider.getFunctionImport(this.entityContainerName, functionImportName);
            if (providerImport != null) {
                functionImport = new EdmFunctionImportImpl(this.edm, (EdmEntityContainer)this, providerImport);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return functionImport;
    }

    protected void loadAllEntitySets() {
        this.loadContainer();
        List providerEntitySets = this.container.getEntitySets();
        ArrayList<EdmEntitySet> entitySetsLocal = new ArrayList<EdmEntitySet>();
        if (providerEntitySets != null) {
            for (CsdlEntitySet entitySet : providerEntitySets) {
                EdmEntitySetImpl impl = new EdmEntitySetImpl(this.edm, (EdmEntityContainer)this, entitySet);
                this.entitySetCache.put(impl.getName(), impl);
                entitySetsLocal.add(impl);
            }
            this.entitySets = entitySetsLocal;
        }
    }

    protected void loadAllFunctionImports() {
        this.loadContainer();
        List providerFunctionImports = this.container.getFunctionImports();
        ArrayList<EdmFunctionImport> functionImportsLocal = new ArrayList<EdmFunctionImport>();
        if (providerFunctionImports != null) {
            for (CsdlFunctionImport functionImport : providerFunctionImports) {
                EdmFunctionImportImpl impl = new EdmFunctionImportImpl(this.edm, (EdmEntityContainer)this, functionImport);
                this.functionImportCache.put(impl.getName(), impl);
                functionImportsLocal.add(impl);
            }
            this.functionImports = functionImportsLocal;
        }
    }

    protected void loadAllSingletons() {
        this.loadContainer();
        List providerSingletons = this.container.getSingletons();
        ArrayList<EdmSingleton> singletonsLocal = new ArrayList<EdmSingleton>();
        if (providerSingletons != null) {
            for (CsdlSingleton singleton : providerSingletons) {
                EdmSingletonImpl impl = new EdmSingletonImpl(this.edm, (EdmEntityContainer)this, singleton);
                this.singletonCache.put(singleton.getName(), impl);
                singletonsLocal.add(impl);
            }
            this.singletons = singletonsLocal;
        }
    }

    protected void loadAllActionImports() {
        this.loadContainer();
        List providerActionImports = this.container.getActionImports();
        ArrayList<EdmActionImport> actionImportsLocal = new ArrayList<EdmActionImport>();
        if (providerActionImports != null) {
            for (CsdlActionImport actionImport : providerActionImports) {
                EdmActionImportImpl impl = new EdmActionImportImpl(this.edm, (EdmEntityContainer)this, actionImport);
                this.actionImportCache.put(actionImport.getName(), impl);
                actionImportsLocal.add(impl);
            }
            this.actionImports = actionImportsLocal;
        }
    }

    private void loadContainer() {
        if (this.container == null) {
            try {
                CsdlEntityContainer containerLocal = this.provider.getEntityContainer();
                if (containerLocal == null) {
                    containerLocal = new CsdlEntityContainer().setName(this.getName());
                }
                this.container = containerLocal;
            }
            catch (ODataException e) {
                throw new EdmException((Exception)((Object)e));
            }
        }
    }

    public String getAnnotationsTargetPath() {
        return null;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.getFullQualifiedName();
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.EntityContainer;
    }
}

