/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmPropertyImpl
extends AbstractEdmNamed
implements EdmProperty,
EdmElement {
    private final FullQualifiedName structuredTypeName;
    private final CsdlProperty property;
    private final EdmTypeInfo typeInfo;
    private EdmType propertyType;

    public EdmPropertyImpl(Edm edm, FullQualifiedName structuredTypeName, CsdlProperty property) {
        super(edm, property.getName(), (CsdlAnnotatable)property);
        this.structuredTypeName = structuredTypeName;
        this.property = property;
        this.typeInfo = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(property.getType().toString()).build();
    }

    public EdmType getType() {
        if (this.propertyType == null) {
            this.propertyType = this.typeInfo.getType();
            if (this.propertyType == null) {
                throw new EdmException("Cannot find type with name: " + this.typeInfo.getFullQualifiedName());
            }
        }
        return this.propertyType;
    }

    public boolean isCollection() {
        return this.property.isCollection();
    }

    public EdmMapping getMapping() {
        return this.property.getMapping();
    }

    public String getMimeType() {
        return this.property.getMimeType();
    }

    public boolean isNullable() {
        return this.property.isNullable();
    }

    public Integer getMaxLength() {
        return this.property.getMaxLength();
    }

    public Integer getPrecision() {
        return this.property.getPrecision();
    }

    public Integer getScale() {
        return this.property.getScale();
    }

    public SRID getSrid() {
        return this.property.getSrid();
    }

    public boolean isUnicode() {
        return this.property.isUnicode();
    }

    public String getDefaultValue() {
        return this.property.getDefaultValue();
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.Property;
    }

    public String getAnnotationsTargetPath() {
        return this.getName();
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.structuredTypeName;
    }

    public boolean isPrimitive() {
        return this.typeInfo.isPrimitiveType();
    }
}

