/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmReturnTypeImpl
implements EdmReturnType {
    private final CsdlReturnType returnType;
    private final EdmTypeInfo typeInfo;
    private EdmType typeImpl;

    public EdmReturnTypeImpl(Edm edm, CsdlReturnType returnType) {
        this.returnType = returnType;
        this.typeInfo = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(returnType.getType()).build();
    }

    public boolean isCollection() {
        return this.returnType.isCollection();
    }

    public boolean isNullable() {
        return this.returnType.isNullable();
    }

    public Integer getMaxLength() {
        return this.returnType.getMaxLength();
    }

    public Integer getPrecision() {
        return this.returnType.getPrecision();
    }

    public Integer getScale() {
        return this.returnType.getScale();
    }

    public SRID getSrid() {
        return this.returnType.getSrid();
    }

    public EdmType getType() {
        if (this.typeImpl == null) {
            this.typeImpl = this.typeInfo.getType();
            if (this.typeImpl == null) {
                throw new EdmException("Cannot find type with name: " + this.typeInfo.getFullQualifiedName());
            }
        }
        return this.typeImpl;
    }
}

