/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;

public class EdmTypeInfo {
    private final boolean collection;
    private final FullQualifiedName fullQualifiedName;
    private EdmPrimitiveTypeKind primitiveType;
    private EdmTypeDefinition typeDefinition;
    private EdmEnumType enumType;
    private EdmComplexType complexType;
    private EdmEntityType entityType;

    private EdmTypeInfo(Edm edm, String typeExpression) {
        String typeName;
        String namespace;
        String baseType;
        int collStartIdx = typeExpression.indexOf("Collection(");
        int collEndIdx = typeExpression.lastIndexOf(41);
        if (collStartIdx == -1) {
            baseType = typeExpression;
            this.collection = false;
        } else {
            if (collEndIdx == -1) {
                throw new IllegalArgumentException("Malformed type: " + typeExpression);
            }
            this.collection = true;
            baseType = typeExpression.substring(collStartIdx + 11, collEndIdx);
        }
        baseType = baseType.replaceAll("^#", "");
        int lastDotIdx = baseType.lastIndexOf(46);
        if (lastDotIdx == -1) {
            namespace = "Edm";
            typeName = baseType;
        } else {
            namespace = baseType.substring(0, lastDotIdx);
            typeName = baseType.substring(lastDotIdx + 1);
        }
        if (typeName == null || typeName.isEmpty()) {
            throw new IllegalArgumentException("Null or empty type name in " + typeExpression);
        }
        this.fullQualifiedName = new FullQualifiedName(namespace, typeName);
        try {
            this.primitiveType = EdmPrimitiveTypeKind.valueOf((String)this.fullQualifiedName.getName());
        }
        catch (IllegalArgumentException e) {
            this.primitiveType = null;
        }
        if (this.primitiveType == null && edm != null) {
            this.typeDefinition = edm.getTypeDefinition(this.fullQualifiedName);
            if (this.typeDefinition == null) {
                this.enumType = edm.getEnumType(this.fullQualifiedName);
                if (this.enumType == null) {
                    this.complexType = edm.getComplexType(this.fullQualifiedName);
                    if (this.complexType == null) {
                        this.entityType = edm.getEntityType(this.fullQualifiedName);
                    }
                }
            }
        }
    }

    public String internal() {
        StringBuilder deserialize = new StringBuilder();
        if (this.isCollection()) {
            deserialize.append("Collection(");
        }
        deserialize.append(this.getFullQualifiedName().toString());
        if (this.isCollection()) {
            deserialize.append(")");
        }
        return deserialize.toString();
    }

    public String external() {
        StringBuilder serialize = new StringBuilder();
        if (this.isCollection()) {
            serialize.append('#');
            serialize.append("Collection(");
        }
        if (this.isPrimitiveType()) {
            serialize.append(this.getFullQualifiedName().getName());
        } else {
            serialize.append(this.getFullQualifiedName().toString());
        }
        if (this.isCollection()) {
            serialize.append(")");
        }
        if (!this.isPrimitiveType() && !this.isCollection()) {
            serialize.insert(0, '#');
        }
        return serialize.toString();
    }

    public boolean isCollection() {
        return this.collection;
    }

    public FullQualifiedName getFullQualifiedName() {
        return this.fullQualifiedName;
    }

    public boolean isPrimitiveType() {
        return this.primitiveType != null;
    }

    public EdmPrimitiveTypeKind getPrimitiveTypeKind() {
        return this.primitiveType;
    }

    public boolean isTypeDefinition() {
        return this.typeDefinition != null;
    }

    public EdmTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isEnumType() {
        return this.enumType != null;
    }

    public EdmEnumType getEnumType() {
        return this.enumType;
    }

    public boolean isComplexType() {
        return this.complexType != null;
    }

    public EdmComplexType getComplexType() {
        return this.complexType;
    }

    public boolean isEntityType() {
        return this.entityType != null;
    }

    public EdmEntityType getEntityType() {
        return this.entityType;
    }

    public EdmType getType() {
        return this.isPrimitiveType() ? EdmPrimitiveTypeFactory.getInstance(this.getPrimitiveTypeKind()) : (this.isTypeDefinition() ? this.getTypeDefinition() : (this.isEnumType() ? this.getEnumType() : (this.isComplexType() ? this.getComplexType() : (this.isEntityType() ? this.getEntityType() : null))));
    }

    public static class Builder {
        private String typeExpression;
        private String defaultNamespace;
        private Edm edm;

        public Builder setTypeExpression(String typeExpression) {
            this.typeExpression = typeExpression;
            return this;
        }

        public Builder setDefaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
            return this;
        }

        public Builder setEdm(Edm edm) {
            this.edm = edm;
            return this;
        }

        public EdmTypeInfo build() {
            return new EdmTypeInfo(this.edm, this.typeExpression.indexOf(46) == -1 && this.defaultNamespace != null && !this.defaultNamespace.isEmpty() ? this.defaultNamespace + "." + this.typeExpression : this.typeExpression);
        }
    }
}

