/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmPropertyValue;
import org.apache.olingo.commons.api.edm.annotation.EdmRecord;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlPropertyValue;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlRecord;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmAnnotatableDynamicExpression;
import org.apache.olingo.commons.core.edm.annotation.EdmPropertyValueImpl;

public class EdmRecordImpl
extends AbstractEdmAnnotatableDynamicExpression
implements EdmRecord {
    private List<EdmPropertyValue> propertyValues;
    private EdmStructuredType type;
    private CsdlRecord record;

    public EdmRecordImpl(Edm edm, CsdlRecord csdlExp) {
        super(edm, "Record", (CsdlAnnotatable)csdlExp);
        this.record = csdlExp;
    }

    public List<EdmPropertyValue> getPropertyValues() {
        if (this.propertyValues == null) {
            ArrayList<EdmPropertyValueImpl> localValues = new ArrayList<EdmPropertyValueImpl>();
            if (this.record.getPropertyValues() != null) {
                for (CsdlPropertyValue value : this.record.getPropertyValues()) {
                    localValues.add(new EdmPropertyValueImpl(this.edm, value));
                }
            }
            this.propertyValues = Collections.unmodifiableList(localValues);
        }
        return this.propertyValues;
    }

    public EdmStructuredType getType() {
        if (this.type == null && this.record.getType() != null) {
            EdmTypeInfo typeInfo = new EdmTypeInfo.Builder().setEdm(this.edm).setTypeExpression(this.record.getType()).build();
            if (typeInfo.isEntityType() || typeInfo.isComplexType()) {
                this.type = typeInfo.isEntityType() ? typeInfo.getEntityType() : typeInfo.getComplexType();
            } else {
                throw new EdmException("Record expressions must specify a complex or entity type.");
            }
        }
        return this.type;
    }

    public EdmExpression.EdmExpressionType getExpressionType() {
        return EdmExpression.EdmExpressionType.Record;
    }
}

