/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.EdmActionImportImpl;
import org.apache.olingo.commons.core.edm.EdmEntitySetImpl;
import org.apache.olingo.commons.core.edm.EdmFunctionImportImpl;
import org.apache.olingo.commons.core.edm.EdmProviderImpl;
import org.apache.olingo.commons.core.edm.EdmSingletonImpl;

public class EdmEntityContainerImpl
extends AbstractEdmNamed
implements EdmEntityContainer {
    private final CsdlEdmProvider provider;
    private CsdlEntityContainer container;
    private final FullQualifiedName entityContainerName;
    private final FullQualifiedName parentContainerName;
    private List<EdmSingleton> singletons;
    private final Map<String, EdmSingleton> singletonCache = Collections.synchronizedMap(new LinkedHashMap());
    private List<EdmEntitySet> entitySets;
    private final Map<String, EdmEntitySet> entitySetCache = Collections.synchronizedMap(new LinkedHashMap());
    private List<EdmActionImport> actionImports;
    private final Map<String, EdmActionImport> actionImportCache = Collections.synchronizedMap(new LinkedHashMap());
    private List<EdmFunctionImport> functionImports;
    private final Map<String, EdmFunctionImport> functionImportCache = Collections.synchronizedMap(new LinkedHashMap());
    private boolean isAnnotationsIncluded = false;
    private final Map<String, EdmEntitySet> entitySetWithAnnotationsCache = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, EdmSingleton> singletonWithAnnotationsCache = Collections.synchronizedMap(new LinkedHashMap());
    private boolean isSingletonAnnotationsIncluded = false;

    public EdmEntityContainerImpl(Edm edm, CsdlEdmProvider provider, CsdlEntityContainerInfo entityContainerInfo) {
        super(edm, entityContainerInfo.getContainerName().getName(), null);
        this.provider = provider;
        this.entityContainerName = entityContainerInfo.getContainerName();
        this.parentContainerName = entityContainerInfo.getExtendsContainer();
    }

    public EdmEntityContainerImpl(Edm edm, CsdlEdmProvider provider, FullQualifiedName containerFQN, CsdlEntityContainer entityContainer) {
        super(edm, containerFQN.getName(), (CsdlAnnotatable)entityContainer);
        this.provider = provider;
        this.container = entityContainer;
        this.entityContainerName = containerFQN;
        this.parentContainerName = entityContainer == null ? null : entityContainer.getExtendsContainerFQN();
    }

    public String getNamespace() {
        return this.entityContainerName.getNamespace();
    }

    public FullQualifiedName getFullQualifiedName() {
        return this.entityContainerName;
    }

    public EdmSingleton getSingleton(String singletonName) {
        EdmSingleton singleton = this.singletonWithAnnotationsCache.get(singletonName);
        if (singleton == null && (singleton = this.singletonCache.get(singletonName)) == null && (singleton = this.createSingleton(singletonName)) != null) {
            if (this.isSingletonAnnotationsIncluded) {
                this.singletonWithAnnotationsCache.put(singletonName, singleton);
            } else {
                this.singletonCache.put(singletonName, singleton);
            }
        }
        return singleton;
    }

    public EdmEntitySet getEntitySet(String entitySetName) {
        EdmEntitySet entitySet = this.entitySetWithAnnotationsCache.get(entitySetName);
        if (entitySet == null && (entitySet = this.entitySetCache.get(entitySetName)) == null && (entitySet = this.createEntitySet(entitySetName)) != null) {
            if (this.isAnnotationsIncluded) {
                this.entitySetWithAnnotationsCache.put(entitySetName, entitySet);
            } else {
                this.entitySetCache.put(entitySetName, entitySet);
            }
        }
        ((EdmProviderImpl)this.edm).setIsPreviousES(true);
        return entitySet;
    }

    public EdmActionImport getActionImport(String actionImportName) {
        EdmActionImport actionImport = this.actionImportCache.get(actionImportName);
        if (actionImport == null && (actionImport = this.createActionImport(actionImportName)) != null) {
            this.actionImportCache.put(actionImportName, actionImport);
        }
        return actionImport;
    }

    public EdmFunctionImport getFunctionImport(String functionImportName) {
        EdmFunctionImport functionImport = this.functionImportCache.get(functionImportName);
        if (functionImport == null && (functionImport = this.createFunctionImport(functionImportName)) != null) {
            this.functionImportCache.put(functionImportName, functionImport);
        }
        return functionImport;
    }

    public List<EdmEntitySet> getEntitySets() {
        if (this.entitySets == null) {
            this.loadAllEntitySets();
        }
        return Collections.unmodifiableList(this.entitySets);
    }

    public List<EdmEntitySet> getEntitySetsWithAnnotations() {
        this.loadAllEntitySets();
        return Collections.unmodifiableList(this.entitySets);
    }

    public List<EdmFunctionImport> getFunctionImports() {
        if (this.functionImports == null) {
            this.loadAllFunctionImports();
        }
        return Collections.unmodifiableList(this.functionImports);
    }

    public List<EdmSingleton> getSingletons() {
        if (this.singletons == null) {
            this.loadAllSingletons();
        }
        return Collections.unmodifiableList(this.singletons);
    }

    public List<EdmActionImport> getActionImports() {
        if (this.actionImports == null) {
            this.loadAllActionImports();
        }
        return Collections.unmodifiableList(this.actionImports);
    }

    public FullQualifiedName getParentContainerName() {
        return this.parentContainerName;
    }

    protected EdmSingleton createSingleton(String singletonName) {
        EdmSingletonImpl singleton = null;
        try {
            CsdlSingleton providerSingleton = this.provider.getSingleton(this.entityContainerName, singletonName);
            if (providerSingleton != null) {
                this.addAnnotations(providerSingleton, this.entityContainerName);
                singleton = new EdmSingletonImpl(this.edm, (EdmEntityContainer)this, providerSingleton);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return singleton;
    }

    private void addAnnotations(CsdlSingleton singleton, FullQualifiedName entityContainerName) {
        boolean isPropAnnotationsCleared = false;
        boolean isNavPropAnnotationsCleared = false;
        CsdlEntityType entityType = this.fetchEntityTypeFromSingleton(singleton);
        if (entityType == null) {
            return;
        }
        List<CsdlSchema> termSchemaDefinition = ((EdmProviderImpl)this.edm).getTermSchemaDefinitions();
        for (CsdlSchema schema : termSchemaDefinition) {
            List annotationGrps = schema.getAnnotationGroups();
            for (CsdlAnnotations annotationGrp : annotationGrps) {
                if (annotationGrp.getTarget().equalsIgnoreCase(entityContainerName + "/" + singleton.getName())) {
                    this.isSingletonAnnotationsIncluded = true;
                    this.addAnnotationsToSingleton(singleton, annotationGrp);
                    continue;
                }
                this.addAnnotationsToPropertiesDerivedFromSingleton(singleton, isPropAnnotationsCleared, isNavPropAnnotationsCleared, entityType, annotationGrp);
                isPropAnnotationsCleared = true;
                isNavPropAnnotationsCleared = true;
            }
        }
    }

    private void addAnnotationsToPropertiesDerivedFromSingleton(CsdlSingleton singleton, boolean isPropAnnotationsCleared, boolean isNavPropAnnotationsCleared, CsdlEntityType entityType, CsdlAnnotations annotationGrp) {
        for (CsdlProperty propertyName : entityType.getProperties()) {
            if (!isPropAnnotationsCleared) {
                entityType.getProperty(propertyName.getName()).getAnnotations().clear();
            }
            if (!this.isPropertyComplex(propertyName)) continue;
            CsdlComplexType complexType = this.getComplexTypeFromProperty(propertyName);
            this.addAnnotationsToComplexTypeIncludedFromSingleton(singleton, annotationGrp, propertyName, isNavPropAnnotationsCleared, complexType);
        }
    }

    private void addAnnotationsToSingleton(CsdlSingleton singleton, CsdlAnnotations annotationGrp) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(singleton.getAnnotations(), annotation)) continue;
            singleton.getAnnotations().add(annotation);
        }
    }

    private CsdlEntityType fetchEntityTypeFromSingleton(CsdlSingleton singleton) {
        CsdlEntityType entityType;
        try {
            entityType = singleton.getTypeFQN() != null ? this.provider.getEntityType(new FullQualifiedName(singleton.getTypeFQN().getFullQualifiedNameAsString())) : null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return entityType;
    }

    private void addAnnotationsToComplexTypeIncludedFromSingleton(CsdlSingleton singleton, CsdlAnnotations annotationGrp, CsdlProperty propertyName, boolean isComplexNavPropAnnotationsCleared, CsdlComplexType complexType) {
        for (CsdlNavigationProperty complexNavPropertyName : complexType.getNavigationProperties()) {
            if (!isComplexNavPropAnnotationsCleared) {
                complexType.getNavigationProperty(complexNavPropertyName.getName()).getAnnotations().clear();
            }
            if (!annotationGrp.getTarget().equalsIgnoreCase(this.entityContainerName + "/" + singleton.getName() + "/" + propertyName.getName() + "/" + complexNavPropertyName.getName())) continue;
            this.isSingletonAnnotationsIncluded = true;
            this.addAnnotationsToComplexTypeNavProperties(annotationGrp, complexType, complexNavPropertyName);
        }
    }

    protected EdmEntitySet createEntitySet(String entitySetName) {
        EdmEntitySetImpl entitySet = null;
        try {
            CsdlEntitySet providerEntitySet = this.provider.getEntitySet(this.entityContainerName, entitySetName);
            if (providerEntitySet != null) {
                this.addAnnotations(providerEntitySet, this.entityContainerName);
                entitySet = new EdmEntitySetImpl(this.edm, (EdmEntityContainer)this, providerEntitySet);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return entitySet;
    }

    private void addAnnotations(CsdlEntitySet entitySet, FullQualifiedName entityContainerName) {
        boolean isPropAnnotationsCleared = false;
        boolean isNavPropAnnotationsCleared = false;
        CsdlEntityType entityType = this.getCsdlEntityTypeFromEntitySet(entitySet);
        if (entityType == null) {
            return;
        }
        List<CsdlSchema> termSchemaDefinition = ((EdmProviderImpl)this.edm).getTermSchemaDefinitions();
        for (CsdlSchema schema : termSchemaDefinition) {
            List annotationGrps = schema.getAnnotationGroups();
            for (CsdlAnnotations annotationGrp : annotationGrps) {
                if (annotationGrp.getTarget().equalsIgnoreCase(entityContainerName + "/" + entitySet.getName())) {
                    this.isAnnotationsIncluded = true;
                    this.addAnnotationsToEntitySet(entitySet, annotationGrp);
                    continue;
                }
                this.addAnnotationsToEntityTypeIncludedFromES(entitySet, entityContainerName, annotationGrp, isPropAnnotationsCleared, isNavPropAnnotationsCleared, entityType);
                isPropAnnotationsCleared = true;
                isNavPropAnnotationsCleared = true;
            }
        }
    }

    private void addAnnotationsToEntitySet(CsdlEntitySet entitySet, CsdlAnnotations annotationGrp) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(entitySet.getAnnotations(), annotation)) continue;
            entitySet.getAnnotations().add(annotation);
        }
    }

    private CsdlEntityType getCsdlEntityTypeFromEntitySet(CsdlEntitySet entitySet) {
        CsdlEntityType entityType;
        try {
            entityType = entitySet.getTypeFQN() != null ? this.provider.getEntityType(new FullQualifiedName(entitySet.getTypeFQN().getFullQualifiedNameAsString())) : null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return entityType;
    }

    private void addAnnotationsToEntityTypeIncludedFromES(CsdlEntitySet entitySet, FullQualifiedName entityContainerName, CsdlAnnotations annotationGrp, boolean isPropAnnotationsCleared, boolean isNavPropAnnotationsCleared, CsdlEntityType entityType) {
        for (CsdlProperty propertyName : entityType.getProperties()) {
            if (!isPropAnnotationsCleared) {
                entityType.getProperty(propertyName.getName()).getAnnotations().clear();
            }
            if (this.isPropertyComplex(propertyName)) {
                CsdlComplexType complexType = this.getComplexTypeFromProperty(propertyName);
                this.addAnnotationsToComplexTypeIncludedFromES(entitySet, entityContainerName, annotationGrp, propertyName, isPropAnnotationsCleared, isNavPropAnnotationsCleared, complexType);
                continue;
            }
            if (!annotationGrp.getTarget().equalsIgnoreCase(entityContainerName + "/" + entitySet.getName() + "/" + propertyName.getName())) continue;
            this.isAnnotationsIncluded = true;
            this.addAnnotationsToEntityTypeProperties(annotationGrp, entityType, propertyName);
        }
        for (CsdlNavigationProperty navPropertyName : entityType.getNavigationProperties()) {
            if (!isNavPropAnnotationsCleared) {
                entityType.getNavigationProperty(navPropertyName.getName()).getAnnotations().clear();
            }
            if (!annotationGrp.getTarget().equalsIgnoreCase(entityContainerName + "/" + entitySet.getName() + "/" + navPropertyName.getName())) continue;
            this.isAnnotationsIncluded = true;
            this.addAnnotationsToEntityTypeNavProperties(annotationGrp, entityType, navPropertyName);
        }
    }

    private void addAnnotationsToEntityTypeNavProperties(CsdlAnnotations annotationGrp, CsdlEntityType entityType, CsdlNavigationProperty navPropertyName) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(entityType.getNavigationProperty(navPropertyName.getName()).getAnnotations(), annotation)) continue;
            entityType.getNavigationProperty(navPropertyName.getName()).getAnnotations().add(annotation);
        }
    }

    private void addAnnotationsToEntityTypeProperties(CsdlAnnotations annotationGrp, CsdlEntityType entityType, CsdlProperty propertyName) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(entityType.getProperty(propertyName.getName()).getAnnotations(), annotation)) continue;
            entityType.getProperty(propertyName.getName()).getAnnotations().add(annotation);
        }
    }

    private CsdlComplexType getComplexTypeFromProperty(CsdlProperty propertyName) {
        CsdlComplexType complexType;
        try {
            complexType = this.provider.getComplexType(propertyName.getTypeAsFQNObject());
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return complexType;
    }

    private void addAnnotationsToComplexTypeIncludedFromES(CsdlEntitySet entitySet, FullQualifiedName entityContainerName, CsdlAnnotations annotationGrp, CsdlProperty propertyName, boolean isComplexPropAnnotationsCleared, boolean isComplexNavPropAnnotationsCleared, CsdlComplexType complexType) {
        for (CsdlProperty complexPropertyName : complexType.getProperties()) {
            if (!isComplexPropAnnotationsCleared) {
                complexType.getProperty(complexPropertyName.getName()).getAnnotations().clear();
            }
            if (!annotationGrp.getTarget().equalsIgnoreCase(entityContainerName + "/" + entitySet.getName() + "/" + propertyName.getName() + "/" + complexPropertyName.getName())) continue;
            this.isAnnotationsIncluded = true;
            this.addAnnotationsToComplexTypeProperties(annotationGrp, complexType, complexPropertyName);
        }
        for (CsdlNavigationProperty complexNavPropertyName : complexType.getNavigationProperties()) {
            if (!isComplexNavPropAnnotationsCleared) {
                complexType.getNavigationProperty(complexNavPropertyName.getName()).getAnnotations().clear();
            }
            if (!annotationGrp.getTarget().equalsIgnoreCase(entityContainerName + "/" + entitySet.getName() + "/" + propertyName.getName() + "/" + complexNavPropertyName.getName())) continue;
            this.isAnnotationsIncluded = true;
            this.addAnnotationsToComplexTypeNavProperties(annotationGrp, complexType, complexNavPropertyName);
        }
    }

    private void addAnnotationsToComplexTypeNavProperties(CsdlAnnotations annotationGrp, CsdlComplexType complexType, CsdlNavigationProperty complexNavPropertyName) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(complexType.getNavigationProperty(complexNavPropertyName.getName()).getAnnotations(), annotation)) continue;
            complexType.getNavigationProperty(complexNavPropertyName.getName()).getAnnotations().add(annotation);
        }
    }

    private void addAnnotationsToComplexTypeProperties(CsdlAnnotations annotationGrp, CsdlComplexType complexType, CsdlProperty complexPropertyName) {
        for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
            if (this.compareAnnotations(complexType.getProperty(complexPropertyName.getName()).getAnnotations(), annotation)) continue;
            complexType.getProperty(complexPropertyName.getName()).getAnnotations().add(annotation);
        }
    }

    private boolean isPropertyComplex(CsdlProperty propertyName) {
        try {
            return this.provider.getComplexType(propertyName.getTypeAsFQNObject()) != null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    protected EdmActionImport createActionImport(String actionImportName) {
        EdmActionImportImpl actionImport = null;
        try {
            CsdlActionImport providerImport = this.provider.getActionImport(this.entityContainerName, actionImportName);
            if (providerImport != null) {
                this.addAnnotations(providerImport, this.entityContainerName);
                actionImport = new EdmActionImportImpl(this.edm, (EdmEntityContainer)this, providerImport);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return actionImport;
    }

    private void addAnnotations(CsdlActionImport actionImport, FullQualifiedName entityContainerName) {
        List<CsdlSchema> termSchemaDefinition = ((EdmProviderImpl)this.edm).getTermSchemaDefinitions();
        block0: for (CsdlSchema schema : termSchemaDefinition) {
            List annotationGrps = schema.getAnnotationGroups();
            for (CsdlAnnotations annotationGrp : annotationGrps) {
                if (!annotationGrp.getTarget().equalsIgnoreCase(entityContainerName + "/" + actionImport.getName())) continue;
                for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
                    if (this.compareAnnotations(actionImport.getAnnotations(), annotation)) continue;
                    actionImport.getAnnotations().add(annotation);
                }
                continue block0;
            }
        }
    }

    protected EdmFunctionImport createFunctionImport(String functionImportName) {
        EdmFunctionImportImpl functionImport = null;
        try {
            CsdlFunctionImport providerImport = this.provider.getFunctionImport(this.entityContainerName, functionImportName);
            if (providerImport != null) {
                this.addAnnotations(providerImport, this.entityContainerName);
                functionImport = new EdmFunctionImportImpl(this.edm, (EdmEntityContainer)this, providerImport);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return functionImport;
    }

    private void addAnnotations(CsdlFunctionImport functionImport, FullQualifiedName entityContainerName) {
        List<CsdlSchema> termSchemaDefinition = ((EdmProviderImpl)this.edm).getTermSchemaDefinitions();
        block0: for (CsdlSchema schema : termSchemaDefinition) {
            List annotationGrps = schema.getAnnotationGroups();
            for (CsdlAnnotations annotationGrp : annotationGrps) {
                if (!annotationGrp.getTarget().equalsIgnoreCase(entityContainerName + "/" + functionImport.getName())) continue;
                for (CsdlAnnotation annotation : annotationGrp.getAnnotations()) {
                    if (this.compareAnnotations(functionImport.getAnnotations(), annotation)) continue;
                    functionImport.getAnnotations().add(annotation);
                }
                continue block0;
            }
        }
    }

    protected void loadAllEntitySets() {
        this.loadContainer();
        List providerEntitySets = this.container.getEntitySets();
        ArrayList<EdmEntitySet> entitySetsLocal = new ArrayList<EdmEntitySet>();
        if (providerEntitySets != null) {
            for (CsdlEntitySet entitySet : providerEntitySets) {
                this.addAnnotations(entitySet, this.entityContainerName);
                EdmEntitySetImpl impl = new EdmEntitySetImpl(this.edm, (EdmEntityContainer)this, entitySet);
                if (this.isAnnotationsIncluded) {
                    this.entitySetWithAnnotationsCache.put(impl.getName(), impl);
                } else {
                    this.entitySetCache.put(impl.getName(), impl);
                }
                entitySetsLocal.add(impl);
            }
            this.entitySets = entitySetsLocal;
            ((EdmProviderImpl)this.edm).setIsPreviousES(true);
        }
    }

    protected void loadAllFunctionImports() {
        this.loadContainer();
        List providerFunctionImports = this.container.getFunctionImports();
        ArrayList<EdmFunctionImport> functionImportsLocal = new ArrayList<EdmFunctionImport>();
        if (providerFunctionImports != null) {
            for (CsdlFunctionImport functionImport : providerFunctionImports) {
                this.addAnnotations(functionImport, this.entityContainerName);
                EdmFunctionImportImpl impl = new EdmFunctionImportImpl(this.edm, (EdmEntityContainer)this, functionImport);
                this.functionImportCache.put(impl.getName(), impl);
                functionImportsLocal.add(impl);
            }
            this.functionImports = functionImportsLocal;
        }
    }

    protected void loadAllSingletons() {
        this.loadContainer();
        List providerSingletons = this.container.getSingletons();
        ArrayList<EdmSingleton> singletonsLocal = new ArrayList<EdmSingleton>();
        if (providerSingletons != null) {
            for (CsdlSingleton singleton : providerSingletons) {
                this.addAnnotations(singleton, this.entityContainerName);
                EdmSingletonImpl impl = new EdmSingletonImpl(this.edm, (EdmEntityContainer)this, singleton);
                this.singletonCache.put(singleton.getName(), impl);
                singletonsLocal.add(impl);
            }
            this.singletons = singletonsLocal;
        }
    }

    protected void loadAllActionImports() {
        this.loadContainer();
        List providerActionImports = this.container.getActionImports();
        ArrayList<EdmActionImport> actionImportsLocal = new ArrayList<EdmActionImport>();
        if (providerActionImports != null) {
            for (CsdlActionImport actionImport : providerActionImports) {
                this.addAnnotations(actionImport, this.entityContainerName);
                EdmActionImportImpl impl = new EdmActionImportImpl(this.edm, (EdmEntityContainer)this, actionImport);
                this.actionImportCache.put(actionImport.getName(), impl);
                actionImportsLocal.add(impl);
            }
            this.actionImports = actionImportsLocal;
        }
    }

    private void loadContainer() {
        if (this.container == null) {
            try {
                CsdlEntityContainer containerLocal = this.provider.getEntityContainer();
                if (containerLocal == null) {
                    containerLocal = new CsdlEntityContainer().setName(this.getName());
                }
                ((EdmProviderImpl)this.edm).addAnnotations(containerLocal, this.entityContainerName);
                this.container = containerLocal;
            }
            catch (ODataException e) {
                throw new EdmException((Exception)((Object)e));
            }
        }
    }

    private boolean compareAnnotations(List<CsdlAnnotation> annotations, CsdlAnnotation annotation) {
        for (CsdlAnnotation annot : annotations) {
            if (!annot.equals((Object)annotation)) continue;
            return true;
        }
        return false;
    }
}

