/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmTimeOfDay
extends SingletonPrimitiveType {
    private static final Pattern PATTERN = Pattern.compile("(\\p{Digit}{2}):(\\p{Digit}{2})(?::(\\p{Digit}{2})(\\.(\\p{Digit}{0,}?)0*)?)?");
    private static final EdmTimeOfDay INSTANCE = new EdmTimeOfDay();

    public static EdmTimeOfDay getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return Calendar.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        Calendar dateTimeValue = Calendar.getInstance();
        dateTimeValue.clear();
        dateTimeValue.set(11, Byte.parseByte(matcher.group(1)));
        dateTimeValue.set(12, Byte.parseByte(matcher.group(2)));
        dateTimeValue.set(13, matcher.group(3) == null ? 0 : (int)Byte.parseByte(matcher.group(3)));
        int nanoSeconds = 0;
        if (matcher.group(4) != null) {
            if (matcher.group(4).length() == 1 || matcher.group(4).length() > 13) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
            }
            String decimals = matcher.group(5);
            if (decimals.length() > (precision == null ? 0 : precision)) {
                throw new EdmPrimitiveTypeException("The literal '" + value + "' does not match the facets' constraints.");
            }
            if (returnType.isAssignableFrom(Timestamp.class)) {
                if (decimals.length() > 9) throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".");
                nanoSeconds = Integer.parseInt(decimals + "000000000".substring(decimals.length()));
            } else {
                if (decimals.length() > 3) throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".");
                String milliSeconds = decimals + "000".substring(decimals.length());
                dateTimeValue.set(14, Short.parseShort(milliSeconds));
            }
        }
        try {
            return EdmDateTimeOffset.convertDateTime(dateTimeValue, nanoSeconds, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", (Exception)e);
        }
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        Calendar dateTimeValue = EdmDateTimeOffset.createDateTime(value, true);
        StringBuilder result = new StringBuilder();
        EdmDateTimeOffset.appendTwoDigits(result, dateTimeValue.get(11));
        result.append(':');
        EdmDateTimeOffset.appendTwoDigits(result, dateTimeValue.get(12));
        result.append(':');
        EdmDateTimeOffset.appendTwoDigits(result, dateTimeValue.get(13));
        int fractionalSecs = value instanceof Timestamp ? ((Timestamp)value).getNanos() : dateTimeValue.get(14);
        try {
            EdmDateTimeOffset.appendFractionalSeconds(result, fractionalSecs, value instanceof Timestamp, precision);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The value '" + value + "' does not match the facets' constraints.", (Exception)e);
        }
        return result.toString();
    }
}

