/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api.processor;

import java.io.ByteArrayInputStream;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ClientServerError;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.ErrorProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;

public class DefaultProcessor
implements MetadataProcessor,
ServiceDocumentProcessor,
ErrorProcessor {
    private OData odata;
    private ServiceMetadata serviceMetadata;

    @Override
    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    @Override
    public void readServiceDocument(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestedContentType) throws ODataApplicationException, SerializerException {
        ODataSerializer serializer = this.odata.createSerializer(ODataFormat.fromContentType((ContentType)requestedContentType));
        response.setContent(serializer.serviceDocument(this.serviceMetadata.getEdm(), null).getContent());
        response.setStatusCode(HttpStatusCode.OK.getStatusCode());
        response.setHeader("Content-Type", requestedContentType.toContentTypeString());
    }

    @Override
    public void readMetadata(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestedContentType) throws ODataApplicationException, SerializerException {
        ODataSerializer serializer = this.odata.createSerializer(ODataFormat.fromContentType((ContentType)requestedContentType));
        response.setContent(serializer.metadataDocument(this.serviceMetadata).getContent());
        response.setStatusCode(HttpStatusCode.OK.getStatusCode());
        response.setHeader("Content-Type", requestedContentType.toContentTypeString());
    }

    @Override
    public void processError(ODataRequest request, ODataResponse response, ClientServerError serverError, ContentType requestedContentType) {
        try {
            ODataSerializer serializer = this.odata.createSerializer(ODataFormat.fromContentType((ContentType)requestedContentType));
            response.setContent(serializer.error(serverError).getContent());
            response.setStatusCode(serverError.getStatusCode());
            response.setHeader("Content-Type", requestedContentType.toContentTypeString());
        }
        catch (Exception e) {
            String responseContent = "{\"error\":{\"code\":null,\"message\":\"An unexpected exception occurred during error processing with message: " + e.getMessage() + "\"}}";
            response.setContent(new ByteArrayInputStream(responseContent.getBytes()));
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            response.setHeader("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
        }
    }
}

