/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.debug;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.core.debug.DebugTab;
import org.apache.olingo.server.core.debug.ExpressionJsonVisitor;

public class DebugTabUri
implements DebugTab {
    private final UriInfo uriInfo;

    public DebugTabUri(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public String getName() {
        return "URI";
    }

    @Override
    public void appendJson(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        if (this.uriInfo.getFormatOption() != null) {
            gen.writeStringField("format", this.uriInfo.getFormatOption().getFormat());
        }
        if (this.uriInfo.getIdOption() != null) {
            gen.writeStringField("id", this.uriInfo.getIdOption().getValue());
        }
        if (this.uriInfo.getSkipTokenOption() != null) {
            gen.writeStringField("skiptoken", this.uriInfo.getSkipTokenOption().getValue());
        }
        this.appendCommonJsonObjects(gen, this.uriInfo.getCountOption(), this.uriInfo.getSkipOption(), this.uriInfo.getTopOption(), this.uriInfo.getFilterOption(), this.uriInfo.getOrderByOption(), this.uriInfo.getSelectOption(), this.uriInfo.getExpandOption());
        if (this.uriInfo.getUriResourceParts() != null) {
            this.appendURIResourceParts(gen, this.uriInfo.getUriResourceParts());
        }
        gen.writeEndObject();
    }

    private void appendCommonJsonObjects(JsonGenerator gen, CountOption countOption, SkipOption skipOption, TopOption topOption, FilterOption filterOption, OrderByOption orderByOption, SelectOption selectOption, ExpandOption expandOption) throws IOException {
        if (countOption != null) {
            gen.writeBooleanField("isCount", countOption.getValue());
        }
        if (skipOption != null) {
            gen.writeNumberField("skip", skipOption.getValue());
        }
        if (topOption != null) {
            gen.writeNumberField("top", topOption.getValue());
        }
        if (filterOption != null) {
            gen.writeFieldName("filter");
            this.appendJsonExpressionString(gen, filterOption.getExpression());
        }
        if (orderByOption != null && orderByOption.getOrders() != null) {
            gen.writeFieldName("orderby");
            gen.writeStartObject();
            gen.writeStringField("nodeType", "orderCollection");
            gen.writeFieldName("orders");
            gen.writeStartArray();
            for (OrderByItem item : orderByOption.getOrders()) {
                gen.writeStartObject();
                gen.writeStringField("nodeType", "order");
                gen.writeStringField("sortorder", item.isDescending() ? "desc" : "asc");
                gen.writeFieldName("expression");
                this.appendJsonExpressionString(gen, item.getExpression());
                gen.writeEndObject();
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
        if (selectOption != null && !selectOption.getSelectItems().isEmpty()) {
            this.appendSelectedPropertiesJson(gen, selectOption.getSelectItems());
        }
        if (expandOption != null && !expandOption.getExpandItems().isEmpty()) {
            this.appendExpandedPropertiesJson(gen, expandOption.getExpandItems());
        }
    }

    private void appendURIResourceParts(JsonGenerator gen, List<UriResource> uriResourceParts) throws IOException {
        gen.writeFieldName("uriResourceParts");
        gen.writeStartArray();
        for (UriResource resource : uriResourceParts) {
            gen.writeStartObject();
            gen.writeStringField("uriResourceKind", resource.getKind().toString());
            gen.writeStringField("segment", resource.toString());
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    private void appendExpandedPropertiesJson(JsonGenerator gen, List<ExpandItem> expandItems) throws IOException {
        gen.writeFieldName("expand");
        gen.writeStartArray();
        for (ExpandItem item : expandItems) {
            this.appendExpandItemJson(gen, item);
        }
        gen.writeEndArray();
    }

    private void appendExpandItemJson(JsonGenerator gen, ExpandItem item) throws IOException {
        gen.writeStartObject();
        if (item.isStar()) {
            gen.writeBooleanField("star", item.isStar());
        } else if (item.getResourcePath() != null && item.getResourcePath().getUriResourceParts() != null) {
            gen.writeFieldName("expandPath");
            gen.writeStartArray();
            for (UriResource resource : item.getResourcePath().getUriResourceParts()) {
                gen.writeStartObject();
                gen.writeStringField("propertyKind", resource.getKind().toString());
                gen.writeStringField("propertyName", resource.toString());
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
        if (item.isRef()) {
            gen.writeBooleanField("isRef", item.isRef());
        }
        if (item.getLevelsOption() != null) {
            gen.writeNumberField("levels", item.getLevelsOption().getValue());
        }
        this.appendCommonJsonObjects(gen, item.getCountOption(), item.getSkipOption(), item.getTopOption(), item.getFilterOption(), item.getOrderByOption(), item.getSelectOption(), item.getExpandOption());
        gen.writeEndObject();
    }

    private void appendJsonExpressionString(JsonGenerator gen, Expression expression) throws IOException {
        String expressionJsonString;
        if (expression == null) {
            gen.writeNull();
            return;
        }
        try {
            expressionJsonString = (String)expression.accept((ExpressionVisitor)new ExpressionJsonVisitor());
        }
        catch (ODataException e) {
            expressionJsonString = "Exception in Debug Filter visitor occurred: " + e.getMessage();
        }
        gen.writeRawValue(expressionJsonString);
    }

    private void appendSelectedPropertiesJson(JsonGenerator gen, List<SelectItem> selectItems) throws IOException {
        gen.writeFieldName("select");
        gen.writeStartArray();
        for (SelectItem selectItem : selectItems) {
            this.appendSelectItemJson(gen, selectItem);
        }
        gen.writeEndArray();
    }

    private void appendSelectItemJson(JsonGenerator gen, SelectItem selectItem) throws IOException {
        String selectedProperty = "";
        if (selectItem.isStar()) {
            selectedProperty = selectItem.getAllOperationsInSchemaNameSpace() == null ? "*" : selectItem.getAllOperationsInSchemaNameSpace().getFullQualifiedNameAsString() + ".*";
        } else {
            boolean first = true;
            for (UriResource resourcePart : selectItem.getResourcePath().getUriResourceParts()) {
                if (!first) {
                    selectedProperty = selectedProperty + "/";
                }
                selectedProperty = resourcePart.toString();
                first = false;
            }
        }
        gen.writeString(selectedProperty);
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        writer.append("<h2>Uri Information</h2>\n").append("<ul class=\"json\">\n<li>\n");
        JsonGenerator json = new JsonFactory().createGenerator(writer).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        this.appendJson(json);
        json.close();
        writer.append("\n</li>\n</ul>\n");
    }
}

