/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.api.deserializer.batch.BatchRequestPart;
import org.apache.olingo.server.core.deserializer.batch.BatchBodyPart;
import org.apache.olingo.server.core.deserializer.batch.BatchChangeSetPart;
import org.apache.olingo.server.core.deserializer.batch.BatchParserCommon;
import org.apache.olingo.server.core.deserializer.batch.BatchPart;
import org.apache.olingo.server.core.deserializer.batch.BatchQueryOperation;
import org.apache.olingo.server.core.deserializer.batch.BatchTransformatorCommon;
import org.apache.olingo.server.core.deserializer.batch.Header;
import org.apache.olingo.server.core.deserializer.batch.HeaderField;
import org.apache.olingo.server.core.deserializer.batch.HttpRequestStatusLine;

public class BatchRequestTransformator {
    private static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");
    private final String baseUri;
    private final String rawServiceResolutionUri;

    public BatchRequestTransformator(String baseUri, String serviceResolutionUri) {
        this.baseUri = baseUri;
        this.rawServiceResolutionUri = serviceResolutionUri;
    }

    public List<BatchRequestPart> transform(BatchBodyPart bodyPart) throws BatchDeserializerException {
        LinkedList<ODataRequest> requests = new LinkedList<ODataRequest>();
        ArrayList<BatchRequestPart> resultList = new ArrayList<BatchRequestPart>();
        this.validateBodyPartHeader(bodyPart);
        for (BatchQueryOperation queryOperation : bodyPart.getRequests()) {
            requests.add(this.processQueryOperation(bodyPart, this.baseUri, queryOperation));
        }
        resultList.add(new BatchRequestPart(bodyPart.isChangeSet(), requests));
        return resultList;
    }

    private ODataRequest processQueryOperation(BatchBodyPart bodyPart, String baseUri, BatchQueryOperation queryOperation) throws BatchDeserializerException {
        if (bodyPart.isChangeSet()) {
            BatchQueryOperation encapsulatedQueryOperation = ((BatchChangeSetPart)queryOperation).getRequest();
            this.handleContentId(queryOperation, encapsulatedQueryOperation);
            this.validateHeader(queryOperation, true);
            return this.createRequest(encapsulatedQueryOperation, baseUri, bodyPart.isChangeSet());
        }
        return this.createRequest(queryOperation, baseUri, bodyPart.isChangeSet());
    }

    private void handleContentId(BatchQueryOperation changeRequestPart, BatchQueryOperation request) throws BatchDeserializerException {
        HeaderField contentIdChangeRequestPart = this.getContentId(changeRequestPart);
        HeaderField contentIdRequest = this.getContentId(request);
        if (contentIdChangeRequestPart == null && contentIdRequest == null) {
            throw new BatchDeserializerException("Missing content id", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_CONTENT_ID, new String[]{Integer.toString(changeRequestPart.getHeaders().getLineNumber())});
        }
        if (contentIdChangeRequestPart != null) {
            request.getHeaders().replaceHeaderField(contentIdChangeRequestPart);
        }
    }

    private HeaderField getContentId(BatchQueryOperation queryOperation) throws BatchDeserializerException {
        HeaderField contentIdHeader = queryOperation.getHeaders().getHeaderField("Content-ID");
        if (contentIdHeader != null) {
            if (contentIdHeader.getValues().size() == 1) {
                return contentIdHeader;
            }
            throw new BatchDeserializerException("Invalid Content-ID header", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_ID, new String[]{Integer.toString(contentIdHeader.getLineNumber())});
        }
        return null;
    }

    private ODataRequest createRequest(BatchQueryOperation operation, String baseUri, boolean isChangeSet) throws BatchDeserializerException {
        HttpRequestStatusLine statusLine = new HttpRequestStatusLine(operation.getHttpStatusLine(), baseUri, this.rawServiceResolutionUri);
        statusLine.validateHttpMethod(isChangeSet);
        this.validateBody(statusLine, operation);
        Charset charset = this.getCharset(operation);
        InputStream bodyStrean = this.getBodyStream(operation, statusLine, charset);
        this.validateForbiddenHeader(operation);
        ODataRequest request = new ODataRequest();
        request.setBody(bodyStrean);
        request.setMethod(statusLine.getMethod());
        request.setRawBaseUri(statusLine.getRawBaseUri());
        request.setRawODataPath(statusLine.getRawODataPath());
        request.setRawQueryPath(statusLine.getRawQueryPath());
        request.setRawRequestUri(statusLine.getRawRequestUri());
        request.setRawServiceResolutionUri(statusLine.getRawServiceResolutionUri());
        for (HeaderField field : operation.getHeaders()) {
            request.addHeader(field.getFieldName(), field.getValues());
        }
        return request;
    }

    private Charset getCharset(BatchQueryOperation operation) {
        String charsetValue;
        ContentType contentType;
        String ct = operation.getHeaders().getHeader("Content-Type");
        if (ct != null && (contentType = ContentType.parse((String)ct)) != null && (charsetValue = contentType.getParameter("charset")) != null) {
            return Charset.forName(charsetValue);
        }
        return DEFAULT_CHARSET;
    }

    private void validateForbiddenHeader(BatchQueryOperation operation) throws BatchDeserializerException {
        Header header = operation.getHeaders();
        if (header.exists("Authorization") || header.exists("Expect") || header.exists("From") || header.exists("Max-Forwards") || header.exists("Range") || header.exists("TE")) {
            throw new BatchDeserializerException("Forbidden header", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.FORBIDDEN_HEADER, new String[]{Integer.toString(header.getLineNumber())});
        }
    }

    private InputStream getBodyStream(BatchQueryOperation operation, HttpRequestStatusLine statusLine, Charset charset) throws BatchDeserializerException {
        if (statusLine.getMethod().equals((Object)HttpMethod.GET)) {
            return new ByteArrayInputStream(new byte[0]);
        }
        int contentLength = BatchTransformatorCommon.getContentLength(operation.getHeaders());
        if (contentLength == -1) {
            return BatchParserCommon.convertLineListToInputStream(operation.getBody(), charset);
        }
        return BatchParserCommon.convertLineListToInputStream(operation.getBody(), charset, contentLength);
    }

    private void validateBody(HttpRequestStatusLine statusLine, BatchQueryOperation operation) throws BatchDeserializerException {
        if (statusLine.getMethod().equals((Object)HttpMethod.GET) && this.isUnvalidGetRequestBody(operation)) {
            throw new BatchDeserializerException("Invalid request line", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT, new String[]{Integer.toString(statusLine.getLineNumber())});
        }
    }

    private boolean isUnvalidGetRequestBody(BatchQueryOperation operation) {
        return operation.getBody().size() > 1 || operation.getBody().size() == 1 && !"".equals(operation.getBody().get(0).toString().trim());
    }

    private void validateHeader(BatchPart bodyPart, boolean isChangeSet) throws BatchDeserializerException {
        Header headers = bodyPart.getHeaders();
        BatchTransformatorCommon.validateContentType(headers, ContentType.APPLICATION_HTTP);
        if (isChangeSet) {
            BatchTransformatorCommon.validateContentTransferEncoding(headers);
        }
    }

    private void validateBodyPartHeader(BatchBodyPart bodyPart) throws BatchDeserializerException {
        Header header = bodyPart.getHeaders();
        if (bodyPart.isChangeSet()) {
            BatchTransformatorCommon.validateContentType(header, ContentType.MULTIPART_MIXED);
        } else {
            BatchTransformatorCommon.validateContentTransferEncoding(header);
            BatchTransformatorCommon.validateContentType(header, ContentType.APPLICATION_HTTP);
        }
    }
}

