/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.validator;

import java.util.HashMap;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class UriValidator {
    private final boolean[][] decisionMatrix = new boolean[][]{{true, true, true, false, true, true, true, true, true, true, true}, {false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, false, true, true, true, true, true, true, true}, {false, true, true, true, false, false, false, true, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false}, {true, true, true, false, true, true, true, true, true, true, true}, {true, false, false, false, false, false, true, false, false, false, false}, {false, true, true, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, true, true, true, true, false, true, true, true}, {false, true, false, false, false, false, false, false, false, false, false}, {false, true, true, false, false, false, false, true, false, false, false}, {true, true, true, false, true, true, false, true, true, true, true}, {true, false, false, false, false, false, true, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false}, {true, true, false, false, true, true, false, false, true, true, true}, {true, false, false, false, false, false, true, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false}};

    public void validate(UriInfo uriInfo, HttpMethod httpMethod) throws UriValidationException {
        if (HttpMethod.GET != httpMethod) {
            this.validateForHttpMethod(uriInfo, httpMethod);
        }
        this.validateQueryOptions(uriInfo);
        this.validateKeyPredicates(uriInfo);
        this.validatePropertyOperations(uriInfo, httpMethod);
    }

    private ColumnIndex colIndex(SystemQueryOptionKind queryOptionKind) throws UriValidationException {
        ColumnIndex idx;
        switch (queryOptionKind) {
            case FILTER: {
                idx = ColumnIndex.filter;
                break;
            }
            case FORMAT: {
                idx = ColumnIndex.format;
                break;
            }
            case EXPAND: {
                idx = ColumnIndex.expand;
                break;
            }
            case ID: {
                idx = ColumnIndex.id;
                break;
            }
            case COUNT: {
                idx = ColumnIndex.count;
                break;
            }
            case ORDERBY: {
                idx = ColumnIndex.orderby;
                break;
            }
            case SEARCH: {
                idx = ColumnIndex.search;
                break;
            }
            case SELECT: {
                idx = ColumnIndex.select;
                break;
            }
            case SKIP: {
                idx = ColumnIndex.skip;
                break;
            }
            case SKIPTOKEN: {
                idx = ColumnIndex.skiptoken;
                break;
            }
            case TOP: {
                idx = ColumnIndex.top;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported option: " + queryOptionKind.toString(), UriValidationException.MessageKeys.UNSUPPORTED_QUERY_OPTION, queryOptionKind.toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForUriType(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        switch (uriInfo.getKind()) {
            case all: {
                idx = RowIndexForUriType.all;
                break;
            }
            case batch: {
                idx = RowIndexForUriType.batch;
                break;
            }
            case crossjoin: {
                idx = RowIndexForUriType.crossjoin;
                break;
            }
            case entityId: {
                idx = RowIndexForUriType.entityId;
                break;
            }
            case metadata: {
                idx = RowIndexForUriType.metadata;
                break;
            }
            case resource: {
                idx = this.rowIndexForResourceKind(uriInfo);
                break;
            }
            case service: {
                idx = RowIndexForUriType.service;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported uriInfo kind: " + uriInfo.getKind(), UriValidationException.MessageKeys.UNSUPPORTED_URI_KIND, uriInfo.getKind().toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForResourceKind(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        int lastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 1;
        UriResource lastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        switch (lastPathSegment.getKind()) {
            case count: {
                idx = this.rowIndexForCount(uriInfo);
                break;
            }
            case action: {
                idx = this.rowIndexForAction(lastPathSegment);
                break;
            }
            case complexProperty: {
                idx = this.rowIndexForComplexProperty(lastPathSegment);
                break;
            }
            case entitySet: 
            case navigationProperty: {
                idx = this.rowIndexForEntitySet(lastPathSegment);
                break;
            }
            case function: {
                idx = this.rowIndexForFunction(lastPathSegment);
                break;
            }
            case primitiveProperty: {
                idx = this.rowIndexForPrimitiveProperty(lastPathSegment);
                break;
            }
            case ref: {
                idx = this.rowIndexForRef(uriInfo, lastPathSegment);
                break;
            }
            case root: {
                idx = RowIndexForUriType.service;
                break;
            }
            case singleton: {
                idx = RowIndexForUriType.entity;
                break;
            }
            case value: {
                idx = this.rowIndexForValue(uriInfo);
                break;
            }
            default: {
                throw new UriValidationException("Unsupported uriResource kind: " + lastPathSegment.getKind(), UriValidationException.MessageKeys.UNSUPPORTED_URI_RESOURCE_KIND, lastPathSegment.getKind().toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForValue(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        int secondLastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 2;
        UriResource secondLastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(secondLastPathSegmentIndex);
        switch (secondLastPathSegment.getKind()) {
            case primitiveProperty: {
                idx = RowIndexForUriType.propertyPrimitiveValue;
                break;
            }
            case entitySet: 
            case navigationProperty: 
            case singleton: {
                idx = RowIndexForUriType.mediaStream;
                break;
            }
            case function: {
                UriResourceFunction uriFunction = (UriResourceFunction)secondLastPathSegment;
                EdmFunctionImport functionImport = uriFunction.getFunctionImport();
                EdmFunction function = functionImport == null ? uriFunction.getFunction() : (EdmFunction)functionImport.getUnboundFunctions().get(0);
                idx = function.getReturnType().getType().getKind() == EdmTypeKind.ENTITY ? RowIndexForUriType.mediaStream : RowIndexForUriType.propertyPrimitiveValue;
                break;
            }
            default: {
                throw new UriValidationException("Unexpected kind in path segment before $value: " + secondLastPathSegment.getKind(), UriValidationException.MessageKeys.UNALLOWED_KIND_BEFORE_VALUE, secondLastPathSegment.toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForRef(UriInfo uriInfo, UriResource lastPathSegment) throws UriValidationException {
        int secondLastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 2;
        UriResource secondLastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(secondLastPathSegmentIndex);
        if (secondLastPathSegment instanceof UriResourcePartTyped) {
            return ((UriResourcePartTyped)secondLastPathSegment).isCollection() ? RowIndexForUriType.references : RowIndexForUriType.reference;
        }
        throw new UriValidationException("secondLastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, lastPathSegment.toString());
    }

    private RowIndexForUriType rowIndexForPrimitiveProperty(UriResource lastPathSegment) throws UriValidationException {
        if (lastPathSegment instanceof UriResourcePartTyped) {
            return ((UriResourcePartTyped)lastPathSegment).isCollection() ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
        }
        throw new UriValidationException("lastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, lastPathSegment.toString());
    }

    private RowIndexForUriType rowIndexForFunction(UriResource lastPathSegment) throws UriValidationException {
        RowIndexForUriType idx;
        UriResourceFunction urf = (UriResourceFunction)lastPathSegment;
        EdmReturnType rt = urf.getFunction().getReturnType();
        switch (rt.getType().getKind()) {
            case ENTITY: {
                idx = rt.isCollection() && urf.getKeyPredicates().isEmpty() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
                break;
            }
            case PRIMITIVE: 
            case ENUM: 
            case DEFINITION: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
                break;
            }
            case COMPLEX: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported function return type: " + rt.getType().getKind(), UriValidationException.MessageKeys.UNSUPPORTED_FUNCTION_RETURN_TYPE, rt.getType().getKind().toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForEntitySet(UriResource lastPathSegment) throws UriValidationException {
        if (lastPathSegment instanceof UriResourcePartTyped) {
            return ((UriResourcePartTyped)lastPathSegment).isCollection() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
        }
        throw new UriValidationException("lastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, lastPathSegment.toString());
    }

    private RowIndexForUriType rowIndexForComplexProperty(UriResource lastPathSegment) throws UriValidationException {
        if (lastPathSegment instanceof UriResourcePartTyped) {
            return ((UriResourcePartTyped)lastPathSegment).isCollection() ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
        }
        throw new UriValidationException("lastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, lastPathSegment.toString());
    }

    private RowIndexForUriType rowIndexForAction(UriResource lastPathSegment) throws UriValidationException {
        RowIndexForUriType idx;
        EdmReturnType rt = ((UriResourceAction)lastPathSegment).getAction().getReturnType();
        if (rt == null) {
            return RowIndexForUriType.none;
        }
        switch (rt.getType().getKind()) {
            case ENTITY: {
                idx = rt.isCollection() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
                break;
            }
            case PRIMITIVE: 
            case ENUM: 
            case DEFINITION: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
                break;
            }
            case COMPLEX: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported action return type: " + rt.getType().getKind(), UriValidationException.MessageKeys.UNSUPPORTED_ACTION_RETURN_TYPE, rt.getType().getKind().toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForCount(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        int secondLastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 2;
        UriResource secondLastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(secondLastPathSegmentIndex);
        block0 : switch (secondLastPathSegment.getKind()) {
            case entitySet: 
            case navigationProperty: {
                idx = RowIndexForUriType.entitySetCount;
                break;
            }
            case complexProperty: {
                idx = RowIndexForUriType.propertyComplexCollectionCount;
                break;
            }
            case primitiveProperty: {
                idx = RowIndexForUriType.propertyPrimitiveCollectionCount;
                break;
            }
            case function: {
                UriResourceFunction uriFunction = (UriResourceFunction)secondLastPathSegment;
                EdmFunctionImport functionImport = uriFunction.getFunctionImport();
                EdmFunction function = functionImport == null ? uriFunction.getFunction() : (EdmFunction)functionImport.getUnboundFunctions().get(0);
                EdmType returnType = function.getReturnType().getType();
                switch (returnType.getKind()) {
                    case ENTITY: {
                        idx = RowIndexForUriType.entitySetCount;
                        break block0;
                    }
                    case COMPLEX: {
                        idx = RowIndexForUriType.propertyComplexCollectionCount;
                        break block0;
                    }
                    case PRIMITIVE: 
                    case ENUM: 
                    case DEFINITION: {
                        idx = RowIndexForUriType.propertyPrimitiveCollectionCount;
                        break block0;
                    }
                }
                throw new UriValidationException("Unsupported return type: " + returnType.getKind(), UriValidationException.MessageKeys.UNSUPPORTED_FUNCTION_RETURN_TYPE, returnType.getKind().toString());
            }
            default: {
                throw new UriValidationException("Illegal path part kind before $count: " + secondLastPathSegment.getKind(), UriValidationException.MessageKeys.UNALLOWED_KIND_BEFORE_COUNT, secondLastPathSegment.toString());
            }
        }
        return idx;
    }

    private void validateQueryOptions(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType row = this.rowIndexForUriType(uriInfo);
        for (SystemQueryOption option : uriInfo.getSystemQueryOptions()) {
            ColumnIndex col = this.colIndex(option.getKind());
            if (this.decisionMatrix[row.getIndex()][col.getIndex()]) continue;
            throw new UriValidationException("System query option not allowed: " + option.getName(), UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED, option.getName());
        }
    }

    private void validateForHttpMethod(UriInfo uriInfo, HttpMethod httpMethod) throws UriValidationException {
        switch (httpMethod) {
            case POST: {
                if (this.isAction(uriInfo)) break;
                this.validateNoQueryOptionsForHttpMethod(uriInfo, httpMethod);
                break;
            }
            case DELETE: {
                if (!this.isReferences(uriInfo)) {
                    this.validateNoQueryOptionsForHttpMethod(uriInfo, httpMethod);
                    break;
                }
                for (SystemQueryOption option : uriInfo.getSystemQueryOptions()) {
                    if (SystemQueryOptionKind.ID == option.getKind()) continue;
                    throw new UriValidationException("System query option " + option.getName() + " not allowed for method " + httpMethod, UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED_FOR_HTTP_METHOD, option.getName(), httpMethod.toString());
                }
                break;
            }
            case PUT: 
            case PATCH: {
                this.validateNoQueryOptionsForHttpMethod(uriInfo, httpMethod);
                break;
            }
            default: {
                throw new UriValidationException("HTTP method not supported: " + httpMethod, UriValidationException.MessageKeys.UNSUPPORTED_HTTP_METHOD, httpMethod.toString());
            }
        }
    }

    private boolean isReferences(UriInfo uriInfo) {
        List uriResourceParts;
        if (!uriInfo.getSystemQueryOptions().isEmpty() && UriResourceKind.ref == ((UriResource)(uriResourceParts = uriInfo.getUriResourceParts()).get(uriResourceParts.size() - 1)).getKind()) {
            UriResourcePartTyped previousSegment = (UriResourcePartTyped)uriResourceParts.get(uriResourceParts.size() - 2);
            return previousSegment.isCollection();
        }
        return false;
    }

    private void validateNoQueryOptionsForHttpMethod(UriInfo uriInfo, HttpMethod httpMethod) throws UriValidationException {
        if (!uriInfo.getSystemQueryOptions().isEmpty()) {
            StringBuilder options = new StringBuilder();
            for (SystemQueryOption option : uriInfo.getSystemQueryOptions()) {
                options.append(option.getName()).append(" ");
            }
            throw new UriValidationException("System query option " + options.toString() + " not allowed for method " + httpMethod, UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED_FOR_HTTP_METHOD, options.toString(), httpMethod.toString());
        }
    }

    private boolean isAction(UriInfo uriInfo) {
        List uriResourceParts = uriInfo.getUriResourceParts();
        if (uriResourceParts.isEmpty()) {
            return false;
        }
        return UriResourceKind.action == ((UriResource)uriResourceParts.get(uriResourceParts.size() - 1)).getKind();
    }

    private void validateKeyPredicates(UriInfo uriInfo) throws UriValidationException {
        for (UriResource pathSegment : uriInfo.getUriResourceParts()) {
            List keyPredicates;
            boolean isEntitySet;
            boolean bl = isEntitySet = pathSegment.getKind() == UriResourceKind.entitySet;
            if (!isEntitySet && pathSegment.getKind() != UriResourceKind.navigationProperty || (keyPredicates = isEntitySet ? ((UriResourceEntitySet)pathSegment).getKeyPredicates() : ((UriResourceNavigation)pathSegment).getKeyPredicates()) == null) continue;
            EdmEntityType entityType = isEntitySet ? ((UriResourceEntitySet)pathSegment).getEntityType() : (EdmEntityType)((UriResourceNavigation)pathSegment).getType();
            List keyPredicateNames = entityType.getKeyPredicateNames();
            HashMap<String, EdmKeyPropertyRef> edmKeys = new HashMap<String, EdmKeyPropertyRef>();
            for (EdmKeyPropertyRef key : entityType.getKeyPropertyRefs()) {
                edmKeys.put(key.getName(), key);
                String alias = key.getAlias();
                if (alias == null) continue;
                edmKeys.put(alias, key);
            }
            for (UriParameter keyPredicate : keyPredicates) {
                String name = keyPredicate.getName();
                String alias = keyPredicate.getAlias();
                if (keyPredicate.getReferencedProperty() == null) {
                    String value = alias == null ? keyPredicate.getText() : uriInfo.getValueForAlias(alias);
                    EdmKeyPropertyRef edmKey = (EdmKeyPropertyRef)edmKeys.get(name);
                    if (edmKey == null) {
                        if (keyPredicateNames.contains(name)) {
                            throw new UriValidationException("Double key property: " + name, UriValidationException.MessageKeys.DOUBLE_KEY_PROPERTY, name);
                        }
                        throw new UriValidationException("Unknown key property: " + name, UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, name);
                    }
                    EdmProperty property = edmKey.getProperty();
                    EdmPrimitiveType edmPrimitiveType = (EdmPrimitiveType)property.getType();
                    try {
                        if (!edmPrimitiveType.validate(edmPrimitiveType.fromUriLiteral(value), Boolean.valueOf(property.isNullable()), property.getMaxLength(), property.getPrecision(), property.getScale(), Boolean.valueOf(property.isUnicode()))) {
                            throw new UriValidationException("PrimitiveTypeException", UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, name);
                        }
                    }
                    catch (EdmPrimitiveTypeException e) {
                        throw new UriValidationException("PrimitiveTypeException", e, UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, name);
                    }
                }
                edmKeys.remove(name);
                edmKeys.remove(alias);
            }
        }
    }

    private void validatePropertyOperations(UriInfo uriInfo, HttpMethod method) throws UriValidationException {
        UriResource previous;
        List parts = uriInfo.getUriResourceParts();
        UriResource last = parts.size() > 0 ? (UriResource)parts.get(parts.size() - 1) : null;
        UriResource uriResource = previous = parts.size() > 1 ? (UriResource)parts.get(parts.size() - 2) : null;
        if (last != null && (last.getKind() == UriResourceKind.primitiveProperty || last.getKind() == UriResourceKind.complexProperty || last.getKind() == UriResourceKind.value && previous != null && previous.getKind() == UriResourceKind.primitiveProperty)) {
            EdmProperty property = ((UriResourceProperty)(last.getKind() == UriResourceKind.value ? previous : last)).getProperty();
            if (method == HttpMethod.PATCH && property.isCollection()) {
                throw new UriValidationException("Attempt to patch collection property.", UriValidationException.MessageKeys.UNSUPPORTED_HTTP_METHOD, method.toString());
            }
            if (method == HttpMethod.DELETE && !property.isNullable()) {
                throw new UriValidationException("Attempt to delete non-nullable property.", UriValidationException.MessageKeys.UNSUPPORTED_HTTP_METHOD, method.toString());
            }
        }
    }

    private static enum ColumnIndex {
        filter(0),
        format(1),
        expand(2),
        id(3),
        count(4),
        orderby(5),
        search(6),
        select(7),
        skip(8),
        skiptoken(9),
        top(10);

        private final int idx;

        private ColumnIndex(int i) {
            this.idx = i;
        }

        public int getIndex() {
            return this.idx;
        }
    }

    private static enum RowIndexForUriType {
        all(0),
        batch(1),
        crossjoin(2),
        entityId(3),
        metadata(4),
        service(5),
        entitySet(6),
        entitySetCount(7),
        entity(8),
        mediaStream(9),
        references(10),
        reference(11),
        propertyComplex(12),
        propertyComplexCollection(13),
        propertyComplexCollectionCount(14),
        propertyPrimitive(15),
        propertyPrimitiveCollection(16),
        propertyPrimitiveCollectionCount(17),
        propertyPrimitiveValue(18),
        none(19);

        private final int idx;

        private RowIndexForUriType(int i) {
            this.idx = i;
        }

        public int getIndex() {
            return this.idx;
        }
    }
}

