/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.AcceptType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.processor.CustomContentTypeSupportProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.core.ContentNegotiatorException;

public class ContentNegotiator {
    private ContentNegotiator() {
    }

    private static List<ContentType> getDefaultSupportedContentTypes(Class<? extends Processor> processorClass) {
        ArrayList<ContentType> defaults = new ArrayList<ContentType>();
        if (processorClass == MetadataProcessor.class) {
            defaults.add(ODataFormat.XML.getContentType(ODataServiceVersion.V40));
        } else {
            defaults.add(ODataFormat.JSON.getContentType(ODataServiceVersion.V40));
            defaults.add(ODataFormat.JSON_NO_METADATA.getContentType(ODataServiceVersion.V40));
        }
        return defaults;
    }

    private static List<ContentType> getSupportedContentTypes(Processor processor, Class<? extends Processor> processorClass) {
        List supportedContentTypes = ContentNegotiator.getDefaultSupportedContentTypes(processorClass);
        if (processor instanceof CustomContentTypeSupportProcessor) {
            supportedContentTypes = ((CustomContentTypeSupportProcessor)processor).modifySupportedContentTypes(supportedContentTypes, processorClass);
        }
        return supportedContentTypes;
    }

    public static ContentType doContentNegotiation(FormatOption formatOption, ODataRequest request, Processor processor, Class<? extends Processor> processorClass) throws ContentNegotiatorException {
        List<ContentType> supportedContentTypes = ContentNegotiator.getSupportedContentTypes(processor, processorClass);
        String acceptHeaderValue = request.getHeader("Accept");
        ContentType result = null;
        if (formatOption != null && formatOption.getFormat() != null) {
            String formatString = formatOption.getFormat().trim();
            Object format = ODataFormat.JSON.name().equalsIgnoreCase(formatString) ? ODataFormat.JSON : (ODataFormat.XML.name().equalsIgnoreCase(formatString) ? ODataFormat.XML : (ODataFormat.ATOM.name().equalsIgnoreCase(formatString) ? ODataFormat.ATOM : null));
            result = ContentNegotiator.getSupportedContentType(format == null ? ContentType.create((String)formatOption.getFormat()) : format.getContentType(ODataServiceVersion.V40), supportedContentTypes);
            if (result == null) {
                throw new ContentNegotiatorException("Unsupported $format = " + formatString, ContentNegotiatorException.MessageKeys.UNSUPPORTED_FORMAT_OPTION, formatString);
            }
        } else if (acceptHeaderValue != null) {
            List acceptedContentTypes = AcceptType.create((String)acceptHeaderValue);
            for (AcceptType acceptedType : acceptedContentTypes) {
                Iterator<ContentType> i$ = supportedContentTypes.iterator();
                while (i$.hasNext()) {
                    ContentType supportedContentType;
                    ContentType contentType = supportedContentType = i$.next();
                    if (acceptedType.getParameters().containsKey("charset")) {
                        String value = (String)acceptedType.getParameters().get("charset");
                        if ("utf8".equalsIgnoreCase(value) || "utf-8".equalsIgnoreCase(value)) {
                            contentType = ContentType.create((ContentType)contentType, (String[])new String[]{"charset=utf-8"});
                        } else {
                            throw new ContentNegotiatorException("charset in accept header not supported: " + acceptHeaderValue, ContentNegotiatorException.MessageKeys.WRONG_CHARSET_IN_HEADER, "Accept", acceptHeaderValue);
                        }
                    }
                    if (!acceptedType.matches(contentType)) continue;
                    result = contentType;
                    break;
                }
                if (result == null) continue;
                break;
            }
            if (result == null) {
                throw new ContentNegotiatorException("unsupported accept content type: " + acceptedContentTypes + " != " + supportedContentTypes, ContentNegotiatorException.MessageKeys.UNSUPPORTED_CONTENT_TYPES, acceptedContentTypes.toString());
            }
        } else {
            ContentType requestedContentType = processorClass == MetadataProcessor.class ? ODataFormat.XML.getContentType(ODataServiceVersion.V40) : ODataFormat.JSON.getContentType(ODataServiceVersion.V40);
            result = ContentNegotiator.getSupportedContentType(requestedContentType, supportedContentTypes);
            if (result == null) {
                throw new ContentNegotiatorException("unsupported accept content type: " + requestedContentType + " != " + supportedContentTypes, ContentNegotiatorException.MessageKeys.UNSUPPORTED_CONTENT_TYPE, requestedContentType.toContentTypeString());
            }
        }
        return result;
    }

    private static ContentType getSupportedContentType(ContentType requestedContentType, List<ContentType> supportedContentTypes) {
        for (ContentType supportedContentType : supportedContentTypes) {
            if (!requestedContentType.isCompatible(supportedContentType)) continue;
            return supportedContentType;
        }
        return null;
    }
}

