/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.processor.DefaultProcessor;
import org.apache.olingo.server.api.processor.EntityCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.ExceptionProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.core.ContentNegotiator;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.DefaultRedirectProcessor;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.RedirectProcessor;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;
import org.apache.olingo.server.core.uri.validator.UriValidator;

public class ODataHandler {
    private final OData odata;
    private final Edm edm;
    private final Map<Class<? extends Processor>, Processor> processors = new HashMap<Class<? extends Processor>, Processor>();

    public ODataHandler(OData server, Edm edm) {
        this.odata = server;
        this.edm = edm;
        this.register((Processor)new DefaultProcessor());
        this.register(new DefaultRedirectProcessor());
    }

    public ODataResponse process(ODataRequest request) {
        ContentType requestedContentType = null;
        ODataResponse response = new ODataResponse();
        try {
            this.processInternal(request, requestedContentType, response);
        }
        catch (UriValidationException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (UriParserSemanticException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (UriParserSyntaxException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (UriParserException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (ContentNegotiatorException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (ODataHandlerException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (ODataTranslatedException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, requestedContentType);
        }
        catch (ODataApplicationException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e);
            this.handleException(request, response, serverError, requestedContentType);
        }
        catch (Exception e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e);
            this.handleException(request, response, serverError, requestedContentType);
        }
        return response;
    }

    private void processInternal(ODataRequest request, ContentType requestedContentType, ODataResponse response) throws ODataTranslatedException, UriParserException, UriValidationException, ContentNegotiatorException, ODataApplicationException {
        this.validateODataVersion(request, response);
        Parser parser = new Parser();
        String odUri = request.getRawODataPath() + (request.getRawQueryPath() == null ? "" : "?" + request.getRawQueryPath());
        UriInfo uriInfo = parser.parseUri(odUri, this.edm);
        UriValidator validator = new UriValidator();
        validator.validate(uriInfo, request.getMethod());
        switch (uriInfo.getKind()) {
            case metadata: {
                MetadataProcessor mp = this.selectProcessor(MetadataProcessor.class);
                requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)mp, MetadataProcessor.class);
                mp.readMetadata(request, response, uriInfo, requestedContentType);
                break;
            }
            case service: {
                if ("".equals(request.getRawODataPath())) {
                    RedirectProcessor rdp = this.selectProcessor(RedirectProcessor.class);
                    rdp.redirect(request, response);
                    break;
                }
                ServiceDocumentProcessor sdp = this.selectProcessor(ServiceDocumentProcessor.class);
                requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)sdp, ServiceDocumentProcessor.class);
                sdp.readServiceDocument(request, response, uriInfo, requestedContentType);
                break;
            }
            case resource: {
                this.handleResourceDispatching(request, response, uriInfo);
                break;
            }
            default: {
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void handleException(ODataRequest request, ODataResponse response, ODataServerError serverError, ContentType requestedContentType) {
        ExceptionProcessor exceptionProcessor;
        try {
            exceptionProcessor = this.selectProcessor(ExceptionProcessor.class);
        }
        catch (ODataTranslatedException e) {
            exceptionProcessor = new DefaultProcessor();
        }
        if (requestedContentType == null) {
            requestedContentType = ODataFormat.JSON.getContentType(ODataServiceVersion.V40);
        }
        exceptionProcessor.processException(request, response, serverError, requestedContentType);
    }

    private void handleResourceDispatching(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataTranslatedException {
        int lastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 1;
        UriResource lastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        ContentType requestedContentType = null;
        switch (lastPathSegment.getKind()) {
            case entitySet: {
                if (((UriResourcePartTyped)lastPathSegment).isCollection()) {
                    if (request.getMethod().equals((Object)HttpMethod.GET)) {
                        EntityCollectionProcessor cp = this.selectProcessor(EntityCollectionProcessor.class);
                        requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)cp, EntityCollectionProcessor.class);
                        cp.readCollection(request, response, uriInfo, requestedContentType);
                        break;
                    }
                    throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
                }
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    EntityProcessor ep = this.selectProcessor(EntityProcessor.class);
                    requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)ep, EntityProcessor.class);
                    ep.readEntity(request, response, uriInfo, requestedContentType);
                    break;
                }
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
            case navigationProperty: {
                if (((UriResourceNavigation)lastPathSegment).isCollection()) {
                    if (request.getMethod().equals((Object)HttpMethod.GET)) {
                        EntityCollectionProcessor cp = this.selectProcessor(EntityCollectionProcessor.class);
                        requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)cp, EntityCollectionProcessor.class);
                        cp.readCollection(request, response, uriInfo, requestedContentType);
                        break;
                    }
                    throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
                }
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    EntityProcessor ep = this.selectProcessor(EntityProcessor.class);
                    requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)ep, EntityProcessor.class);
                    ep.readEntity(request, response, uriInfo, requestedContentType);
                    break;
                }
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
            default: {
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void validateODataVersion(ODataRequest request, ODataResponse response) throws ODataTranslatedException {
        String maxVersion = request.getHeader("OData-MaxVersion");
        response.setHeader("OData-Version", ODataServiceVersion.V40.toString());
        if (maxVersion != null && ODataServiceVersion.isBiggerThan((String)ODataServiceVersion.V40.toString(), (String)maxVersion)) {
            throw new ODataHandlerException("ODataVersion not supported: " + maxVersion, ODataHandlerException.MessageKeys.ODATA_VERSION_NOT_SUPPORTED, maxVersion);
        }
    }

    private <T extends Processor> T selectProcessor(Class<T> cls) throws ODataTranslatedException {
        Processor p = this.processors.get(cls);
        if (p == null) {
            throw new ODataHandlerException("Processor: " + cls.getName() + " not registered.", ODataHandlerException.MessageKeys.PROCESSOR_NOT_IMPLEMENTED, cls.getName());
        }
        return (T)p;
    }

    public void register(Processor processor) {
        processor.init(this.odata, this.edm);
        for (Class<?> cls : processor.getClass().getInterfaces()) {
            if (!Processor.class.isAssignableFrom(cls) || cls == Processor.class) continue;
            Class<?> procClass = cls;
            this.processors.put(procClass, processor);
        }
    }
}

