/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.LinkedComplexValue;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.domain.ODataError;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializerException;
import org.apache.olingo.server.core.serializer.json.ODataErrorSerializer;
import org.apache.olingo.server.core.serializer.json.ServiceDocumentJsonSerializer;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataJsonSerializer
implements ODataSerializer {
    private static final Logger log = LoggerFactory.getLogger(ODataJsonSerializer.class);
    private final ODataFormat format;

    public ODataJsonSerializer(ODataFormat format) {
        this.format = format;
    }

    public InputStream serviceDocument(Edm edm, String serviceRoot) throws ODataSerializerException {
        JsonGenerator gen = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            gen = new JsonFactory().createGenerator(buffer.getOutputStream()).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            new ServiceDocumentJsonSerializer(edm, serviceRoot).writeServiceDocument(gen);
            gen.close();
            InputStream inputStream = buffer.getInputStream();
            return inputStream;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ODataSerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        finally {
            if (gen != null) {
                try {
                    gen.close();
                }
                catch (IOException e) {
                    throw new ODataSerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                }
            }
        }
    }

    public InputStream metadataDocument(Edm edm) throws ODataSerializerException {
        throw new ODataSerializerException("Metadata in JSON format not supported!", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.JSON_METADATA, new String[0]);
    }

    public InputStream error(ODataServerError error) throws ODataSerializerException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            new ODataErrorSerializer().writeErrorDocument(json, (ODataError)error);
            json.close();
        }
        catch (IOException e) {
            throw new ODataSerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return buffer.getInputStream();
    }

    public InputStream entitySet(EdmEntitySet edmEntitySet, EntitySet entitySet, ContextURL contextURL) throws ODataSerializerException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            if (this.format != ODataFormat.JSON_NO_METADATA) {
                if (contextURL == null) {
                    throw new ODataSerializerException("ContextURL null!", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.NO_CONTEXT_URL, new String[0]);
                }
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            if (entitySet.getCount() != null) {
                json.writeNumberField("@odata.count", entitySet.getCount().intValue());
            }
            json.writeFieldName("value");
            json.writeStartArray();
            for (Entity entity : entitySet.getEntities()) {
                this.writeEntity(edmEntitySet, entity, null, json);
            }
            json.writeEndArray();
            if (entitySet.getNext() != null) {
                json.writeStringField("@odata.nextLink", entitySet.getNext().toASCIIString());
            }
            json.close();
        }
        catch (IOException e) {
            throw new ODataSerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return buffer.getInputStream();
    }

    public InputStream entity(EdmEntitySet edmEntitySet, Entity entity, ContextURL contextURL) throws ODataSerializerException {
        if (this.format != ODataFormat.JSON_NO_METADATA && contextURL == null) {
            throw new ODataSerializerException("ContextURL null!", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.NO_CONTEXT_URL, new String[0]);
        }
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            this.writeEntity(edmEntitySet, entity, contextURL, json);
            json.close();
        }
        catch (IOException e) {
            throw new ODataSerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return buffer.getInputStream();
    }

    protected void writeEntity(EdmEntitySet entitySet, Entity entity, ContextURL contextURL, JsonGenerator json) throws IOException, ODataSerializerException {
        EdmEntityType entityType = entitySet.getEntityType();
        json.writeStartObject();
        if (this.format != ODataFormat.JSON_NO_METADATA) {
            if (contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            if (entity.getETag() != null) {
                json.writeStringField("@odata.etag", entity.getETag());
            }
            if (entityType.hasStream()) {
                if (entity.getMediaETag() != null) {
                    json.writeStringField("@odata.mediaEtag", entity.getMediaETag());
                }
                if (entity.getMediaContentType() != null) {
                    json.writeStringField("@odata.mediaContentType", entity.getMediaContentType());
                }
            }
        }
        for (String propertyName : entityType.getPropertyNames()) {
            EdmProperty edmProperty = (EdmProperty)entityType.getProperty(propertyName);
            Property property = entity.getProperty(propertyName);
            this.writeProperty(edmProperty, property, json);
        }
        json.writeEndObject();
    }

    protected void writeProperty(EdmProperty edmProperty, Property property, JsonGenerator json) throws IOException, ODataSerializerException {
        block9: {
            json.writeFieldName(edmProperty.getName());
            if (property == null || property.isNull()) {
                if (edmProperty.isNullable() == Boolean.FALSE) {
                    throw new ODataSerializerException("Non-nullable property not present!", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.MISSING_PROPERTY, new String[]{edmProperty.getName()});
                }
                json.writeNull();
            } else {
                try {
                    if (edmProperty.isCollection()) {
                        this.writeCollection(edmProperty, property, json);
                        break block9;
                    }
                    if (edmProperty.isPrimitive()) {
                        this.writePrimitive(edmProperty, property, json);
                        break block9;
                    }
                    if (property.isLinkedComplex()) {
                        this.writeComplexValue(edmProperty, property.asLinkedComplex().getValue(), json);
                        break block9;
                    }
                    if (property.isComplex()) {
                        this.writeComplexValue(edmProperty, property.asComplex(), json);
                        break block9;
                    }
                    throw new ODataSerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
                }
                catch (EdmPrimitiveTypeException e) {
                    throw new ODataSerializerException("Wrong value for property!", (Throwable)e, (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{edmProperty.getName(), property.getValue().toString()});
                }
            }
        }
    }

    private void writeCollection(EdmProperty edmProperty, Property property, JsonGenerator json) throws IOException, EdmPrimitiveTypeException, ODataSerializerException {
        json.writeStartArray();
        block7: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_PRIMITIVE: {
                    this.writePrimitiveValue(edmProperty, value, json);
                    continue block7;
                }
                case COLLECTION_GEOSPATIAL: {
                    throw new ODataSerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
                }
                case COLLECTION_ENUM: {
                    json.writeString(value.toString());
                    continue block7;
                }
                case COLLECTION_LINKED_COMPLEX: {
                    this.writeComplexValue(edmProperty, ((LinkedComplexValue)value).getValue(), json);
                    continue block7;
                }
                case COLLECTION_COMPLEX: {
                    this.writeComplexValue(edmProperty, property.asComplex(), json);
                    continue block7;
                }
            }
            throw new ODataSerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
        }
        json.writeEndArray();
    }

    private void writePrimitive(EdmProperty edmProperty, Property property, JsonGenerator json) throws EdmPrimitiveTypeException, IOException, ODataSerializerException {
        if (property.isPrimitive()) {
            this.writePrimitiveValue(edmProperty, property.asPrimitive(), json);
        } else {
            if (property.isGeospatial()) {
                throw new ODataSerializerException("Property type not yet supported!", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
            }
            if (property.isEnum()) {
                this.writePrimitiveValue(edmProperty, property.asEnum(), json);
            } else {
                throw new ODataSerializerException("Inconsistent property type!", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.INCONSISTENT_PROPERTY_TYPE, new String[]{edmProperty.getName()});
            }
        }
    }

    protected void writePrimitiveValue(EdmProperty edmProperty, Object primitiveValue, JsonGenerator json) throws EdmPrimitiveTypeException, IOException {
        EdmPrimitiveType type = (EdmPrimitiveType)edmProperty.getType();
        String value = type.valueToString(primitiveValue, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode());
        if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Boolean)) {
            json.writeBoolean(Boolean.parseBoolean(value));
        } else if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Byte) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Decimal) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Double) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int16) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int32) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int64) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.SByte) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Single)) {
            json.writeNumber(value);
        } else {
            json.writeString(value);
        }
    }

    private void writeComplexValue(EdmProperty edmProperty, List<Property> properties, JsonGenerator json) throws IOException, EdmPrimitiveTypeException, ODataSerializerException {
        EdmComplexType type = (EdmComplexType)edmProperty.getType();
        json.writeStartObject();
        for (String propertyName : type.getPropertyNames()) {
            Property property = this.findProperty(propertyName, properties);
            this.writeProperty((EdmProperty)type.getProperty(propertyName), property, json);
        }
        json.writeEndObject();
    }

    private Property findProperty(String propertyName, List<Property> properties) {
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }
}

