/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.core.Decoder;
import org.apache.olingo.server.core.uri.parser.RawUri;

public class UriDecoder {
    static Pattern uriPattern = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");

    public static RawUri decodeUri(String uri, int scipSegments) {
        RawUri rawUri = new RawUri();
        Matcher m = uriPattern.matcher(uri);
        if (m.matches()) {
            rawUri.scheme = m.group(2);
            rawUri.authority = m.group(4);
            rawUri.path = m.group(5);
            rawUri.queryOptionString = m.group(7);
            rawUri.fragment = m.group(9);
        }
        UriDecoder.splittPath(rawUri, scipSegments);
        UriDecoder.splittOptions(rawUri);
        UriDecoder.decode(rawUri);
        return rawUri;
    }

    private static void decode(RawUri rawUri) {
        rawUri.pathSegmentListDecoded = new ArrayList<String>();
        for (String segment : rawUri.pathSegmentList) {
            rawUri.pathSegmentListDecoded.add(UriDecoder.decode(segment));
        }
        rawUri.queryOptionListDecoded = new ArrayList<RawUri.QueryOption>();
        for (RawUri.QueryOption optionPair : rawUri.queryOptionList) {
            rawUri.queryOptionListDecoded.add(new RawUri.QueryOption(UriDecoder.decode(optionPair.name), UriDecoder.decode(optionPair.value)));
        }
    }

    private static void splittOptions(RawUri rawUri) {
        rawUri.queryOptionList = new ArrayList<RawUri.QueryOption>();
        if (rawUri.queryOptionString == null) {
            return;
        }
        List<String> options = UriDecoder.splitt(rawUri.queryOptionString, '&');
        for (String option : options) {
            if (option.length() == 0) continue;
            List<String> pair = UriDecoder.splittFirst(option, '=');
            rawUri.queryOptionList.add(new RawUri.QueryOption(pair.get(0), pair.get(1)));
        }
    }

    private static List<String> splittFirst(String input, char c) {
        int pos = input.indexOf(c, 0);
        if (pos >= 0) {
            return Arrays.asList(input.substring(0, pos), input.substring(pos + 1));
        }
        return Arrays.asList(input, "");
    }

    public static void splittPath(RawUri rawUri, int scipSegments) {
        List<String> list = UriDecoder.splitt(rawUri.path, '/');
        if (list.get(0).length() == 0) {
            ++scipSegments;
        }
        rawUri.pathSegmentList = scipSegments > 0 ? list.subList(scipSegments, list.size()) : list;
    }

    public static List<String> splitt(String input, char c) {
        LinkedList<String> list = new LinkedList<String>();
        int start = 0;
        int end = -1;
        while ((end = input.indexOf(c, start)) >= 0) {
            list.add(input.substring(start, end));
            start = end + 1;
        }
        list.add(input.substring(start));
        return list;
    }

    public static String decode(String encoded) {
        return Decoder.decode((String)encoded);
    }
}

