/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.AcceptType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.RepresentationType;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.core.ContentNegotiatorException;

public class ContentNegotiator {
    private ContentNegotiator() {
    }

    private static List<ContentType> getDefaultSupportedContentTypes(RepresentationType type) {
        switch (type) {
            case METADATA: {
                return Arrays.asList(ContentType.APPLICATION_XML);
            }
            case MEDIA: 
            case BINARY: {
                return Arrays.asList(ContentType.APPLICATION_OCTET_STREAM);
            }
            case VALUE: 
            case COUNT: {
                return Arrays.asList(ContentType.TEXT_PLAIN);
            }
            case BATCH: {
                return Arrays.asList(ContentType.MULTIPART_MIXED);
            }
        }
        return Arrays.asList(ODataFormat.JSON.getContentType(ODataServiceVersion.V40), ODataFormat.JSON_NO_METADATA.getContentType(ODataServiceVersion.V40));
    }

    private static List<ContentType> getSupportedContentTypes(CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        List result;
        List defaultSupportedContentTypes = ContentNegotiator.getDefaultSupportedContentTypes(representationType);
        List list = result = customContentTypeSupport == null ? defaultSupportedContentTypes : customContentTypeSupport.modifySupportedContentTypes(defaultSupportedContentTypes, representationType);
        if (result == null || result.isEmpty()) {
            throw new ContentNegotiatorException("No content type has been specified as supported.", ContentNegotiatorException.MessageKeys.NO_CONTENT_TYPE_SUPPORTED, new String[0]);
        }
        return result;
    }

    public static ContentType doContentNegotiation(FormatOption formatOption, ODataRequest request, CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        List<ContentType> supportedContentTypes = ContentNegotiator.getSupportedContentTypes(customContentTypeSupport, representationType);
        String acceptHeaderValue = request.getHeader("Accept");
        ContentType result = null;
        if (formatOption != null && formatOption.getFormat() != null) {
            String formatString = formatOption.getFormat().trim();
            ODataFormat format = ODataFormat.JSON.name().equalsIgnoreCase(formatString) ? ODataFormat.JSON : (ODataFormat.XML.name().equalsIgnoreCase(formatString) ? ODataFormat.XML : (ODataFormat.ATOM.name().equalsIgnoreCase(formatString) ? ODataFormat.ATOM : null));
            try {
                result = ContentNegotiator.getAcceptedType(AcceptType.fromContentType((ContentType)(format == null ? ContentType.create((String)formatOption.getFormat()) : format.getContentType(ODataServiceVersion.V40))), supportedContentTypes);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (result == null) {
                throw new ContentNegotiatorException("Unsupported $format = " + formatString, ContentNegotiatorException.MessageKeys.UNSUPPORTED_FORMAT_OPTION, formatString);
            }
        } else if (acceptHeaderValue != null) {
            List acceptedContentTypes = AcceptType.create((String)acceptHeaderValue);
            try {
                result = ContentNegotiator.getAcceptedType(acceptedContentTypes, supportedContentTypes);
            }
            catch (IllegalArgumentException e) {
                throw new ContentNegotiatorException("charset in accept header not supported: " + acceptHeaderValue, e, ContentNegotiatorException.MessageKeys.WRONG_CHARSET_IN_HEADER, "Accept", acceptHeaderValue);
            }
            if (result == null) {
                throw new ContentNegotiatorException("unsupported accept content type: " + acceptedContentTypes + " != " + supportedContentTypes, ContentNegotiatorException.MessageKeys.UNSUPPORTED_CONTENT_TYPES, acceptedContentTypes.toString());
            }
        } else {
            ContentType requestedContentType = ContentNegotiator.getDefaultSupportedContentTypes(representationType).get(0);
            result = ContentNegotiator.getAcceptedType(AcceptType.fromContentType((ContentType)requestedContentType), supportedContentTypes);
            if (result == null) {
                throw new ContentNegotiatorException("unsupported accept content type: " + requestedContentType + " != " + supportedContentTypes, ContentNegotiatorException.MessageKeys.UNSUPPORTED_CONTENT_TYPE, requestedContentType.toContentTypeString());
            }
        }
        return result;
    }

    private static ContentType getAcceptedType(List<AcceptType> acceptedContentTypes, List<ContentType> supportedContentTypes) {
        for (AcceptType acceptedType : acceptedContentTypes) {
            Iterator<ContentType> i$ = supportedContentTypes.iterator();
            while (i$.hasNext()) {
                ContentType supportedContentType;
                ContentType contentType = supportedContentType = i$.next();
                if (acceptedType.getParameters().containsKey("charset")) {
                    String value = (String)acceptedType.getParameters().get("charset");
                    if ("utf8".equalsIgnoreCase(value) || "utf-8".equalsIgnoreCase(value)) {
                        contentType = ContentType.create((ContentType)contentType, (String[])new String[]{"charset=utf-8"});
                    } else {
                        throw new IllegalArgumentException("charset not supported: " + acceptedType);
                    }
                }
                if (!acceptedType.matches(contentType)) continue;
                return contentType;
            }
        }
        return null;
    }

    public static void checkSupport(ContentType contentType, CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        for (ContentType supportedContentType : ContentNegotiator.getSupportedContentTypes(customContentTypeSupport, representationType)) {
            if (!((AcceptType)AcceptType.fromContentType((ContentType)supportedContentType).get(0)).matches(contentType)) continue;
            return;
        }
        throw new ContentNegotiatorException("unsupported content type: " + contentType, ContentNegotiatorException.MessageKeys.UNSUPPORTED_CONTENT_TYPE, contentType.toContentTypeString());
    }

    public static boolean isSupported(ContentType contentType, CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        for (ContentType supportedContentType : ContentNegotiator.getSupportedContentTypes(customContentTypeSupport, representationType)) {
            if (!((AcceptType)AcceptType.fromContentType((ContentType)supportedContentType).get(0)).matches(contentType)) continue;
            return true;
        }
        return false;
    }
}

