/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.batch.exception.BatchDeserializerException;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.processor.ActionComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionComplexProcessor;
import org.apache.olingo.server.api.processor.ActionEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionEntityProcessor;
import org.apache.olingo.server.api.processor.ActionPrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionPrimitiveProcessor;
import org.apache.olingo.server.api.processor.BatchProcessor;
import org.apache.olingo.server.api.processor.ComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ComplexProcessor;
import org.apache.olingo.server.api.processor.CountComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.CountEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.CountPrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.DefaultProcessor;
import org.apache.olingo.server.api.processor.EntityCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.ErrorProcessor;
import org.apache.olingo.server.api.processor.MediaEntityProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.PrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.PrimitiveProcessor;
import org.apache.olingo.server.api.processor.PrimitiveValueProcessor;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.processor.ReferenceCollectionProcessor;
import org.apache.olingo.server.api.processor.ReferenceProcessor;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.RepresentationType;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.core.ContentNegotiator;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.DefaultRedirectProcessor;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.RedirectProcessor;
import org.apache.olingo.server.core.batchhandler.BatchHandler;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;
import org.apache.olingo.server.core.uri.validator.UriValidator;

public class ODataHandler {
    private final OData odata;
    private final ServiceMetadata serviceMetadata;
    private List<Processor> processors = new LinkedList<Processor>();
    private CustomContentTypeSupport customContentTypeSupport = null;
    private UriInfo uriInfo;

    public ODataHandler(OData server, ServiceMetadata serviceMetadata) {
        this.odata = server;
        this.serviceMetadata = serviceMetadata;
        this.register((Processor)new DefaultProcessor());
        this.register(new DefaultRedirectProcessor());
    }

    public ODataResponse process(ODataRequest request) {
        ODataResponse response = new ODataResponse();
        try {
            this.processInternal(request, response);
        }
        catch (UriValidationException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (UriParserSemanticException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (UriParserSyntaxException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (UriParserException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (ContentNegotiatorException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (SerializerException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (BatchDeserializerException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (DeserializerException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject((ODataTranslatedException)e, null);
            this.handleException(request, response, serverError);
        }
        catch (ODataHandlerException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError);
        }
        catch (ODataApplicationException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e);
            this.handleException(request, response, serverError);
        }
        catch (Exception e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e);
            this.handleException(request, response, serverError);
        }
        return response;
    }

    private void processInternal(ODataRequest request, ODataResponse response) throws ODataHandlerException, UriParserException, UriValidationException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        this.validateODataVersion(request, response);
        this.uriInfo = new Parser().parseUri(request.getRawODataPath(), request.getRawQueryPath(), null, this.serviceMetadata.getEdm());
        HttpMethod method = request.getMethod();
        new UriValidator().validate(this.uriInfo, method);
        switch (this.uriInfo.getKind()) {
            case metadata: {
                if (method == HttpMethod.GET) {
                    ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.METADATA);
                    this.selectProcessor(MetadataProcessor.class).readMetadata(request, response, this.uriInfo, requestedContentType);
                    break;
                }
                throw new ODataHandlerException("HttpMethod " + method + " not allowed for metadata document", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
            }
            case service: {
                if (method == HttpMethod.GET) {
                    if ("".equals(request.getRawODataPath())) {
                        this.selectProcessor(RedirectProcessor.class).redirect(request, response);
                        break;
                    }
                    ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.SERVICE);
                    this.selectProcessor(ServiceDocumentProcessor.class).readServiceDocument(request, response, this.uriInfo, requestedContentType);
                    break;
                }
                throw new ODataHandlerException("HttpMethod " + method + " not allowed for service document", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
            }
            case resource: {
                this.handleResourceDispatching(request, response);
                break;
            }
            case batch: {
                if (method == HttpMethod.POST) {
                    BatchProcessor bp = this.selectProcessor(BatchProcessor.class);
                    BatchHandler handler = new BatchHandler(this, bp);
                    handler.process(request, response, true);
                    break;
                }
                throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
            }
            default: {
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    public void handleException(ODataRequest request, ODataResponse response, ODataServerError serverError) {
        ContentType requestedContentType;
        ErrorProcessor exceptionProcessor;
        try {
            exceptionProcessor = this.selectProcessor(ErrorProcessor.class);
        }
        catch (ODataHandlerException e) {
            exceptionProcessor = new DefaultProcessor();
        }
        try {
            requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo == null ? null : this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ERROR);
        }
        catch (ContentNegotiatorException e) {
            requestedContentType = ODataFormat.JSON.getContentType(ODataServiceVersion.V40);
        }
        exceptionProcessor.processError(request, response, serverError, requestedContentType);
    }

    private void handleResourceDispatching(ODataRequest request, ODataResponse response) throws ODataHandlerException, ContentNegotiatorException, ODataApplicationException, SerializerException, DeserializerException {
        int lastPathSegmentIndex = this.uriInfo.getUriResourceParts().size() - 1;
        UriResource lastPathSegment = (UriResource)this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        switch (lastPathSegment.getKind()) {
            case action: {
                this.handleActionDispatching(request, response, (UriResourceAction)lastPathSegment);
                break;
            }
            case function: {
                this.handleFunctionDispatching(request, response, (UriResourceFunction)lastPathSegment);
                break;
            }
            case entitySet: 
            case navigationProperty: {
                this.handleEntityDispatching(request, response, (UriResourcePartTyped)lastPathSegment);
                break;
            }
            case count: {
                this.handleCountDispatching(request, response, lastPathSegmentIndex);
                break;
            }
            case primitiveProperty: {
                this.handlePrimitivePropertyDispatching(request, response, false, ((UriResourceProperty)lastPathSegment).isCollection());
                break;
            }
            case complexProperty: {
                this.handleComplexPropertyDispatching(request, response, false, ((UriResourceProperty)lastPathSegment).isCollection());
                break;
            }
            case value: {
                this.handleValueDispatching(request, response, lastPathSegmentIndex);
                break;
            }
            case ref: {
                this.handleReferenceDispatching(request, response, lastPathSegmentIndex);
                break;
            }
            default: {
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void handleFunctionDispatching(ODataRequest request, ODataResponse response, UriResourceFunction uriResourceFunction) throws ODataHandlerException, SerializerException, ContentNegotiatorException, ODataApplicationException, DeserializerException {
        HttpMethod method = request.getMethod();
        if (method != HttpMethod.GET) {
            throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
        }
        EdmFunctionImport functionImport = uriResourceFunction.getFunctionImport();
        if (functionImport == null) {
            throw new ODataHandlerException("Bound functions are not implemented yet", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
        }
        List unboundFunctions = functionImport.getUnboundFunctions();
        if (unboundFunctions == null || unboundFunctions.isEmpty()) {
            throw new ODataHandlerException("No unbound function defined for function import", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
        }
        EdmReturnType returnType = ((EdmFunction)unboundFunctions.get(0)).getReturnType();
        this.handleOperationDispatching(request, response, false, returnType);
    }

    private void handleActionDispatching(ODataRequest request, ODataResponse response, UriResourceAction uriResourceAction) throws ODataHandlerException, SerializerException, ContentNegotiatorException, ODataApplicationException, DeserializerException {
        HttpMethod method = request.getMethod();
        if (request.getMethod() != HttpMethod.POST) {
            throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
        }
        EdmActionImport actionImport = uriResourceAction.getActionImport();
        if (actionImport == null) {
            throw new ODataHandlerException("Bound actions are not implemented yet", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
        }
        EdmAction unboundActions = actionImport.getUnboundAction();
        if (unboundActions == null) {
            throw new ODataHandlerException("No unbound function defined for function import", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
        }
        EdmReturnType returnType = unboundActions.getReturnType();
        this.handleOperationDispatching(request, response, true, returnType);
    }

    private void handleOperationDispatching(ODataRequest request, ODataResponse response, boolean isAction, EdmReturnType edmReturnTypeKind) throws ODataHandlerException, SerializerException, ContentNegotiatorException, ODataApplicationException, DeserializerException {
        switch (edmReturnTypeKind.getType().getKind()) {
            case ENTITY: {
                this.handleEntityDispatching(request, response, edmReturnTypeKind.isCollection(), false, isAction);
                break;
            }
            case PRIMITIVE: {
                this.handlePrimitivePropertyDispatching(request, response, isAction, edmReturnTypeKind.isCollection());
                break;
            }
            case COMPLEX: {
                this.handleComplexPropertyDispatching(request, response, isAction, edmReturnTypeKind.isCollection());
                break;
            }
            default: {
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleReferenceDispatching(ODataRequest request, ODataResponse response, int lastPathSegmentIndex) throws ContentNegotiatorException, ODataApplicationException, SerializerException, ODataHandlerException, DeserializerException {
        HttpMethod method = request.getMethod();
        if (((UriResourcePartTyped)this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1)).isCollection()) {
            if (method == HttpMethod.GET) {
                ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.COLLECTION_REFERENCE);
                this.selectProcessor(ReferenceCollectionProcessor.class).readReferenceCollection(request, response, this.uriInfo, responseFormat);
                return;
            } else {
                if (method != HttpMethod.POST) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
                ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
                this.checkContentTypeSupport(requestFormat, RepresentationType.REFERENCE);
                this.selectProcessor(ReferenceProcessor.class).createReference(request, response, this.uriInfo, requestFormat);
            }
            return;
        } else if (method == HttpMethod.GET) {
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.REFERENCE);
            this.selectProcessor(ReferenceProcessor.class).readReference(request, response, this.uriInfo, responseFormat);
            return;
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, RepresentationType.REFERENCE);
            this.selectProcessor(ReferenceProcessor.class).updateReference(request, response, this.uriInfo, requestFormat);
            return;
        } else {
            if (method != HttpMethod.DELETE) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
            this.selectProcessor(ReferenceProcessor.class).deleteReference(request, response, this.uriInfo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleValueDispatching(ODataRequest request, ODataResponse response, int lastPathSegmentIndex) throws ContentNegotiatorException, ODataApplicationException, SerializerException, ODataHandlerException, DeserializerException {
        HttpMethod method = request.getMethod();
        UriResource resource = (UriResource)this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1);
        if (resource instanceof UriResourceProperty) {
            RepresentationType valueRepresentationType;
            RepresentationType representationType = valueRepresentationType = ((UriResourceProperty)resource).getType() == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Binary) ? RepresentationType.BINARY : RepresentationType.VALUE;
            if (method == HttpMethod.GET) {
                ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, valueRepresentationType);
                this.selectProcessor(PrimitiveValueProcessor.class).readPrimitiveValue(request, response, this.uriInfo, requestedContentType);
                return;
            } else if (method == HttpMethod.PUT) {
                ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
                this.checkContentTypeSupport(requestFormat, valueRepresentationType);
                ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, valueRepresentationType);
                this.selectProcessor(PrimitiveValueProcessor.class).updatePrimitive(request, response, this.uriInfo, requestFormat, responseFormat);
                return;
            } else {
                if (method != HttpMethod.DELETE) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
                this.selectProcessor(PrimitiveValueProcessor.class).deletePrimitive(request, response, this.uriInfo);
            }
            return;
        } else if (method == HttpMethod.GET) {
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.MEDIA);
            this.selectProcessor(MediaEntityProcessor.class).readMediaEntity(request, response, this.uriInfo, requestedContentType);
            return;
        } else if (method == HttpMethod.PUT) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
            this.selectProcessor(MediaEntityProcessor.class).updateMediaEntity(request, response, this.uriInfo, requestFormat, responseFormat);
            return;
        } else {
            if (method != HttpMethod.DELETE) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
            this.selectProcessor(MediaEntityProcessor.class).deleteEntity(request, response, this.uriInfo);
        }
    }

    private void handleComplexPropertyDispatching(ODataRequest request, ODataResponse response, boolean isAction, boolean isCollection) throws ContentNegotiatorException, ODataApplicationException, SerializerException, ODataHandlerException, DeserializerException {
        RepresentationType complexRepresentationType;
        HttpMethod method = request.getMethod();
        RepresentationType representationType = complexRepresentationType = isCollection ? RepresentationType.COLLECTION_COMPLEX : RepresentationType.COMPLEX;
        if (method == HttpMethod.GET) {
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, complexRepresentationType);
            if (complexRepresentationType == RepresentationType.COMPLEX) {
                this.selectProcessor(ComplexProcessor.class).readComplex(request, response, this.uriInfo, requestedContentType);
            } else {
                this.selectProcessor(ComplexCollectionProcessor.class).readComplexCollection(request, response, this.uriInfo, requestedContentType);
            }
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, complexRepresentationType);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, complexRepresentationType);
            if (complexRepresentationType == RepresentationType.COMPLEX) {
                this.selectProcessor(ComplexProcessor.class).updateComplex(request, response, this.uriInfo, requestFormat, responseFormat);
            } else {
                this.selectProcessor(ComplexCollectionProcessor.class).updateComplexCollection(request, response, this.uriInfo, requestFormat, responseFormat);
            }
        } else if (method == HttpMethod.POST && isAction) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, complexRepresentationType);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, complexRepresentationType);
            if (complexRepresentationType == RepresentationType.COMPLEX) {
                this.selectProcessor(ActionComplexProcessor.class).processActionComplex(request, response, this.uriInfo, requestFormat, responseFormat);
            } else {
                this.selectProcessor(ActionComplexCollectionProcessor.class).processActionComplexCollection(request, response, this.uriInfo, requestFormat, responseFormat);
            }
        } else if (method == HttpMethod.DELETE) {
            if (complexRepresentationType == RepresentationType.COMPLEX) {
                this.selectProcessor(ComplexProcessor.class).deleteComplex(request, response, this.uriInfo);
            } else {
                this.selectProcessor(ComplexCollectionProcessor.class).deleteComplexCollection(request, response, this.uriInfo);
            }
        } else {
            throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
        }
    }

    private void handlePrimitivePropertyDispatching(ODataRequest request, ODataResponse response, boolean isAction, boolean isCollection) throws ContentNegotiatorException, ODataApplicationException, SerializerException, ODataHandlerException, DeserializerException {
        RepresentationType representationType;
        HttpMethod method = request.getMethod();
        RepresentationType representationType2 = representationType = isCollection ? RepresentationType.COLLECTION_PRIMITIVE : RepresentationType.PRIMITIVE;
        if (method == HttpMethod.GET) {
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, representationType);
            if (representationType == RepresentationType.PRIMITIVE) {
                this.selectProcessor(PrimitiveProcessor.class).readPrimitive(request, response, this.uriInfo, requestedContentType);
            } else {
                this.selectProcessor(PrimitiveCollectionProcessor.class).readPrimitiveCollection(request, response, this.uriInfo, requestedContentType);
            }
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, representationType);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, representationType);
            if (representationType == RepresentationType.PRIMITIVE) {
                this.selectProcessor(PrimitiveProcessor.class).updatePrimitive(request, response, this.uriInfo, requestFormat, responseFormat);
            } else {
                this.selectProcessor(PrimitiveCollectionProcessor.class).updatePrimitiveCollection(request, response, this.uriInfo, requestFormat, responseFormat);
            }
        } else if (method == HttpMethod.DELETE) {
            if (representationType == RepresentationType.PRIMITIVE) {
                this.selectProcessor(PrimitiveProcessor.class).deletePrimitive(request, response, this.uriInfo);
            } else {
                this.selectProcessor(PrimitiveCollectionProcessor.class).deletePrimitiveCollection(request, response, this.uriInfo);
            }
        } else if (method == HttpMethod.POST && isAction) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, representationType);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, representationType);
            if (representationType == RepresentationType.PRIMITIVE) {
                this.selectProcessor(ActionPrimitiveProcessor.class).processActionPrimitive(request, response, this.uriInfo, requestFormat, responseFormat);
            } else {
                this.selectProcessor(ActionPrimitiveCollectionProcessor.class).processActionPrimitiveCollection(request, response, this.uriInfo, requestFormat, responseFormat);
            }
        } else {
            throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
        }
    }

    private void handleCountDispatching(ODataRequest request, ODataResponse response, int lastPathSegmentIndex) throws ODataApplicationException, SerializerException, ODataHandlerException {
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.GET) {
            UriResource resource = (UriResource)this.uriInfo.getUriResourceParts().get(lastPathSegmentIndex - 1);
            if (resource instanceof UriResourceEntitySet || resource instanceof UriResourceNavigation) {
                this.selectProcessor(CountEntityCollectionProcessor.class).countEntityCollection(request, response, this.uriInfo);
            } else if (resource instanceof UriResourcePrimitiveProperty) {
                this.selectProcessor(CountPrimitiveCollectionProcessor.class).countPrimitiveCollection(request, response, this.uriInfo);
            } else {
                this.selectProcessor(CountComplexCollectionProcessor.class).countComplexCollection(request, response, this.uriInfo);
            }
        } else {
            throw new ODataHandlerException("HTTP method " + method + " is not allowed for count.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
        }
    }

    private void handleEntityDispatching(ODataRequest request, ODataResponse response, UriResourcePartTyped uriResourcePart) throws ContentNegotiatorException, ODataApplicationException, SerializerException, ODataHandlerException, DeserializerException {
        this.handleEntityDispatching(request, response, uriResourcePart.isCollection(), this.isMedia((UriResource)uriResourcePart), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEntityDispatching(ODataRequest request, ODataResponse response, boolean isCollection, boolean isMedia, boolean isAction) throws ContentNegotiatorException, ODataApplicationException, SerializerException, ODataHandlerException, DeserializerException {
        HttpMethod method = request.getMethod();
        if (isCollection) {
            if (method == HttpMethod.GET) {
                ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.COLLECTION_ENTITY);
                this.selectProcessor(EntityCollectionProcessor.class).readEntityCollection(request, response, this.uriInfo, requestedContentType);
                return;
            } else {
                if (method != HttpMethod.POST) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
                ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
                if (isMedia) {
                    ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
                    this.selectProcessor(MediaEntityProcessor.class).createMediaEntity(request, response, this.uriInfo, requestFormat, responseFormat);
                    return;
                } else if (isAction) {
                    this.checkContentTypeSupport(requestFormat, RepresentationType.ENTITY);
                    ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
                    this.selectProcessor(ActionEntityCollectionProcessor.class).processActionEntityCollection(request, response, this.uriInfo, requestFormat, responseFormat);
                    return;
                } else {
                    this.checkContentTypeSupport(requestFormat, RepresentationType.ENTITY);
                    ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
                    this.selectProcessor(EntityProcessor.class).createEntity(request, response, this.uriInfo, requestFormat, responseFormat);
                }
            }
            return;
        } else if (method == HttpMethod.GET) {
            ContentType requestedContentType = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
            this.selectProcessor(EntityProcessor.class).readEntity(request, response, this.uriInfo, requestedContentType);
            return;
        } else if (method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, RepresentationType.ENTITY);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
            this.selectProcessor(EntityProcessor.class).updateEntity(request, response, this.uriInfo, requestFormat, responseFormat);
            return;
        } else if (method == HttpMethod.POST && isAction) {
            ContentType requestFormat = ContentType.parse((String)request.getHeader("Content-Type"));
            this.checkContentTypeSupport(requestFormat, RepresentationType.ENTITY);
            ContentType responseFormat = ContentNegotiator.doContentNegotiation(this.uriInfo.getFormatOption(), request, this.customContentTypeSupport, RepresentationType.ENTITY);
            this.selectProcessor(ActionEntityProcessor.class).processActionEntity(request, response, this.uriInfo, requestFormat, responseFormat);
            return;
        } else {
            if (method != HttpMethod.DELETE) throw new ODataHandlerException("HTTP method " + method + " is not allowed.", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, method.toString());
            ((EntityProcessor)this.selectProcessor(isMedia ? MediaEntityProcessor.class : EntityProcessor.class)).deleteEntity(request, response, this.uriInfo);
        }
    }

    private void checkContentTypeSupport(ContentType requestFormat, RepresentationType representationType) throws ODataHandlerException, ContentNegotiatorException {
        if (!ContentNegotiator.isSupported(requestFormat, this.customContentTypeSupport, representationType)) {
            String contentTypeString = requestFormat.toContentTypeString();
            throw new ODataHandlerException("ContentType " + contentTypeString + " is not supported.", ODataHandlerException.MessageKeys.UNSUPPORTED_CONTENT_TYPE, contentTypeString);
        }
    }

    private void validateODataVersion(ODataRequest request, ODataResponse response) throws ODataHandlerException {
        String maxVersion = request.getHeader("OData-MaxVersion");
        response.setHeader("OData-Version", ODataServiceVersion.V40.toString());
        if (maxVersion != null && ODataServiceVersion.isBiggerThan((String)ODataServiceVersion.V40.toString(), (String)maxVersion)) {
            throw new ODataHandlerException("ODataVersion not supported: " + maxVersion, ODataHandlerException.MessageKeys.ODATA_VERSION_NOT_SUPPORTED, maxVersion);
        }
    }

    private boolean isMedia(UriResource pathSegment) {
        return pathSegment instanceof UriResourceEntitySet && ((UriResourceEntitySet)pathSegment).getEntityType().hasStream() || pathSegment instanceof UriResourceNavigation && ((EdmEntityType)((UriResourceNavigation)pathSegment).getType()).hasStream();
    }

    private <T extends Processor> T selectProcessor(Class<T> cls) throws ODataHandlerException {
        for (Processor processor : this.processors) {
            if (!cls.isAssignableFrom(processor.getClass())) continue;
            processor.init(this.odata, this.serviceMetadata);
            return (T)((Processor)cls.cast(processor));
        }
        throw new ODataHandlerException("Processor: " + cls.getSimpleName() + " not registered.", ODataHandlerException.MessageKeys.PROCESSOR_NOT_IMPLEMENTED, cls.getSimpleName());
    }

    public void register(Processor processor) {
        this.processors.add(0, processor);
    }

    public void register(CustomContentTypeSupport customContentTypeSupport) {
        this.customContentTypeSupport = customContentTypeSupport;
    }
}

